/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.compat.jei;

import com.coolerpromc.resourcestrees.block.ModBlocks;
import com.coolerpromc.resourcestrees.compat.jei.category.TreeSimulatorCategory;
import com.coolerpromc.resourcestrees.compat.jei.subtype.ResourcesTypeSubtypeInterpreter;
import com.coolerpromc.resourcestrees.item.ModItems;
import com.coolerpromc.resourcestrees.recipe.ModRecipes;
import com.coolerpromc.resourcestrees.recipe.custom.TreeSimulatorRecipe;
import com.coolerpromc.resourcestrees.screen.custom.TreeSimulatorScreen;
import com.coolerpromc.resourcestrees.util.RecipeViewerFiller;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.common.util.RegistryUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeHolder;

@JeiPlugin
public class ModJEIPlugin
implements IModPlugin {
    public static final RecipeType<TreeSimulatorRecipe> TREE_SIMULATOR_TYPE = RecipeType.create((String)"resourcestrees", (String)"tree_simulator", TreeSimulatorRecipe.class);

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"resourcestrees", (String)"jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new TreeSimulatorCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(ModBlocks.TREE_SIMULATOR.toStack(), new RecipeType[]{TREE_SIMULATOR_TYPE});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList<RecipeHolder<TreeSimulatorRecipe>> treeSimulatorRecipe = new ArrayList<RecipeHolder<TreeSimulatorRecipe>>(Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.TREE_SIMULATOR_TYPE.get()));
        List<ResourceLocation> keys = treeSimulatorRecipe.stream().map(RecipeHolder::id).toList();
        treeSimulatorRecipe.addAll(RecipeViewerFiller.addUndefinedRecipes((HolderLookup.Provider)RegistryUtil.getRegistryAccess(), keys));
        registration.addRecipes(TREE_SIMULATOR_TYPE, treeSimulatorRecipe.stream().map(RecipeHolder::value).toList());
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(ModBlocks.RESOURCES_OAK_SAPLING.asItem(), (ISubtypeInterpreter)ResourcesTypeSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(ModBlocks.RESOURCES_SPRUCE_SAPLING.asItem(), (ISubtypeInterpreter)ResourcesTypeSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(ModBlocks.RESOURCES_BIRCH_SAPLING.asItem(), (ISubtypeInterpreter)ResourcesTypeSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(ModBlocks.RESOURCES_JUNGLE_SAPLING.asItem(), (ISubtypeInterpreter)ResourcesTypeSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(ModBlocks.RESOURCES_ACACIA_SAPLING.asItem(), (ISubtypeInterpreter)ResourcesTypeSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(ModBlocks.RESOURCES_DARK_OAK_SAPLING.asItem(), (ISubtypeInterpreter)ResourcesTypeSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(ModBlocks.RESOURCES_CHERRY_SAPLING.asItem(), (ISubtypeInterpreter)ResourcesTypeSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(ModBlocks.RESOURCES_OAK_LEAVES.asItem(), (ISubtypeInterpreter)ResourcesTypeSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(ModBlocks.RESOURCES_SPRUCE_LEAVES.asItem(), (ISubtypeInterpreter)ResourcesTypeSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(ModBlocks.RESOURCES_BIRCH_LEAVES.asItem(), (ISubtypeInterpreter)ResourcesTypeSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(ModBlocks.RESOURCES_JUNGLE_LEAVES.asItem(), (ISubtypeInterpreter)ResourcesTypeSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(ModBlocks.RESOURCES_ACACIA_LEAVES.asItem(), (ISubtypeInterpreter)ResourcesTypeSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(ModBlocks.RESOURCES_DARK_OAK_LEAVES.asItem(), (ISubtypeInterpreter)ResourcesTypeSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(ModBlocks.RESOURCES_CHERRY_LEAVES.asItem(), (ISubtypeInterpreter)ResourcesTypeSubtypeInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter((Item)ModItems.LEAF_FRAGMENT.get(), (ISubtypeInterpreter)ResourcesTypeSubtypeInterpreter.INSTANCE);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(TreeSimulatorScreen.class, 59, 35, 22, 16, new RecipeType[]{TREE_SIMULATOR_TYPE});
    }
}

