/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.compat.rei;

import com.coolerpromc.resourcestrees.ResourcesTrees;
import com.coolerpromc.resourcestrees.block.ModBlocks;
import com.coolerpromc.resourcestrees.compat.rei.category.TreeSimulatorCategory;
import com.coolerpromc.resourcestrees.compat.rei.display.TreeSimulatorDisplay;
import com.coolerpromc.resourcestrees.datacomponent.ModDataComponents;
import com.coolerpromc.resourcestrees.item.ModItems;
import com.coolerpromc.resourcestrees.item.custom.LeafFragmentItem;
import com.coolerpromc.resourcestrees.recipe.ModRecipes;
import com.coolerpromc.resourcestrees.recipe.custom.TreeSimulatorRecipe;
import com.coolerpromc.resourcestrees.screen.custom.TreeSimulatorScreen;
import com.coolerpromc.resourcestrees.util.RecipeViewerFiller;
import dev.architectury.event.EventResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPluginClient;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomShapedDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;

@REIPluginClient
public class ModREIPlugin
implements REIClientPlugin {
    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new TreeSimulatorCategory(), config -> config.addWorkstations(new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ModBlocks.TREE_SIMULATOR.get()))}));
    }

    public void registerDisplays(DisplayRegistry registry) {
        ArrayList<RecipeHolder<TreeSimulatorRecipe>> treeSimulatorRecipe = new ArrayList<RecipeHolder<TreeSimulatorRecipe>>(Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipes.TREE_SIMULATOR_TYPE.get()));
        List<ResourceLocation> keys = treeSimulatorRecipe.stream().map(RecipeHolder::id).toList();
        treeSimulatorRecipe.addAll(RecipeViewerFiller.addUndefinedRecipes((HolderLookup.Provider)BasicDisplay.registryAccess(), keys));
        treeSimulatorRecipe.stream().map(RecipeHolder::value).map(TreeSimulatorDisplay::new).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
        registry.registerVisibilityPredicate((displayCategory, display) -> {
            if (display.getDisplayLocation().isPresent() && displayCategory.getCategoryIdentifier() == BuiltinPlugin.CRAFTING) {
                for (EntryIngredient ing : display.getInputEntries()) {
                    ItemStack stack;
                    Object patt0$temp;
                    if (ing.isEmpty() || !((patt0$temp = ((EntryStack)ing.getFirst()).getValue()) instanceof ItemStack) || !((stack = (ItemStack)patt0$temp).getItem() instanceof LeafFragmentItem)) continue;
                    if (!stack.has(ModDataComponents.TYPE)) {
                        return EventResult.interrupt((Boolean)false);
                    }
                    if (!Objects.equals(stack.get(ModDataComponents.TYPE), ResourcesTrees.id("empty"))) continue;
                    return EventResult.interrupt((Boolean)false);
                }
            }
            return EventResult.interrupt((Boolean)true);
        });
        registry.registerRecipeFiller(ShapedRecipe.class, RecipeType.CRAFTING, recipeEntry -> {
            ShapedRecipe recipe = (ShapedRecipe)recipeEntry.value();
            boolean usesComponents = recipe.getIngredients().stream().anyMatch(ing -> ing.getCustomIngredient() instanceof DataComponentIngredient);
            if (!usesComponents) {
                return null;
            }
            int width = recipe.getWidth();
            int height = recipe.getHeight();
            ArrayList<EntryIngredient> inputs = new ArrayList<EntryIngredient>(width * height);
            for (Ingredient ing2 : recipe.getIngredients()) {
                if (ing2.isEmpty()) {
                    inputs.add(EntryIngredient.empty());
                    continue;
                }
                ICustomIngredient patt0$temp = ing2.getCustomIngredient();
                if (patt0$temp instanceof DataComponentIngredient) {
                    DataComponentIngredient components = (DataComponentIngredient)patt0$temp;
                    List stacks = components.getItems().toList();
                    inputs.add(EntryIngredients.ofItemStacks(stacks));
                    continue;
                }
                inputs.add(EntryIngredients.ofIngredient((Ingredient)ing2));
            }
            EntryIngredient output = EntryIngredients.of((ItemStack)recipe.result);
            return new DefaultCustomShapedDisplay(recipeEntry, inputs, List.of(output), width, height);
        });
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerClickArea(screen -> new Rectangle((screen.width - 176) / 2 + 59, (screen.height - 166) / 2 + 27, 22, 15), TreeSimulatorScreen.class, new CategoryIdentifier[]{TreeSimulatorDisplay.CATEGORY_IDENTIFIER});
    }

    public void registerItemComparators(ItemComparatorRegistry registry) {
        registry.registerComponents(ModBlocks.RESOURCES_OAK_SAPLING.asItem());
        registry.registerComponents(ModBlocks.RESOURCES_SPRUCE_SAPLING.asItem());
        registry.registerComponents(ModBlocks.RESOURCES_BIRCH_SAPLING.asItem());
        registry.registerComponents(ModBlocks.RESOURCES_JUNGLE_SAPLING.asItem());
        registry.registerComponents(ModBlocks.RESOURCES_ACACIA_SAPLING.asItem());
        registry.registerComponents(ModBlocks.RESOURCES_DARK_OAK_SAPLING.asItem());
        registry.registerComponents(ModBlocks.RESOURCES_CHERRY_SAPLING.asItem());
        registry.registerComponents(ModBlocks.RESOURCES_OAK_LEAVES.asItem());
        registry.registerComponents(ModBlocks.RESOURCES_SPRUCE_LEAVES.asItem());
        registry.registerComponents(ModBlocks.RESOURCES_BIRCH_LEAVES.asItem());
        registry.registerComponents(ModBlocks.RESOURCES_JUNGLE_LEAVES.asItem());
        registry.registerComponents(ModBlocks.RESOURCES_ACACIA_LEAVES.asItem());
        registry.registerComponents(ModBlocks.RESOURCES_DARK_OAK_LEAVES.asItem());
        registry.registerComponents(ModBlocks.RESOURCES_CHERRY_LEAVES.asItem());
        registry.registerComponents((Item)ModItems.LEAF_FRAGMENT.get());
    }
}

