/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.block.entity.renderer;

import com.coolerpromc.resourcestrees.block.entity.custom.TreeSimulatorBlockEntity;
import com.coolerpromc.resourcestrees.block.entity.renderstate.TreeSimulatorRenderState;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public record TreeSimulatorBlockEntityRenderer(BlockEntityRendererProvider.Context context) implements BlockEntityRenderer<TreeSimulatorBlockEntity, TreeSimulatorRenderState>
{
    public TreeSimulatorRenderState createRenderState() {
        return new TreeSimulatorRenderState();
    }

    public void extractRenderState(TreeSimulatorBlockEntity blockEntity, TreeSimulatorRenderState renderState, float p_446851_, Vec3 p_445788_, @Nullable ModelFeatureRenderer.CrumblingOverlay p_446944_) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, p_446851_, p_445788_, p_446944_);
        renderState.blockEntity = blockEntity;
        ItemStackRenderState itemStackRenderState = new ItemStackRenderState();
        this.context.itemModelResolver().updateForTopItem(itemStackRenderState, blockEntity.getSapling(), ItemDisplayContext.FIXED, blockEntity.getLevel(), null, 1);
        renderState.itemStackRenderState = itemStackRenderState;
    }

    public void submit(TreeSimulatorRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        TreeSimulatorBlockEntity blockEntity = renderState.blockEntity;
        float scale = (float)blockEntity.getData().get(0) / (float)blockEntity.getData().get(1);
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.scale(scale, scale, scale);
        poseStack.translate(0.0, 0.6, 0.0);
        poseStack.last().rotate((Quaternionfc)new Quaternionf().rotationY((float)Math.toRadians(45.0)));
        renderState.itemStackRenderState.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.scale(scale, scale, scale);
        poseStack.translate(0.0, 0.6, 0.0);
        poseStack.last().rotate((Quaternionfc)new Quaternionf().rotationY((float)Math.toRadians(135.0)));
        renderState.itemStackRenderState.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        poseStack.popPose();
    }
}

