/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.datagen;

import com.coolerpromc.resourcestrees.block.ModBlocks;
import com.coolerpromc.resourcestrees.block.custom.ResourcesSaplingBlock;
import com.coolerpromc.resourcestrees.block.entity.custom.TreeSimulatorBlockEntity;
import com.coolerpromc.resourcestrees.core.ResourcesTypes;
import com.coolerpromc.resourcestrees.datacomponent.ModDataComponents;
import com.coolerpromc.resourcestrees.datagen.recipebuilder.TreeSimulatorRecipeBuilder;
import com.coolerpromc.resourcestrees.item.ModItems;
import com.coolerpromc.resourcestrees.recipe.output.TreeSimulatorOutput;
import com.coolerpromc.resourcestrees.registry.ModRegistries;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;

public class ModRecipeProvider
extends RecipeProvider {
    public static final Map<ResourcesSaplingBlock, Item> SAPLINGS_BY_SAPLINGS = Map.of((ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_OAK_SAPLING.get()), Items.OAK_SAPLING, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_SPRUCE_SAPLING.get()), Items.SPRUCE_SAPLING, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_BIRCH_SAPLING.get()), Items.BIRCH_SAPLING, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_JUNGLE_SAPLING.get()), Items.JUNGLE_SAPLING, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_ACACIA_SAPLING.get()), Items.ACACIA_SAPLING, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_DARK_OAK_SAPLING.get()), Items.DARK_OAK_SAPLING, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_CHERRY_SAPLING.get()), Items.CHERRY_SAPLING, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_PALE_OAK_SAPLING.get()), Items.PALE_OAK_SAPLING);
    private final HolderGetter<Item> items;
    private final HolderGetter<ResourcesTypes> types;
    private final HolderLookup.Provider lookupProvider;

    public ModRecipeProvider(HolderLookup.Provider lookupProvider, RecipeOutput output) {
        super(lookupProvider, output);
        this.items = lookupProvider.lookupOrThrow(Registries.ITEM);
        this.types = lookupProvider.lookupOrThrow(ModRegistries.RESOURCES_TYPES_KEY);
        this.lookupProvider = lookupProvider;
    }

    protected void buildRecipes() {
        this.circleShape(Items.COBBLESTONE, 12, ResourcesTypes.STONE);
        this.circleSurroundedShape(Items.STONE, 12, ResourcesTypes.STONE, ResourcesTypes.COAL);
        this.circleShape(Items.COAL, 12, ResourcesTypes.COAL);
        this.circleShape(Items.IRON_INGOT, 6, ResourcesTypes.IRON);
        this.circleShape(Items.COPPER_INGOT, 8, ResourcesTypes.COPPER);
        this.circleShape(Items.GOLD_INGOT, 6, ResourcesTypes.GOLD);
        this.circleShape(Items.LAPIS_LAZULI, 12, ResourcesTypes.LAPIS);
        this.cubeShape(Items.EMERALD, 4, ResourcesTypes.EMERALD);
        this.cubeShape(Items.DIAMOND, 4, ResourcesTypes.DIAMOND);
        this.circleShape(Items.OBSIDIAN, 6, ResourcesTypes.OBSIDIAN);
        this.lineShape(Items.AMETHYST_SHARD, 6, ResourcesTypes.AMETHYST);
        this.cubeShape(Items.NETHERITE_INGOT, 1, ResourcesTypes.NETHERITE);
        this.lineShape(Items.QUARTZ, 8, ResourcesTypes.QUARTZ);
        this.lineShape(Items.PRISMARINE_SHARD, 8, ResourcesTypes.PRISMARINE);
        this.lineShape(Items.GLOWSTONE_DUST, 8, ResourcesTypes.GLOWSTONE);
        this.circleShape(Items.REDSTONE, 12, ResourcesTypes.REDSTONE);
        this.customShape(Items.OAK_LOG, 8, ResourcesTypes.WOOD, " A ", " A ", " A ");
        this.lineShape(Items.BIRCH_LOG, 8, ResourcesTypes.WOOD);
        this.customShape(Items.JUNGLE_LOG, 8, ResourcesTypes.WOOD, "A  ", " A ", "  A");
        this.customShape(Items.SPRUCE_LOG, 8, ResourcesTypes.WOOD, "  A", " A ", "A  ");
        this.customShape(Items.ACACIA_LOG, 8, ResourcesTypes.WOOD, "  A", " A ", " A ");
        this.customShape(Items.DARK_OAK_LOG, 8, ResourcesTypes.WOOD, "A  ", " A ", " A ");
        this.customShape(Items.CHERRY_LOG, 8, ResourcesTypes.WOOD, " A ", " A ", "A  ");
        this.customShape(Items.PALE_OAK_LOG, 8, ResourcesTypes.WOOD, " A ", " A ", "  A");
        this.customShape(Items.BAMBOO_BLOCK, 8, ResourcesTypes.WOOD, "   ", "AA ", "  A");
        this.customShape(Items.CRIMSON_STEM, 8, ResourcesTypes.WOOD, "A  ", " AA", "   ");
        this.customShape(Items.WARPED_STEM, 8, ResourcesTypes.WOOD, "   ", " AA", "A  ");
        this.circleShape(Items.COBBLED_DEEPSLATE, 12, ResourcesTypes.DEEPSLATE);
        this.circleSurroundedShape(Items.DEEPSLATE, 12, ResourcesTypes.DEEPSLATE, ResourcesTypes.COAL);
        this.circleSurroundedShape(Items.TUFF, 12, ResourcesTypes.STONE, ResourcesTypes.DEEPSLATE);
        this.circleShape(Items.DIRT, 12, ResourcesTypes.DIRT);
        this.twoByTwoShape(Items.SAND, 8, ResourcesTypes.DIRT, ResourcesTypes.FIRE);
        this.circleSurroundedShapeWithItem(Items.RED_SAND, 8, ResourcesTypes.FIRE, Items.SAND);
        this.circleShape(Items.NETHERRACK, 12, ResourcesTypes.NETHER);
        this.circleSurroundedShape(Items.BASALT, 12, ResourcesTypes.NETHER, ResourcesTypes.STONE);
        this.circleSurroundedShape(Items.END_STONE, 12, ResourcesTypes.END, ResourcesTypes.STONE);
        this.circleSurroundedShape(Items.GRASS_BLOCK, 12, ResourcesTypes.DIRT, ResourcesTypes.NATURE);
        this.twoItemCustomShape(Items.PODZOL, 12, ResourcesTypes.DIRT, ResourcesTypes.WOOD, "AAA", "ABA", "AAA");
        this.circleSurroundedShapeWithItem(Items.MYCELIUM, 12, ResourcesTypes.DIRT, Items.BROWN_MUSHROOM_BLOCK);
        this.twoByTwoShape(Items.CLAY, 8, ResourcesTypes.DIRT, ResourcesTypes.WATER);
        this.circleSurroundedShapeWithItem(Items.MUD, 12, ResourcesTypes.WATER, Items.CLAY_BALL);
        this.circleSurroundedShapeWithItem(Items.GRAVEL, 12, ResourcesTypes.STONE, Items.SAND);
        this.circleShape(Items.ICE, 12, ResourcesTypes.ICE);
        this.circleSurroundedShape(Items.SNOW, 12, ResourcesTypes.ICE, ResourcesTypes.WATER);
        this.circleSurroundedShape(Items.MOSS_BLOCK, 12, ResourcesTypes.NATURE, ResourcesTypes.DIRT);
        this.circleSurroundedShape(Items.MAGMA_BLOCK, 12, ResourcesTypes.NETHER, ResourcesTypes.FIRE);
        this.twoItemCustomShape(Items.CRIMSON_NYLIUM, 12, ResourcesTypes.NETHER, ResourcesTypes.NATURE, "BBB", "ABA", "AAA");
        this.twoItemCustomShape(Items.WARPED_NYLIUM, 12, ResourcesTypes.NETHER, ResourcesTypes.NATURE, "BBB", "BAB", "AAA");
        this.circleSurroundedShapeWithItem(Items.SOUL_SAND, 12, ResourcesTypes.NETHER, Items.SAND);
        this.circleSurroundedShape(Items.SOUL_SOIL, 12, ResourcesTypes.NETHER, ResourcesTypes.DIRT);
        this.twoItemCustomShape(Items.OAK_SAPLING, 6, ResourcesTypes.WOOD, ResourcesTypes.NATURE, "   ", "ABA", "   ");
        this.twoItemCustomShape(Items.SPRUCE_SAPLING, 6, ResourcesTypes.WOOD, ResourcesTypes.NATURE, " A ", " B ", " A ");
        this.twoItemCustomShape(Items.BIRCH_SAPLING, 6, ResourcesTypes.WOOD, ResourcesTypes.NATURE, "A  ", " B ", "  A");
        this.twoItemCustomShape(Items.JUNGLE_SAPLING, 6, ResourcesTypes.WOOD, ResourcesTypes.NATURE, "  A", " B ", "A  ");
        this.twoItemCustomShape(Items.ACACIA_SAPLING, 6, ResourcesTypes.WOOD, ResourcesTypes.NATURE, "  A", " B ", " A ");
        this.twoItemCustomShape(Items.DARK_OAK_SAPLING, 6, ResourcesTypes.WOOD, ResourcesTypes.NATURE, "A  ", " B ", " A ");
        this.twoItemCustomShape(Items.MANGROVE_PROPAGULE, 6, ResourcesTypes.WOOD, ResourcesTypes.NATURE, " A ", " B ", "  A");
        this.twoItemCustomShape(Items.CHERRY_SAPLING, 6, ResourcesTypes.WOOD, ResourcesTypes.NATURE, " A ", " B ", "A  ");
        this.twoItemCustomShape(Items.PALE_OAK_SAPLING, 6, ResourcesTypes.WOOD, ResourcesTypes.NATURE, "   ", " BA", "A  ");
        this.twoItemCustomShape(Items.BROWN_MUSHROOM, 6, ResourcesTypes.NATURE, ResourcesTypes.DIRT, " A ", " B ", "A  ");
        this.twoItemCustomShape(Items.RED_MUSHROOM, 6, ResourcesTypes.NATURE, ResourcesTypes.DIRT, "ABA", "   ", "   ");
        this.twoItemCustomShape(Items.CRIMSON_FUNGUS, 6, ResourcesTypes.NATURE, ResourcesTypes.NETHER, "ABA", "   ", "   ");
        this.twoItemCustomShape(Items.WARPED_FUNGUS, 6, ResourcesTypes.NATURE, ResourcesTypes.NETHER, " A ", " B ", " A ");
        this.customShape(Items.SUGAR_CANE, 12, ResourcesTypes.NATURE, "A A", "A A", "A A");
        this.customShape(Items.CACTUS, 12, ResourcesTypes.NATURE, "AA ", "AA ", "   ");
        this.twoByTwoShape(Items.CHORUS_PLANT, 8, ResourcesTypes.END, ResourcesTypes.NATURE);
        this.lineShape(Items.LILY_PAD, 12, ResourcesTypes.NATURE);
        this.twoItemCustomShape(Items.KELP, 12, ResourcesTypes.NATURE, ResourcesTypes.WATER, "  A", " B ", "A  ");
        this.customShape(Items.PUMPKIN, 12, ResourcesTypes.NATURE, "AAA", "AAA", "   ");
        this.customShape(Items.APPLE, 12, ResourcesTypes.NATURE, "AAA", "A A", "AAA");
        this.customShape(Items.MELON_SLICE, 12, ResourcesTypes.NATURE, "A  ", " A ", "  A");
        this.customShape(Items.SWEET_BERRIES, 12, ResourcesTypes.NATURE, "  A", " A ", "A  ");
        this.customShape(Items.CARROT, 12, ResourcesTypes.NATURE, " A ", " A ", " A ");
        this.customShape(Items.POTATO, 12, ResourcesTypes.NATURE, "   ", " AA", "A  ");
        this.customShape(Items.BEETROOT, 12, ResourcesTypes.NATURE, "  A", " AA", "A  ");
        this.customShape(Items.WHEAT, 12, ResourcesTypes.NATURE, "  A", "AA ", "   ");
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, ModBlocks.TREE_SIMULATOR, (int)1).pattern("   ").pattern("ABA").pattern("AAA").define(Character.valueOf('A'), (ItemLike)Items.CYAN_TERRACOTTA).define(Character.valueOf('B'), (ItemLike)Items.GRASS_BLOCK).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.GRASS_BLOCK), this.has((ItemLike)Items.GRASS_BLOCK)).save(this.output);
        this.essenceItem((Item)ModItems.FIRE_ESSENCE.get(), Items.FIRE_CHARGE, Items.MAGMA_BLOCK, Items.LAVA_BUCKET);
        this.essenceItem((Item)ModItems.NATURE_ESSENCE.get(), Items.GRASS_BLOCK, Items.MOSS_BLOCK, Items.PUMPKIN, Items.MELON, Items.SUGAR_CANE, Items.CACTUS, Items.WHEAT, Items.CARROT, Items.POTATO);
        this.essenceItem((Item)ModItems.END_ESSENCE.get(), Items.END_STONE, Items.CHORUS_FRUIT, Items.CHORUS_PLANT, Items.PURPUR_BLOCK);
        this.essenceItem((Item)ModItems.WATER_ESSENCE.get(), Items.WATER_BUCKET, Items.KELP, Items.SEAGRASS, Items.CLAY_BALL);
        ResourcesTypes.getAllResourcesTypes(this.lookupProvider).forEach((key, value) -> {
            Field[] fields;
            for (Field field : fields = ModBlocks.class.getDeclaredFields()) {
                try {
                    Supplier supplier;
                    Object patt0$temp;
                    Object obj = field.get(null);
                    if (!(obj instanceof Supplier) || !((patt0$temp = (supplier = (Supplier)obj).get()) instanceof ResourcesSaplingBlock)) continue;
                    ResourcesSaplingBlock resourcesSaplingBlock = (ResourcesSaplingBlock)((Object)((Object)patt0$temp));
                    ItemStack sapling = resourcesSaplingBlock.asItem().getDefaultInstance();
                    sapling.set(ModDataComponents.TYPE, key);
                    if (value.material().left().isPresent()) {
                        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)sapling).pattern(" A ").pattern("ABA").pattern(" A ").define(Character.valueOf('A'), (ItemLike)BuiltInRegistries.ITEM.getValue((ResourceLocation)value.material().left().get())).define(Character.valueOf('B'), (ItemLike)SAPLINGS_BY_SAPLINGS.get((Object)resourcesSaplingBlock)).unlockedBy(ModRecipeProvider.getHasName(ModItems.LEAF_FRAGMENT), this.has((ItemLike)ModItems.LEAF_FRAGMENT)).save(this.output, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)key.withSuffix(BuiltInRegistries.BLOCK.getKey((Object)resourcesSaplingBlock).getPath().substring(9)).withPrefix("saplings/")));
                    } else if (value.material().right().isPresent()) {
                        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemStack)sapling).pattern(" A ").pattern("ABA").pattern(" A ").define(Character.valueOf('A'), (TagKey)value.material().right().get()).define(Character.valueOf('B'), (ItemLike)SAPLINGS_BY_SAPLINGS.get((Object)resourcesSaplingBlock)).unlockedBy(ModRecipeProvider.getHasName(ModItems.LEAF_FRAGMENT), this.has((ItemLike)ModItems.LEAF_FRAGMENT)).save(this.output, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)key.withSuffix(BuiltInRegistries.BLOCK.getKey((Object)resourcesSaplingBlock).getPath().substring(9)).withPrefix("saplings/")));
                    }
                    ItemStack leaf = ModItems.LEAF_FRAGMENT.toStack();
                    leaf.set(ModDataComponents.TYPE, key);
                    TreeSimulatorRecipeBuilder.builder().setTree(sapling).addDrops(TreeSimulatorOutput.of(TreeSimulatorBlockEntity.LOG_BY_SAPLINGS.get((Object)resourcesSaplingBlock).getDefaultInstance(), 1.0f, 2, 4)).addDrops(TreeSimulatorOutput.of(leaf, 1.0f, 1, 1)).addDrops(TreeSimulatorOutput.of(leaf, value.secondaryDropChance(), 1, 1)).addDrops(TreeSimulatorOutput.of(sapling, value.saplingChance(), 1, 1)).addDrops(TreeSimulatorOutput.of(Items.STICK.getDefaultInstance(), 0.1f, 1, 2)).addDrops(TreeSimulatorOutput.of(Items.APPLE.getDefaultInstance(), 0.05f, 1, 1)).addDrops(TreeSimulatorOutput.of(SAPLINGS_BY_SAPLINGS.get((Object)resourcesSaplingBlock).getDefaultInstance(), 0.1f, 1, 1)).setTicksToGrow(1200).save(this.output, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)key.withSuffix(BuiltInRegistries.BLOCK.getKey((Object)resourcesSaplingBlock).getPath().substring(9)).withPrefix("tree_simulator/")));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void essenceItem(Item ouputItem, Item ... inputItems) {
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)ouputItem, (int)1);
        for (Item item : inputItems) {
            builder.requires((ItemLike)item);
        }
        builder.unlockedBy(ModRecipeProvider.getHasName((ItemLike)inputItems[0]), this.has((ItemLike)inputItems[0])).save(this.output);
    }

    private void circleShape(Item outputItem, int count, ResourceKey<ResourcesTypes> resourceType) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)count).pattern("AAA").pattern("A A").pattern("AAA").define(Character.valueOf('A'), DataComponentIngredient.of((boolean)true, (DataComponentType)((DataComponentType)ModDataComponents.TYPE.get()), (Object)this.types.getOrThrow(resourceType).key().location(), (ItemLike[])new ItemLike[]{ModItems.LEAF_FRAGMENT})).unlockedBy(ModRecipeProvider.getHasName(ModItems.LEAF_FRAGMENT), this.has((ItemLike)ModItems.LEAF_FRAGMENT)).save(this.output, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)resourceType.location().withSuffix("_fragment_to_" + ModRecipeProvider.getItemName((ItemLike)outputItem)).withPrefix("fragment_crafting/")));
    }

    private void circleSurroundedShapeWithItem(Item outputItem, int count, ResourceKey<ResourcesTypes> resourceType, Item item) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)count).pattern("AAA").pattern("ABA").pattern("AAA").define(Character.valueOf('B'), DataComponentIngredient.of((boolean)true, (DataComponentType)((DataComponentType)ModDataComponents.TYPE.get()), (Object)this.types.getOrThrow(resourceType).key().location(), (ItemLike[])new ItemLike[]{ModItems.LEAF_FRAGMENT})).define(Character.valueOf('A'), (ItemLike)item).unlockedBy(ModRecipeProvider.getHasName(ModItems.LEAF_FRAGMENT), this.has((ItemLike)ModItems.LEAF_FRAGMENT)).save(this.output, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)resourceType.location().withSuffix("_fragment_to_" + ModRecipeProvider.getItemName((ItemLike)outputItem)).withPrefix("fragment_crafting/")));
    }

    private void circleSurroundedShape(Item outputItem, int count, ResourceKey<ResourcesTypes> resourceType, ResourceKey<ResourcesTypes> middleResourceType) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)count).pattern("AAA").pattern("ABA").pattern("AAA").define(Character.valueOf('A'), DataComponentIngredient.of((boolean)true, (DataComponentType)((DataComponentType)ModDataComponents.TYPE.get()), (Object)this.types.getOrThrow(resourceType).key().location(), (ItemLike[])new ItemLike[]{ModItems.LEAF_FRAGMENT})).define(Character.valueOf('B'), DataComponentIngredient.of((boolean)true, (DataComponentType)((DataComponentType)ModDataComponents.TYPE.get()), (Object)this.types.getOrThrow(middleResourceType).key().location(), (ItemLike[])new ItemLike[]{ModItems.LEAF_FRAGMENT})).unlockedBy(ModRecipeProvider.getHasName(ModItems.LEAF_FRAGMENT), this.has((ItemLike)ModItems.LEAF_FRAGMENT)).save(this.output, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)resourceType.location().withSuffix("_fragment_to_" + ModRecipeProvider.getItemName((ItemLike)outputItem)).withPrefix("fragment_crafting/")));
    }

    private void twoByTwoShape(Item outputItem, int count, ResourceKey<ResourcesTypes> resourceType, ResourceKey<ResourcesTypes> middleResourceType) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)count).pattern("BA ").pattern("AB ").pattern("   ").define(Character.valueOf('A'), DataComponentIngredient.of((boolean)true, (DataComponentType)((DataComponentType)ModDataComponents.TYPE.get()), (Object)this.types.getOrThrow(resourceType).key().location(), (ItemLike[])new ItemLike[]{ModItems.LEAF_FRAGMENT})).define(Character.valueOf('B'), DataComponentIngredient.of((boolean)true, (DataComponentType)((DataComponentType)ModDataComponents.TYPE.get()), (Object)this.types.getOrThrow(middleResourceType).key().location(), (ItemLike[])new ItemLike[]{ModItems.LEAF_FRAGMENT})).unlockedBy(ModRecipeProvider.getHasName(ModItems.LEAF_FRAGMENT), this.has((ItemLike)ModItems.LEAF_FRAGMENT)).save(this.output, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)resourceType.location().withSuffix("_fragment_to_" + ModRecipeProvider.getItemName((ItemLike)outputItem)).withPrefix("fragment_crafting/")));
    }

    private void cubeShape(Item outputItem, int count, ResourceKey<ResourcesTypes> resourceType) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)count).pattern("AAA").pattern("AAA").pattern("AAA").define(Character.valueOf('A'), DataComponentIngredient.of((boolean)true, (DataComponentType)((DataComponentType)ModDataComponents.TYPE.get()), (Object)this.types.getOrThrow(resourceType).key().location(), (ItemLike[])new ItemLike[]{ModItems.LEAF_FRAGMENT})).unlockedBy(ModRecipeProvider.getHasName(ModItems.LEAF_FRAGMENT), this.has((ItemLike)ModItems.LEAF_FRAGMENT)).save(this.output, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)resourceType.location().withSuffix("_fragment_to_" + ModRecipeProvider.getItemName((ItemLike)outputItem)).withPrefix("fragment_crafting/")));
    }

    private void lineShape(Item outputItem, int count, ResourceKey<ResourcesTypes> resourceType) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)count).pattern("   ").pattern("AAA").pattern("   ").define(Character.valueOf('A'), DataComponentIngredient.of((boolean)true, (DataComponentType)((DataComponentType)ModDataComponents.TYPE.get()), (Object)this.types.getOrThrow(resourceType).key().location(), (ItemLike[])new ItemLike[]{ModItems.LEAF_FRAGMENT})).unlockedBy(ModRecipeProvider.getHasName(ModItems.LEAF_FRAGMENT), this.has((ItemLike)ModItems.LEAF_FRAGMENT)).save(this.output, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)resourceType.location().withSuffix("_fragment_to_" + ModRecipeProvider.getItemName((ItemLike)outputItem)).withPrefix("fragment_crafting/")));
    }

    private void customShape(Item outputItem, int count, ResourceKey<ResourcesTypes> resourceType, String line1, String line2, String line3) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)count).pattern(line1).pattern(line2).pattern(line3).define(Character.valueOf('A'), DataComponentIngredient.of((boolean)true, (DataComponentType)((DataComponentType)ModDataComponents.TYPE.get()), (Object)this.types.getOrThrow(resourceType).key().location(), (ItemLike[])new ItemLike[]{ModItems.LEAF_FRAGMENT})).unlockedBy(ModRecipeProvider.getHasName(ModItems.LEAF_FRAGMENT), this.has((ItemLike)ModItems.LEAF_FRAGMENT)).save(this.output, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)resourceType.location().withSuffix("_fragment_to_" + ModRecipeProvider.getItemName((ItemLike)outputItem)).withPrefix("fragment_crafting/")));
    }

    private void twoItemCustomShape(Item outputItem, int count, ResourceKey<ResourcesTypes> resourceType, ResourceKey<ResourcesTypes> resourceType2, String line1, String line2, String line3) {
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)count).pattern(line1).pattern(line2).pattern(line3).define(Character.valueOf('A'), DataComponentIngredient.of((boolean)true, (DataComponentType)((DataComponentType)ModDataComponents.TYPE.get()), (Object)this.types.getOrThrow(resourceType).key().location(), (ItemLike[])new ItemLike[]{ModItems.LEAF_FRAGMENT})).define(Character.valueOf('B'), DataComponentIngredient.of((boolean)true, (DataComponentType)((DataComponentType)ModDataComponents.TYPE.get()), (Object)this.types.getOrThrow(resourceType2).key().location(), (ItemLike[])new ItemLike[]{ModItems.LEAF_FRAGMENT})).unlockedBy(ModRecipeProvider.getHasName(ModItems.LEAF_FRAGMENT), this.has((ItemLike)ModItems.LEAF_FRAGMENT)).save(this.output, ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)resourceType.location().withSuffix("_fragment_to_" + ModRecipeProvider.getItemName((ItemLike)outputItem)).withPrefix("fragment_crafting/")));
    }

    public static final class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider lookupProvider, RecipeOutput output) {
            return new ModRecipeProvider(lookupProvider, output);
        }

        public String getName() {
            return "Resources Trees recipes";
        }
    }
}

