/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.datagen.model;

import com.coolerpromc.resourcestrees.core.ResourcesTypes;
import com.coolerpromc.resourcestrees.datacomponent.ModDataComponents;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public record ResourcesTypeTintSource(int defaultColor) implements ItemTintSource
{
    public static final MapCodec<ResourcesTypeTintSource> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.ARGB_COLOR_CODEC.fieldOf("default").forGetter(ResourcesTypeTintSource::defaultColor)).apply((Applicative)instance, ResourcesTypeTintSource::new));

    public int calculate(ItemStack itemStack, @Nullable ClientLevel clientLevel, @Nullable LivingEntity livingEntity) {
        ResourcesTypes types = ResourcesTypes.byId((ResourceLocation)itemStack.get((DataComponentType)ModDataComponents.TYPE.get()), (Level)clientLevel);
        if (types != null) {
            return types.color();
        }
        return this.defaultColor;
    }

    public MapCodec<? extends ItemTintSource> type() {
        return MAP_CODEC;
    }
}

