/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.blocks.entities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.AquariumBlock;
import lv.id.bonne.animalpen.blocks.entities.AnimalPenBlockInterface;
import lv.id.bonne.animalpen.interfaces.AnimalPenInterface;
import lv.id.bonne.animalpen.items.AnimalContainerItem;
import lv.id.bonne.animalpen.network.packets.UpdateVariantScreenData;
import lv.id.bonne.animalpen.registries.AnimalPenTileEntityRegistry;
import lv.id.bonne.animalpen.registries.AnimalPensItemRegistry;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AquariumTileEntity
extends BlockEntity
implements AnimalPenBlockInterface<WaterAnimal> {
    private final SimpleContainer inventory = new SimpleContainer(1){

        public boolean m_7013_(int slot, ItemStack stack) {
            return stack.m_150930_((Item)AnimalPensItemRegistry.ANIMAL_CONTAINER.get());
        }

        public void m_6596_() {
            super.m_6596_();
            AquariumTileEntity.this.triggerUpdate();
        }
    };
    private WaterAnimal storedAnimal;
    private long displaySize = -1L;
    private UUID ownerUUID;
    private long protectedAmount = 0L;
    private int tickCounter;
    private final List<Integer> deathTicker = new ArrayList<Integer>();
    public static final String TAG_INVENTORY = "inventory";
    public static final String TAG_DEATH_TICKER = "death_ticker";
    public static final String TAG_DISPLAY_SIZE = "display_size";
    public static final String TAG_OWNER_UUID = "owner_uuid";
    public static final String TAG_KEEP_AMOUNT = "keep_amount";

    public AquariumTileEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)AnimalPenTileEntityRegistry.AQUARIUM_TILE_ENTITY.get(), blockPos, blockState);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(TAG_INVENTORY, (Tag)this.inventory.m_7927_());
        tag.m_128365_(TAG_DEATH_TICKER, (Tag)new IntArrayTag(this.deathTicker));
        tag.m_128356_(TAG_DISPLAY_SIZE, this.displaySize);
        this.getOwner().ifPresent(owner -> tag.m_128362_(TAG_OWNER_UUID, owner));
        tag.m_128356_(TAG_KEEP_AMOUNT, this.protectedAmount);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.m_6211_();
        this.deathTicker.clear();
        this.storedAnimal = null;
        if (tag.m_128425_(TAG_INVENTORY, 9)) {
            this.inventory.m_7797_(tag.m_128437_(TAG_INVENTORY, 10));
        }
        if (tag.m_128425_(TAG_DEATH_TICKER, 11)) {
            int[] intArray;
            for (int i : intArray = tag.m_128465_(TAG_DEATH_TICKER)) {
                this.deathTicker.add(i);
            }
        }
        this.displaySize = tag.m_128425_(TAG_DISPLAY_SIZE, 4) ? tag.m_128454_(TAG_DISPLAY_SIZE) : -1L;
        if (tag.m_128441_(TAG_OWNER_UUID)) {
            this.ownerUUID = tag.m_128342_(TAG_OWNER_UUID);
        }
        this.protectedAmount = tag.m_128454_(TAG_KEEP_AMOUNT);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public Optional<WaterAnimal> getStoredAnimal() {
        if (this.storedAnimal == null && !this.getItemStack().m_41619_()) {
            CompoundTag tag = this.getItemStack().m_41784_();
            if (!tag.m_128441_("id") || this.f_58857_ == null) {
                return Optional.ofNullable(this.storedAnimal);
            }
            EntityType.m_20642_((CompoundTag)tag, (Level)this.f_58857_).map(entity -> (WaterAnimal)entity).ifPresent(animal -> {
                this.storedAnimal = animal;
            });
        } else if (this.storedAnimal != null && this.getItemStack().m_41619_()) {
            this.storedAnimal = null;
        }
        return Optional.ofNullable(this.storedAnimal);
    }

    public List<Integer> getDeathTicker() {
        return this.deathTicker;
    }

    public int getTickCounter() {
        return this.tickCounter;
    }

    public void tick() {
        ++this.tickCounter;
        if (this.m_58904_() == null || this.m_58904_().m_5776_()) {
            return;
        }
        boolean updated = this.getStoredAnimal().map(animal -> ((AnimalPenInterface)animal).animalPenTick(this)).orElse(false);
        for (int i = 0; i < this.deathTicker.size(); ++i) {
            this.deathTicker.set(i, this.deathTicker.get(i) + 1);
            updated = true;
        }
        this.deathTicker.removeIf(integer -> integer > 20);
        if (updated) {
            this.triggerUpdate();
        }
    }

    public boolean processContainer(Player player, InteractionHand interactionHand) {
        if (this.getOwner().isPresent() && !this.getOwner().get().equals(player.m_20148_())) {
            AnimalPen.sendDebug("Protection is enabled");
            return false;
        }
        if (this.inventory.m_7983_()) {
            ItemStack itemInHand = player.m_21120_(interactionHand);
            if (!itemInHand.m_41784_().m_128441_("id")) {
                return false;
            }
            if (!player.m_9236_().m_5776_()) {
                this.inventory.m_19173_(itemInHand);
                player.m_21008_(interactionHand, ItemStack.f_41583_);
                if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
                    AnimalPen.CHANNEL.sendToPlayers(((ServerLevel)this.f_58857_).m_6907_().stream().filter(other -> other.m_20275_((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_()) < 50.0).toList(), (Object)new UpdateVariantScreenData(this.m_58899_()));
                }
                AnimalPen.sendDebug("Deposit animal cage into pen");
            }
            return true;
        }
        ItemStack itemInHand = player.m_21120_(interactionHand);
        CompoundTag itemInHandTag = itemInHand.m_41784_();
        if (!itemInHandTag.m_128441_("id")) {
            if (!player.m_6047_()) {
                return false;
            }
            if (player.m_9236_().m_5776_()) {
                return true;
            }
            WaterAnimal animal = this.getStoredAnimal().orElse(null);
            if (animal == null) {
                return false;
            }
            long currentCount = ((AnimalPenInterface)animal).animalPenGetCount();
            if (currentCount < 2L) {
                AnimalPen.sendDebug("Cannot split 1");
                return false;
            }
            long newCount = Math.min(currentCount - this.protectedAmount, currentCount / 2L);
            if (newCount <= 0L) {
                AnimalPen.sendDebug("Protected amount prevents from splitting");
                return false;
            }
            if (!((AnimalPenInterface)animal).animalPenUpdateCount(-newCount)) {
                AnimalPen.sendDebug("Fail to reduce animal count");
                return false;
            }
            animal.m_20223_(itemInHandTag);
            itemInHandTag.m_128356_("animal_count", newCount);
            player.m_21008_(interactionHand, itemInHand);
            this.inventory.m_6596_();
            AnimalPen.sendDebug("Half the amount of animals in pen");
            return true;
        }
        WaterAnimal animal = this.getStoredAnimal().orElse(null);
        if (animal == null || !itemInHandTag.m_128461_("id").equals(animal.m_6095_().arch$registryName().toString())) {
            AnimalPen.sendDebug("Different animals");
            return false;
        }
        if (player.m_9236_().m_5776_()) {
            return true;
        }
        long newCount = itemInHandTag.m_128454_("animal_count");
        if (newCount <= 0L || !((AnimalPenInterface)animal).animalPenUpdateCount(newCount)) {
            AnimalPen.sendDebug("Failed to deposit animal");
            return false;
        }
        if (newCount > 1L && !AnimalContainerItem.canMergeAnimalVariants(this.getItemStack(), itemInHand, player)) {
            AnimalPen.sendDebug("Variants could not be merged");
            ((AnimalPenInterface)animal).animalPenUpdateCount(-1L);
            itemInHandTag.m_128356_("animal_count", 1L);
            itemInHand.m_41751_(itemInHandTag);
        } else {
            AnimalContainerItem.mergeAnimalVariants(this.getItemStack(), itemInHand, player);
            itemInHand.m_41751_(new CompoundTag());
            if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
                AnimalPen.CHANNEL.sendToPlayers(((ServerLevel)this.f_58857_).m_6907_().stream().filter(other -> other.m_20275_((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_()) < 50.0).toList(), (Object)new UpdateVariantScreenData(this.m_58899_()));
            }
        }
        player.m_21008_(interactionHand, itemInHand);
        this.inventory.m_6596_();
        AnimalPen.sendDebug("Cage merged into pen");
        return true;
    }

    public boolean interactWithPen(Player player, InteractionHand interactionHand) {
        if (this.getOwner().isPresent() && !this.getOwner().get().equals(player.m_20148_())) {
            AnimalPen.sendDebug("Protection is enabled");
            return false;
        }
        ItemStack itemInHand = player.m_21120_(interactionHand);
        if (itemInHand.m_41619_() && !this.inventory.m_7983_()) {
            if (player.m_6047_() && !player.m_9236_().m_5776_()) {
                ItemStack item = this.getItemStack();
                player.m_21008_(interactionHand, item);
                this.inventory.m_6836_(0, ItemStack.f_41583_);
                this.inventory.m_6596_();
                AnimalPen.sendDebug("Taking out animal cage");
            }
            return true;
        }
        WaterAnimal animal = this.getStoredAnimal().orElse(null);
        if (animal == null) {
            AnimalPen.sendDebug("Animal is not set");
            return false;
        }
        if (((AnimalPenInterface)animal).animalPenInteract(player, interactionHand, this.m_58899_())) {
            AnimalPen.sendDebug("Animal Interaction finished");
            ItemStack item = this.getItemStack();
            Optional<ListTag> optionalVariants = AnimalContainerItem.getAnimalVariants(item);
            CompoundTag tag = new CompoundTag();
            animal.m_20223_(tag);
            optionalVariants.ifPresent(variants -> tag.m_128365_("animal_variants", (Tag)variants));
            item.m_41751_(tag);
            this.inventory.m_6596_();
            return true;
        }
        return false;
    }

    public void attackThePen(Player player, Level level) {
        if (this.getOwner().isPresent() && !this.getOwner().get().equals(player.m_20148_())) {
            AnimalPen.sendDebug("Protection is enabled");
            return;
        }
        ItemStack weapon = player.m_21120_(InteractionHand.MAIN_HAND);
        WaterAnimal animal = this.getStoredAnimal().orElse(null);
        if (animal == null) {
            AnimalPen.sendDebug("Animal Pen is empty");
            return;
        }
        long amount = ((AnimalPenInterface)animal).animalPenGetCount();
        if (amount <= this.protectedAmount) {
            AnimalPen.sendDebug("Protected amount reached");
            return;
        }
        if (!((AnimalPenInterface)animal).animalPenUpdateCount(-1L)) {
            AnimalPen.sendDebug("Failed to update animal count");
            return;
        }
        int fireAspect = EnchantmentHelper.m_44914_((LivingEntity)player);
        if (AnimalPen.config().isIncreaseStatistics()) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)weapon.m_41720_()));
        }
        weapon.m_41622_(1, (LivingEntity)player, playerx -> playerx.m_21190_(InteractionHand.MAIN_HAND));
        this.deathTicker.add(0);
        if (((AnimalPenInterface)animal).animalPenGetCount() <= 0L) {
            ItemStack item = this.getItemStack();
            item.m_41751_(new CompoundTag());
            Block.m_49840_((Level)level, (BlockPos)this.m_58899_().m_7494_(), (ItemStack)item);
            this.inventory.m_6836_(0, ItemStack.f_41583_);
            AnimalPen.sendDebug("Dropping empty cage");
        }
        this.triggerUpdate();
        Vec3 position = new Vec3((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_());
        animal.m_7311_(fireAspect);
        LootTable lootTable = level.m_7654_().m_129898_().m_79217_(animal.m_5743_());
        LootContext.Builder contextBuilder = new LootContext.Builder((ServerLevel)level).m_78972_(LootContextParams.f_81460_, (Object)position).m_78972_(LootContextParams.f_81455_, (Object)animal).m_78972_(LootContextParams.f_81458_, (Object)player).m_78972_(LootContextParams.f_81459_, (Object)player).m_78972_(LootContextParams.f_81456_, (Object)player).m_78972_(LootContextParams.f_81457_, (Object)DamageSource.m_19344_((Player)player)).m_78963_(player.m_36336_()).m_230911_(level.f_46441_);
        lootTable.m_230922_(contextBuilder.m_78975_(LootContextParamSets.f_81415_)).forEach(itemStack -> Block.m_49840_((Level)level, (BlockPos)this.m_58899_().m_7637_(0.5, 1.5, 0.5), (ItemStack)itemStack));
        animal.m_20095_();
        int reward = animal.m_213860_();
        ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)this.f_58857_), (Vec3)position.m_82520_(0.5, 1.5, 0.5), (int)reward);
        if (AnimalPen.config().isTriggerAdvancements()) {
            CriteriaTriggers.f_10568_.m_48104_((ServerPlayer)player, (Entity)animal, DamageSource.m_19344_((Player)player));
        }
        if (AnimalPen.config().isIncreaseStatistics()) {
            player.m_36220_(Stats.f_12936_);
            player.m_36246_(Stats.f_12986_.m_12902_((Object)animal.m_6095_()));
        }
        AnimalPen.sendDebug("Animal Kill process finished");
    }

    public int getRedStoneSignal() {
        return this.getStoredAnimal().map(animal -> ((AnimalPenInterface)animal).getRedStoneSignal()).orElse(0);
    }

    @Override
    public void triggerUpdate() {
        this.m_6596_();
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        this.getStoredAnimal().ifPresent(animal -> animal.m_20223_(this.getItemStack().m_41784_()));
        BlockState oldState = this.m_58900_();
        BlockState newState = this.m_58900_();
        if (((Boolean)oldState.m_61143_((Property)AquariumBlock.FILLED)).booleanValue() == this.inventory.m_7983_()) {
            newState = (BlockState)oldState.m_61124_((Property)AquariumBlock.FILLED, (Comparable)Boolean.valueOf(!this.inventory.m_7983_()));
            this.f_58857_.m_7731_(this.m_58899_(), newState, 2);
            this.m_6596_();
        }
        this.f_58857_.m_7260_(this.m_58899_(), oldState, newState, 2);
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    private ItemStack getItemStack() {
        return this.inventory.m_8020_(0);
    }

    @Override
    public ListTag getEntityVariants() {
        return this.getStoredAnimal().map(animal -> AnimalContainerItem.getAnimalVariants(this.getItemStack()).orElseGet(ListTag::new)).orElseGet(ListTag::new);
    }

    @Override
    public long getAnimalDisplaySize() {
        return this.displaySize < 1L ? this.getAnimalCount() : Math.min(this.displaySize, this.getAnimalCount());
    }

    @Override
    public void setAnimalDisplaySize(long size) {
        this.displaySize = size;
        this.triggerUpdate();
    }

    @Override
    public void updateAnimalVariant(CompoundTag animalVariant) {
        if (animalVariant == null || animalVariant.m_128456_()) {
            return;
        }
        this.getStoredAnimal().ifPresent(animal -> {
            AnimalPen.sendDebug("Animal Variant changed");
            CompoundTag extraData = new CompoundTag();
            ((AnimalPenInterface)animal).animalPenSaveTag(extraData);
            animal.m_20258_(animalVariant);
            ((AnimalPenInterface)animal).animalPenLoadTag(extraData);
            this.triggerUpdate();
            if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
                AnimalPen.CHANNEL.sendToPlayers(((ServerLevel)this.f_58857_).m_6907_().stream().filter(other -> other.m_20275_((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_()) < 50.0).toList(), (Object)new UpdateVariantScreenData(this.m_58899_()));
            }
        });
    }

    @Override
    public void removeAnimalVariant(int index) {
        if (this.getStoredAnimal().isEmpty() || this.getEntityVariants().size() <= index) {
            return;
        }
        this.getEntityVariants().remove(index);
        this.inventory.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            AnimalPen.CHANNEL.sendToPlayers(((ServerLevel)this.f_58857_).m_6907_().stream().filter(other -> other.m_20275_((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_()) < 50.0).toList(), (Object)new UpdateVariantScreenData(this.m_58899_()));
            AnimalPen.sendDebug("Animal variant removed");
        }
    }

    @Override
    public long getAnimalCount() {
        return this.getStoredAnimal().map(animal -> ((AnimalPenInterface)animal).animalPenGetCount()).orElse(0L);
    }

    @Override
    public boolean canGrowEntity() {
        return AnimalPen.config().isGrowWaterAnimals();
    }

    @Override
    public List<Pair<ItemStack[], Component>> getCooldownLines(boolean shortText) {
        return this.getStoredAnimal().map(animal -> ((AnimalPenInterface)animal).animalPenGetLines(this.getTickCounter(), shortText)).orElse(Collections.emptyList());
    }

    @Override
    public long getProtectedAmount() {
        return this.protectedAmount;
    }

    @Override
    public void setProtectedAmount(long amount) {
        this.protectedAmount = amount;
        this.triggerUpdate();
    }

    @Override
    public Optional<UUID> getOwner() {
        return Optional.ofNullable(this.ownerUUID);
    }

    @Override
    public void setOwner(@Nullable UUID owner) {
        this.ownerUUID = owner;
        this.triggerUpdate();
    }
}

