/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.wateranimal;

import java.util.List;
import lv.id.bonne.animalpen.mixin.wateranimal.AnimalPenWaterAnimal;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={AbstractFish.class})
public abstract class AnimalPenAbstractFish
extends AnimalPenWaterAnimal {
    @Shadow
    public abstract void saveToBucketTag(ItemStack var1);

    @Shadow
    protected abstract InteractionResult mobInteract(Player var1, InteractionHand var2);

    protected AnimalPenAbstractFish(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenInteract(Player player, InteractionHand hand, BlockPos position) {
        if (super.animalPen$animalPenInteract(player, hand, position)) {
            return true;
        }
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(Items.WATER_BUCKET)) {
            if (player.level().isClientSide()) {
                return true;
            }
            if (this.animalPen$animalCount <= 1L) {
                return false;
            }
            ItemStack bucket = this.pen$getFishBucket();
            if (bucket == null) {
                return false;
            }
            --this.animalPen$animalCount;
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)bucket, (boolean)false));
            player.level().playSound(null, position, SoundEvents.BUCKET_FILL_FISH, SoundSource.NEUTRAL, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    @Intrinsic
    public ItemStack animalPen$animalPenInteract(ServerLevel level, ItemStack itemStack, BlockPos position) {
        if (itemStack.is(Items.WATER_BUCKET)) {
            if (this.animalPen$animalCount <= 1L) {
                return ItemStack.EMPTY;
            }
            ItemStack bucket = this.pen$getFishBucket();
            if (bucket == null) {
                return ItemStack.EMPTY;
            }
            itemStack.shrink(1);
            level.playSound(null, position, SoundEvents.BUCKET_FILL_FISH, SoundSource.NEUTRAL, 1.0f, 1.0f);
            --this.animalPen$animalCount;
            return bucket;
        }
        return super.animalPen$animalPenInteract(level, itemStack, position);
    }

    @Override
    @Intrinsic
    public List<Pair<ItemStack[], Component>> animalPen$animalPenGetLines(int tick, boolean shortLine) {
        ItemStack bucket;
        List<Pair<ItemStack[], Component>> lines = super.animalPen$animalPenGetLines(tick, shortLine);
        if (shortLine) {
            return lines;
        }
        if (this.animalPen$animalCount > 1L && (bucket = this.pen$getFishBucket()) != null) {
            MutableComponent component = Component.translatable((String)"display.animal_pen.full_ready", (Object[])new Object[]{Component.literal((String)"\ue000"), Component.literal((String)"\ue001")}).withStyle(ChatFormatting.GREEN);
            lines.add((Pair<ItemStack[], Component>)Pair.of((Object)new ItemStack[]{Items.WATER_BUCKET.getDefaultInstance(), bucket}, (Object)component));
        }
        return lines;
    }

    @Unique
    private ItemStack pen$getFishBucket() {
        ItemStack itemStack;
        if (this.getType() == EntityType.COD) {
            itemStack = new ItemStack((ItemLike)Items.COD_BUCKET);
        } else if (this.getType() == EntityType.PUFFERFISH) {
            itemStack = new ItemStack((ItemLike)Items.PUFFERFISH_BUCKET);
        } else if (this.getType() == EntityType.SALMON) {
            itemStack = new ItemStack((ItemLike)Items.SALMON_BUCKET);
        } else if (this.getType() == EntityType.TROPICAL_FISH) {
            itemStack = new ItemStack((ItemLike)Items.TROPICAL_FISH_BUCKET);
        } else if (this.getType() == EntityType.TADPOLE) {
            itemStack = new ItemStack((ItemLike)Items.TADPOLE_BUCKET);
        } else {
            return null;
        }
        this.saveToBucketTag(itemStack);
        return itemStack;
    }
}

