/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.config;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lv.id.bonne.animalpen.config.annotations.JsonComment;
import lv.id.bonne.animalpen.config.annotations.JsonComments;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;

public class Configuration {
    @JsonComments(value={@JsonComment(value="List of cooldowns that are applied when player performs action."), @JsonComment(value="Specifying: `animal_pen:any` will indicate that any entity using that item will have same cooldown."), @JsonComment(value="`minecraft:apple` is universal food item. It is used to indicate for feeding action."), @JsonComment(value="`minecraft:honey_bloc` is used to indicate pollen regeneration cooldown."), @JsonComment(value="<item> : <cooldown>.")})
    @Expose
    @SerializedName(value="cooldowns")
    private Map<class_2960, List<CooldownEntry>> cooldownList = new HashMap<class_2960, List<CooldownEntry>>();
    @JsonComments(value={@JsonComment(value="A cooldown value in game ticks between attacks that players can perform on animal pens."), @JsonComment(value="Default value: 5 game tick")})
    @Expose
    @SerializedName(value="attack_cooldown")
    private Integer attackCooldown;
    @JsonComments(value={@JsonComment(value="List of drop limits for items when player harvests items."), @JsonComment(value="<item> : <drop_limit>.")})
    @Expose
    @SerializedName(value="drop_limits")
    private Map<class_2960, Integer> dropLimitList = new HashMap<class_2960, Integer>();
    @JsonComments(value={@JsonComment(value="Allows to set maximal amount of animals in the pen."), @JsonComment(value="Setting 0 will remove any limit.")})
    @Expose
    @SerializedName(value="animal_limit_in_pen")
    private long maximalAnimalCount = Integer.MAX_VALUE;
    @JsonComments(value={@JsonComment(value="Allows to enable animal growing in animal pen."), @JsonComment(value="The more animals are inside it, the larger it will be.")})
    @Expose
    @SerializedName(value="animals_can_grow")
    private boolean growAnimals = false;
    @JsonComment(value="Allows to change default animal size in pen.")
    @Expose
    @SerializedName(value="animal_size")
    private Float animalSize;
    @JsonComments(value={@JsonComment(value="Allows to enable water animal growing in aquarium."), @JsonComment(value="The more animals are inside it, the larger it will be.")})
    @Expose
    @SerializedName(value="water_animals_can_grow")
    private boolean growWaterAnimals = false;
    @JsonComment(value="Allows to change default water animal size in aquarium.")
    @Expose
    @SerializedName(value="water_animal_size")
    private Float waterAnimalSize;
    @JsonComments(value={@JsonComment(value="Allows to set how fast animals grows in pen and aquarium."), @JsonComment(value="Each animal is multiplied by given value to get end size."), @JsonComment(value="This option works only if animals_can_grow or water_animals_can_grow is enabled."), @JsonComment(value="Default value = 0.001")})
    @Expose
    @SerializedName(value="growth_multiplier")
    private Float growthMultiplier;
    @JsonComments(value={@JsonComment(value="Allows to specify if turtle scute are dropped when player breeds animal (true)."), @JsonComment(value="or when food cooldown timer is finished (false).")})
    @Expose
    @SerializedName(value="turtle_scute_drop_time")
    private boolean dropScuteAtStart = false;
    @JsonComments(value={@JsonComment(value="Allows to set how many different animal variants can be stored per item."), @JsonComment(value="Players will not be able to store more different variants than this value."), @JsonComment(value="Be aware, this increases NBT data size, so not recommended to put infinite amount."), @JsonComment(value="Default value = 16")})
    @Expose
    @SerializedName(value="max_stored_animal_variants")
    private Integer maxStoredAnimalVariants;
    @JsonComments(value={@JsonComment(value="Allows to set if interactions with animal pens/aquariums should trigger advancements."), @JsonComment(value="Triggered Criteria: player_interacted_with_entity, bred_animals, filled_bucket, player_killed_entity"), @JsonComment(value="Default value = false")})
    @Expose
    @SerializedName(value="trigger_advancements")
    private Boolean triggerAdvancements;
    @JsonComments(value={@JsonComment(value="Allows to set if interactions with animal pens/aquariums should increase statistics."), @JsonComment(value="Increased Statistics: Animals Bred, Mob Kills, Use Item <item>, Kill Entity <entity>"), @JsonComment(value="Default value = false")})
    @Expose
    @SerializedName(value="increase_statistics")
    private Boolean increaseStatistics;
    @JsonComments(value={@JsonComment(value="Allows to toggle if cooldowns should be shown only while player is crouching (true)."), @JsonComment(value="or be visible all the time (false)."), @JsonComment(value="Default value = true")})
    @Expose
    @SerializedName(value="show_cooldowns_while_crouching")
    private Boolean showCooldownsOnCrouch;
    @JsonComments(value={@JsonComment(value="Allows to toggle if all interactions (even without cooldown) should be rendered"), @JsonComment(value="above animal pen or aquarium"), @JsonComment(value="Default value = false")})
    @Expose
    @SerializedName(value="show_all_interactions_above")
    private Boolean showAllInteractions;
    @JsonComments(value={@JsonComment(value="Set of animals that are blocked from picking up."), @JsonComment(value="Pickable animals in vanilla minecraft: https://minecraft.wiki/w/Animal#List_of_animals")})
    @Expose
    @SerializedName(value="blocked_animals")
    private Set<class_2960> blockedAnimals = new HashSet<class_2960>();
    @JsonComment(value="Debug code to indicate problems.")
    @Expose
    @SerializedName(value="debug")
    private Boolean debug;
    @JsonComment(value="")
    @Expose(serialize=false, deserialize=false)
    private static final class_2960 ANY = class_2960.method_60655((String)"animal_pen", (String)"any");

    public static Configuration getDefaultConfig() {
        Configuration configuration = new Configuration();
        configuration.setDefaults(true);
        return configuration;
    }

    public boolean isInvalid() {
        return this.dropLimitList == null || this.cooldownList == null || this.blockedAnimals == null || this.waterAnimalSize == null || this.waterAnimalSize.floatValue() <= 0.0f || this.animalSize == null || this.animalSize.floatValue() <= 0.0f || this.growthMultiplier == null || this.growthMultiplier.floatValue() < 0.0f || this.attackCooldown == null || this.attackCooldown < 0 || this.maxStoredAnimalVariants == null || this.triggerAdvancements == null || this.increaseStatistics == null || this.maxStoredAnimalVariants < 0 || this.debug == null || this.showAllInteractions == null || this.showCooldownsOnCrouch == null;
    }

    public void setDefaults(boolean init) {
        if (this.dropLimitList == null || init) {
            this.dropLimitList = new HashMap<class_2960, Integer>();
            this.populateDefaultDropLimits();
        }
        if (this.cooldownList == null || init) {
            this.cooldownList = new HashMap<class_2960, List<CooldownEntry>>();
            this.populateDefaultCooldowns();
        }
        if (this.blockedAnimals == null || init) {
            this.blockedAnimals = new HashSet<class_2960>();
        }
        if (this.animalSize == null || this.animalSize.floatValue() <= 0.0f || init) {
            this.animalSize = Float.valueOf(0.33f);
        }
        if (this.waterAnimalSize == null || this.waterAnimalSize.floatValue() <= 0.0f || init) {
            this.waterAnimalSize = Float.valueOf(0.33f);
        }
        if (this.growthMultiplier == null || this.growthMultiplier.floatValue() < 0.0f || init) {
            this.growthMultiplier = Float.valueOf(0.001f);
        }
        if (this.attackCooldown == null || this.attackCooldown < 0 || init) {
            this.attackCooldown = 5;
        }
        if (this.maxStoredAnimalVariants == null || this.maxStoredAnimalVariants < 0 || init) {
            this.maxStoredAnimalVariants = 16;
        }
        if (this.increaseStatistics == null || init) {
            this.increaseStatistics = false;
        }
        if (this.triggerAdvancements == null || init) {
            this.triggerAdvancements = false;
        }
        if (this.debug == null || init) {
            this.debug = false;
        }
        if (this.showAllInteractions == null || init) {
            this.showAllInteractions = false;
        }
        if (this.showCooldownsOnCrouch == null || init) {
            this.showCooldownsOnCrouch = true;
        }
        if (init) {
            this.maximalAnimalCount = Integer.MAX_VALUE;
            this.growAnimals = false;
            this.growWaterAnimals = false;
            this.dropScuteAtStart = false;
        }
    }

    private void populateDefaultCooldowns() {
        this.cooldownList.computeIfAbsent(class_1802.field_8279.arch$registryName(), i -> new ArrayList()).add(new CooldownEntry(ANY, 1160, 20, 6000));
        this.cooldownList.computeIfAbsent(class_1802.field_8868.arch$registryName(), i -> new ArrayList()).add(new CooldownEntry(class_1299.field_6115.arch$registryName(), 1180, 20, 6000));
        this.cooldownList.computeIfAbsent(class_1802.field_8550.arch$registryName(), i -> new ArrayList()).add(new CooldownEntry(class_1299.field_6132.arch$registryName(), 6020, -20, 1200));
        this.cooldownList.computeIfAbsent(class_1802.field_8550.arch$registryName(), i -> new ArrayList()).add(new CooldownEntry(class_1299.field_6113.arch$registryName(), 6020, -20, 1200));
        this.cooldownList.computeIfAbsent(class_1802.field_21086.arch$registryName(), i -> new ArrayList()).add(new CooldownEntry(class_1299.field_20346.arch$registryName(), 1220, -20, 20));
        this.cooldownList.computeIfAbsent(class_1802.field_8550.arch$registryName(), i -> new ArrayList()).add(new CooldownEntry(class_1299.field_6085.arch$registryName(), 0, 0, 0));
        this.cooldownList.computeIfAbsent(class_1802.field_8428.arch$registryName(), i -> new ArrayList()).add(new CooldownEntry(class_1299.field_6143.arch$registryName(), 0, 0, 0));
        this.cooldownList.computeIfAbsent(class_1802.field_8550.arch$registryName(), i -> new ArrayList()).add(new CooldownEntry(class_1299.field_6143.arch$registryName(), 0, 0, 0));
        this.cooldownList.computeIfAbsent(class_1802.field_8550.arch$registryName(), i -> new ArrayList()).add(new CooldownEntry(class_1299.field_30052.arch$registryName(), 0, 0, 0));
        this.cooldownList.computeIfAbsent(class_1802.field_8354.arch$registryName(), i -> new ArrayList()).add(new CooldownEntry(class_1299.field_37419.arch$registryName(), 6020, -20, 200));
        this.cooldownList.computeIfAbsent(class_1802.field_8550.arch$registryName(), i -> new ArrayList()).add(new CooldownEntry(class_1299.field_42622.arch$registryName(), 6020, -20, 200));
        this.cooldownList.computeIfAbsent(class_1802.field_8428.arch$registryName(), i -> new ArrayList()).add(new CooldownEntry(class_1299.field_42622.arch$registryName(), 6020, -20, 200));
        this.cooldownList.computeIfAbsent(class_1802.field_42716.arch$registryName(), i -> new ArrayList()).add(new CooldownEntry(class_1299.field_47754.arch$registryName(), 10, 0, 10));
    }

    private void populateDefaultDropLimits() {
        this.dropLimitList = new HashMap<class_2960, Integer>();
        this.dropLimitList.put(class_1802.field_8803.arch$registryName(), 80);
        this.dropLimitList.put(class_1802.field_8618.arch$registryName(), 320);
        this.dropLimitList.put(class_1802.field_19044.arch$registryName(), 320);
        this.dropLimitList.put(class_1802.field_37541.arch$registryName(), 320);
        this.dropLimitList.put(class_1802.field_42711.arch$registryName(), 320);
    }

    public int getEntityCooldown(class_1299<?> entity, class_1792 usedItem, long entityAmount) {
        if (!this.cooldownList.containsKey(usedItem.arch$registryName())) {
            return 0;
        }
        Collection cooldownEntries = this.cooldownList.get(usedItem.arch$registryName());
        return cooldownEntries.stream().filter(cooldownEntry -> cooldownEntry.entity.equals((Object)entity.arch$registryName())).findFirst().map(cooldownEntry -> cooldownEntry.getValue(entityAmount)).orElseGet(() -> cooldownEntries.stream().filter(cooldownEntry -> cooldownEntry.entity.equals((Object)ANY)).findFirst().map(cooldownEntry -> cooldownEntry.getValue(entityAmount)).orElse(0));
    }

    public int getDropLimits(class_1792 item) {
        return this.dropLimitList.getOrDefault(item.arch$registryName(), 0);
    }

    public long getMaximalAnimalCount() {
        return this.maximalAnimalCount;
    }

    public boolean isDropScuteAtStart() {
        return this.dropScuteAtStart;
    }

    public boolean isGrowAnimals() {
        return this.growAnimals;
    }

    public float getAnimalSize() {
        return this.animalSize.floatValue();
    }

    public boolean isGrowWaterAnimals() {
        return this.growWaterAnimals;
    }

    public float getWaterAnimalSize() {
        return this.waterAnimalSize.floatValue();
    }

    public Float getGrowthMultiplier() {
        return this.growthMultiplier;
    }

    public boolean isBlocked(class_1299<?> entityType) {
        return this.blockedAnimals.contains(entityType.arch$registryName());
    }

    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    public int getMaxStoredVariants() {
        return this.maxStoredAnimalVariants;
    }

    public boolean isTriggerAdvancements() {
        return this.triggerAdvancements;
    }

    public boolean isIncreaseStatistics() {
        return this.increaseStatistics;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isShowCooldownsOnCrouch() {
        return this.showCooldownsOnCrouch;
    }

    public boolean isShowAllInteractions() {
        return this.showAllInteractions;
    }

    public static class CooldownEntry {
        @JsonComment(value="The entity ID on which cooldown is applied.")
        @Expose
        @SerializedName(value="entity")
        private class_2960 entity;
        @JsonComments(value={@JsonComment(value="The base cooldown value for action."), @JsonComment(value="0 means that there is no cooldown."), @JsonComment(value="Values in game ticks.")})
        @Expose
        @SerializedName(value="base_cooldown")
        private int baseCooldown;
        @JsonComments(value={@JsonComment(value="The increment of cooldown per each animal."), @JsonComment(value="0 means that there is no cooldown increment."), @JsonComment(value="Negative value decreases base cooldown value."), @JsonComment(value="Values in game ticks.")})
        @Expose
        @SerializedName(value="animal_increment")
        private int incrementPerAnimal;
        @JsonComments(value={@JsonComment(value="The the maximal cooldown that can be applied."), @JsonComment(value="0 means that there is no cooldown limitation."), @JsonComment(value="Negative animal_increment makes this act as lowest limit."), @JsonComment(value="Values in game ticks.")})
        @Expose
        @SerializedName(value="cooldown_limit")
        private int cooldownLimit;

        public CooldownEntry(class_2960 entity, int base, int increment, int max) {
            this.entity = entity;
            this.baseCooldown = base;
            this.incrementPerAnimal = increment;
            this.cooldownLimit = max;
        }

        public int getValue(long entityAmount) {
            if (this.incrementPerAnimal > 0) {
                long endValue = (long)this.baseCooldown + entityAmount * (long)this.incrementPerAnimal;
                return (int)Math.min((long)this.cooldownLimit, endValue);
            }
            if (this.incrementPerAnimal < 0) {
                long endValue = (long)this.baseCooldown + entityAmount * (long)this.incrementPerAnimal;
                return (int)Math.max((long)this.cooldownLimit, endValue);
            }
            return this.baseCooldown;
        }
    }
}

