/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkChannel;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.ReloadListenerRegistry;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import lv.id.bonne.animalpen.blocks.behaviour.UseToolsBehaviour;
import lv.id.bonne.animalpen.commands.AnimalPenCommands;
import lv.id.bonne.animalpen.config.Configuration;
import lv.id.bonne.animalpen.config.ConfigurationManager;
import lv.id.bonne.animalpen.listeners.AnimalFoodReloadListener;
import lv.id.bonne.animalpen.mixin.accessors.DispenserBlockAccessor;
import lv.id.bonne.animalpen.network.packets.AnimalFoodRegistryData;
import lv.id.bonne.animalpen.network.packets.RemoveDisplayAnimalData;
import lv.id.bonne.animalpen.network.packets.UpdateConfigurationData;
import lv.id.bonne.animalpen.network.packets.UpdateDisplayAnimalData;
import lv.id.bonne.animalpen.network.packets.UpdateVariantScreenData;
import lv.id.bonne.animalpen.registries.AnimalPenBlockRegistry;
import lv.id.bonne.animalpen.registries.AnimalPenTileEntityRegistry;
import lv.id.bonne.animalpen.registries.AnimalPensCreativeTabRegistry;
import lv.id.bonne.animalpen.registries.AnimalPensItemRegistry;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2315;
import net.minecraft.class_2357;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import org.slf4j.Logger;

public final class AnimalPen {
    public static final String MOD_ID = "animal_pen";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final ConfigurationManager CONFIG_MANAGER = new ConfigurationManager();
    public static final NetworkChannel CHANNEL = NetworkChannel.create((class_2960)new class_2960("animal_pen", "network"));
    public static DateTimeFormatter DATE_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();

    public static void init() {
        AnimalPensCreativeTabRegistry.register();
        AnimalPenBlockRegistry.register();
        AnimalPensItemRegistry.register();
        AnimalPenTileEntityRegistry.register();
        CONFIG_MANAGER.readConfig();
        CommandRegistrationEvent.EVENT.register((dispatcher, selection) -> AnimalPenCommands.register((CommandDispatcher<class_2168>)dispatcher));
        class_2315.method_10009((class_1935)class_1802.field_8868, (class_2357)new UseToolsBehaviour(DispenserBlockAccessor.getDispenserRegistry().get(class_1802.field_8868)));
        class_2315.method_10009((class_1935)class_1802.field_8469, (class_2357)new UseToolsBehaviour(DispenserBlockAccessor.getDispenserRegistry().get(class_1802.field_8469)));
        class_2315.method_10009((class_1935)class_1802.field_8550, (class_2357)new UseToolsBehaviour(DispenserBlockAccessor.getDispenserRegistry().get(class_1802.field_8550)));
        class_2315.method_10009((class_1935)class_1802.field_8428, (class_2357)new UseToolsBehaviour(DispenserBlockAccessor.getDispenserRegistry().get(class_1802.field_8428)));
        class_2315.method_10009((class_1935)class_1802.field_8705, (class_2357)new UseToolsBehaviour(DispenserBlockAccessor.getDispenserRegistry().get(class_1802.field_8705)));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)UpdateDisplayAnimalData.ID, UpdateDisplayAnimalData::handle);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)RemoveDisplayAnimalData.ID, RemoveDisplayAnimalData::handle);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)UpdateConfigurationData.ID, UpdateConfigurationData::handle);
        CHANNEL.register(AnimalFoodRegistryData.class, AnimalFoodRegistryData::encode, AnimalFoodRegistryData::decode, AnimalFoodRegistryData::handle);
        CHANNEL.register(UpdateVariantScreenData.class, UpdateVariantScreenData::encode, UpdateVariantScreenData::decode, UpdateVariantScreenData::handle);
        ReloadListenerRegistry.register((class_3264)class_3264.field_14190, (class_3302)new AnimalFoodReloadListener(), (class_2960)new class_2960(MOD_ID, "animal_foods"));
        PlayerEvent.PLAYER_JOIN.register(player -> CHANNEL.sendToPlayer(player, (Object)AnimalFoodRegistryData.serverData()));
    }

    public static Configuration config() {
        return CONFIG_MANAGER.getConfiguration();
    }

    public static void sendDebug(String message) {
        if (AnimalPen.config().isDebug()) {
            LOGGER.debug(message);
        }
    }
}

