/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.watercreature;

import java.time.LocalTime;
import java.util.LinkedList;
import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.interfaces.AnimalPenInterface;
import lv.id.bonne.animalpen.registries.AnimalPenFoodRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_9866;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_9866.class})
@Implements(value={@Interface(iface=AnimalPenInterface.class, prefix="animalPen$", unique=true)})
public abstract class AnimalPenWaterCreature
extends class_1308 {
    @Unique
    protected int animalPen$foodCooldown = 0;
    @Unique
    protected long animalPen$animalCount = 0L;

    protected AnimalPenWaterCreature(class_1299<? extends class_1308> entityType, class_1937 level) {
        super(entityType, level);
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        this.animalPen$animalPenSaveTag(compoundTag);
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.animalPen$animalPenLoadTag(compoundTag);
    }

    @Intrinsic
    public boolean animalPen$animalPenUpdateCount(long change) {
        if (change < 0L && this.animalPen$animalCount + change < 0L) {
            return false;
        }
        long maxCount = AnimalPen.CONFIG_MANAGER.getConfiguration().getMaximalAnimalCount();
        if (maxCount > 0L && this.animalPen$animalCount + change > maxCount) {
            return false;
        }
        this.animalPen$animalCount += change;
        return true;
    }

    @Intrinsic
    public long animalPen$animalPenGetCount() {
        return this.animalPen$animalCount;
    }

    @Intrinsic
    public boolean animalPen$animalPenTick(class_2586 blockEntity) {
        if (this.animalPen$foodCooldown > 0) {
            --this.animalPen$foodCooldown;
            return true;
        }
        return false;
    }

    @Intrinsic
    public void animalPen$animalPenSaveTag(class_2487 tag) {
        if (this.animalPen$foodCooldown > 0) {
            tag.method_10569("food_cooldown", this.animalPen$foodCooldown);
        }
        tag.method_10544("animal_count", this.animalPen$animalCount);
    }

    @Intrinsic
    public void animalPen$animalPenLoadTag(class_2487 tag) {
        if (tag.method_10573("food_cooldown", 3)) {
            this.animalPen$foodCooldown = tag.method_10550("food_cooldown");
        }
        if (tag.method_10573("animal_count", 4)) {
            this.animalPen$animalCount = tag.method_10537("animal_count");
        }
    }

    @Intrinsic
    public boolean animalPen$animalPenInteract(class_1657 player, class_1268 hand, class_2338 position) {
        class_1799 itemStack = player.method_5998(hand);
        if (AnimalPenFoodRegistry.isFood(this.method_5864().arch$registryName(), itemStack)) {
            if (this.animalPen$foodCooldown > 0) {
                return false;
            }
            long maxCount = AnimalPen.CONFIG_MANAGER.getConfiguration().getMaximalAnimalCount();
            if (maxCount > 0L && this.animalPen$animalCount >= maxCount) {
                return false;
            }
            int stackSize = itemStack.method_7947();
            if ((stackSize = (int)Math.min(this.animalPen$animalCount, (long)stackSize)) < 2) {
                return false;
            }
            if (player.method_37908().method_8608()) {
                return true;
            }
            stackSize = (int)Math.min((maxCount - this.animalPen$animalCount) * 2L, (long)stackSize);
            if (!player.method_31549().field_7477) {
                if (stackSize % 2 == 1) {
                    itemStack.method_7934(stackSize - 1);
                    player.method_6122(hand, itemStack);
                } else {
                    itemStack.method_7934(stackSize);
                    player.method_6122(hand, itemStack);
                }
            }
            this.animalPen$animalCount += (long)(stackSize / 2);
            class_1937 class_19372 = player.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                serverLevel.method_14199((class_2394)class_2398.field_11201, (double)((float)position.method_10263() + 0.5f), (double)position.method_10264() + 1.5, (double)((float)position.method_10260() + 0.5f), 5, 0.2, 0.2, 0.2, 0.05);
            }
            player.method_37908().method_8396(null, position, (class_3414)class_3417.field_20614.comp_349(), class_3419.field_15254, 1.0f, class_3532.method_32750((class_5819)player.method_37908().field_9229, (float)0.8f, (float)1.2f));
            class_3414 soundEvent = this.method_5994();
            if (soundEvent != null) {
                player.method_37908().method_8396(null, position, soundEvent, class_3419.field_15254, 1.0f, 1.0f);
            }
            this.animalPen$foodCooldown = AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.method_5864(), class_1802.field_8279, this.animalPen$animalCount);
            return true;
        }
        return false;
    }

    @Intrinsic
    public class_1799 animalPen$animalPenInteract(class_3218 level, class_1799 itemStack, class_2338 position) {
        return class_1799.field_8037;
    }

    @Intrinsic
    public List<Pair<class_1799[], class_2561>> animalPen$animalPenGetLines(int tick, boolean shortLine) {
        class_1799 foodItem;
        LinkedList<Pair<class_1799[], class_2561>> lines = new LinkedList<Pair<class_1799[], class_2561>>();
        if (shortLine && AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.method_5864(), class_1802.field_8279, this.animalPen$animalCount) == 0) {
            return lines;
        }
        class_5250 component = this.animalPen$foodCooldown == 0 ? class_2561.method_43469((String)(shortLine ? "display.animal_pen.ready" : "display.animal_pen.food_ready"), (Object[])new Object[]{class_2561.method_43470((String)"\ue000"), class_2561.method_43470((String)"\ue001")}).method_27692(class_124.field_1060) : class_2561.method_43469((String)(shortLine ? "display.animal_pen.cooldown" : "display.animal_pen.food_cooldown"), (Object[])new Object[]{class_2561.method_43470((String)"\ue000"), class_2561.method_43470((String)"\ue001"), LocalTime.of(0, 0, 0).plusSeconds(this.animalPen$foodCooldown / 20).format(AnimalPen.DATE_FORMATTER)});
        class_1799[] food = this.animalPen$getFood();
        if (food == null || food.length == 0) {
            return lines;
        }
        if (food.length == 1) {
            foodItem = food[0];
        } else {
            int size = food.length;
            int index = tick / 100 % size;
            foodItem = food[index];
        }
        lines.add((Pair<class_1799[], class_2561>)Pair.of((Object)new class_1799[]{foodItem, foodItem}, (Object)component));
        return lines;
    }

    @Intrinsic
    @Nullable
    public class_1799[] animalPen$getFood() {
        return AnimalPenFoodRegistry.getFood(this.method_5864().arch$registryName());
    }

    @Intrinsic
    public int animalPen$getRedStoneSignal() {
        int value = 1;
        if (this.animalPen$foodCooldown > 0 || this.animalPen$getFood() == null || this.animalPen$getFood().length == 0) {
            return value;
        }
        return value | 2;
    }
}

