/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.blocks.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Objects;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.AnimalPenBlock;
import lv.id.bonne.animalpen.blocks.entities.AquariumTileEntity;
import lv.id.bonne.animalpen.mixin.accessors.EntityAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class AquariumRenderer
implements BlockEntityRenderer<AquariumTileEntity> {
    private final Minecraft minecraft = Minecraft.m_91087_();
    private final Font font;
    private WaterAnimal dyingAnimal;

    public AquariumRenderer() {
        this.font = this.minecraft.f_91062_;
    }

    public void render(AquariumTileEntity tileEntity, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        WaterAnimal animal = tileEntity.getStoredAnimal();
        if (animal == null) {
            return;
        }
        if (this.dyingAnimal == null || this.dyingAnimal.m_6095_() != animal.m_6095_()) {
            this.dyingAnimal = null;
            CompoundTag cloneTag = new CompoundTag();
            animal.m_20223_(cloneTag);
            EntityType.m_20642_((CompoundTag)cloneTag, (Level)tileEntity.m_58904_()).map(entity -> (WaterAnimal)entity).ifPresent(clone -> {
                this.dyingAnimal = clone;
                this.dyingAnimal.m_20124_(Pose.DYING);
                this.dyingAnimal.f_20883_ = 0.0f;
                this.dyingAnimal.m_146922_(0.0f);
                this.dyingAnimal.f_20885_ = 0.0f;
                this.dyingAnimal.f_20886_ = 0.0f;
                this.dyingAnimal.f_19797_ = 0;
                this.dyingAnimal.f_20919_ = 0;
            });
        }
        Direction facing = (Direction)tileEntity.m_58900_().m_61143_((Property)AnimalPenBlock.f_54117_);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.0, 0.5);
        switch (facing) {
            case SOUTH: {
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                break;
            }
            case WEST: {
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                break;
            }
            case EAST: {
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(270.0f));
            }
        }
        poseStack.m_85837_(0.0, 0.0, 0.0);
        this.renderAnimal(animal, tileEntity, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        this.renderCounter(animal, tileEntity, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        if (this.minecraft.f_91074_ != null && this.minecraft.f_91074_.m_6047_()) {
            this.renderTextLines(animal, tileEntity, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        }
        poseStack.m_85849_();
    }

    private void renderAnimal(WaterAnimal animal, AquariumTileEntity tileEntity, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        animal.f_20883_ = 0.0f;
        animal.m_146922_(0.0f);
        animal.f_20885_ = 0.0f;
        animal.f_20886_ = 0.0f;
        animal.m_20124_(Pose.SWIMMING);
        animal.m_20282_(true);
        ((EntityAccessor)animal).setWasTouchingWater(true);
        animal.f_19797_ = tileEntity.getTickCounter();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.75, 0.0);
        float animalSize = AnimalPen.CONFIG_MANAGER.getConfiguration().getWaterAnimalSize();
        poseStack.m_85841_(animalSize, animalSize, animalSize);
        if (AnimalPen.CONFIG_MANAGER.getConfiguration().isGrowWaterAnimals()) {
            float scale = 1.0f + animalSize * (float)tileEntity.getAnimalDisplaySize() * AnimalPen.CONFIG_MANAGER.getConfiguration().getGrowthMultiplier().floatValue();
            poseStack.m_85841_(scale, scale, scale);
        }
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        this.minecraft.m_91290_().m_114382_((Entity)animal).m_7392_((Entity)animal, 0.0f, this.minecraft.m_91296_(), poseStack, buffer, combinedLight);
        CompoundTag cloneTag = new CompoundTag();
        animal.m_20223_(cloneTag);
        tileEntity.getDeathTicker().forEach(tick -> {
            if (this.dyingAnimal != null) {
                this.dyingAnimal.f_20919_ = tick;
                this.minecraft.m_91290_().m_114382_((Entity)this.dyingAnimal).m_7392_((Entity)this.dyingAnimal, 0.0f, this.minecraft.m_91296_(), poseStack, buffer, combinedLight);
            }
        });
        poseStack.m_85849_();
    }

    private void renderCounter(WaterAnimal animal, AquariumTileEntity tileEntity, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        long count = tileEntity.getAnimalCount();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.125, (double)-0.51f);
        TranslatableComponent text = new TranslatableComponent("display.animal_pen.count", new Object[]{count});
        int textWidth = this.font.m_92852_((FormattedText)text);
        float maxWidth = 30.0f;
        float scale = Math.min(1.0f, maxWidth / (float)textWidth) * 0.015f;
        poseStack.m_85841_(-scale, -scale, 0.0f);
        double d = (double)(-textWidth) / 2.0;
        Objects.requireNonNull(this.font);
        poseStack.m_85837_(d, (double)((float)(-9) / 2.0f), 0.0);
        this.font.m_92889_(poseStack, (Component)text, 0.0f, 0.0f, 0xFFFFFF);
        poseStack.m_85849_();
    }

    private void renderTextLines(WaterAnimal animal, AquariumTileEntity tileEntity, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Direction facing;
        Vec3 facingVec;
        List<Pair<ItemStack, Component>> textList = tileEntity.getCooldownLines();
        if (textList.isEmpty()) {
            return;
        }
        BlockPos blockPos = tileEntity.m_58899_();
        Vec3 playerPos = this.minecraft.f_91074_.m_20182_();
        Vec3 toPlayer = new Vec3(playerPos.m_7096_() - (double)blockPos.m_123341_(), 0.0, playerPos.m_7094_() - (double)blockPos.m_123343_());
        if (toPlayer.m_82526_(facingVec = Vec3.m_82528_((Vec3i)(facing = (Direction)tileEntity.m_58900_().m_61143_((Property)AnimalPenBlock.f_54117_)).m_122436_())) < 0.0) {
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        }
        double totalHeight = 1.75 + 0.25 * (double)(textList.size() - 1);
        double maxWidth = 0.0;
        for (Pair<ItemStack, Component> pair : textList) {
            maxWidth = Math.max(0, this.font.m_92852_((FormattedText)pair.getRight()));
        }
        maxWidth += 4.0;
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, totalHeight, 0.0);
        for (int i = 0; i < textList.size(); ++i) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, -0.125 * (double)i, 0.0);
            poseStack.m_85836_();
            poseStack.m_85841_(-0.0125f, -0.0125f, -0.0125f);
            poseStack.m_85837_(-maxWidth / 2.0, -6.0, 0.0);
            this.font.m_92889_(poseStack, (Component)textList.get(i).getRight(), 8.0f, 0.0f, 0xFFFFFF);
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_85841_(0.25f, 0.25f, 0.25f);
            poseStack.m_85837_(maxWidth / 2.0 * 0.05, 0.0, 0.0);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            this.minecraft.m_91291_().m_174269_((ItemStack)textList.get(i).getLeft(), ItemTransforms.TransformType.GROUND, combinedLight, combinedOverlay, poseStack, buffer, 0);
            poseStack.m_85849_();
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    public boolean shouldRenderOffScreen(AquariumTileEntity blockEntity) {
        return !blockEntity.getInventory().m_7983_();
    }

    public boolean shouldRender(AquariumTileEntity blockEntity, Vec3 vec3) {
        return AnimalPen.CONFIG_MANAGER.getConfiguration().isGrowWaterAnimals() || super.m_142756_((BlockEntity)blockEntity, vec3);
    }
}

