/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.wateranimal;

import java.time.LocalTime;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.interfaces.AnimalPenInterface;
import lv.id.bonne.animalpen.registries.AnimalPenFoodRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={WaterAnimal.class})
@Implements(value={@Interface(iface=AnimalPenInterface.class, prefix="animalPen$", unique=true)})
public abstract class AnimalPenWaterAnimal
extends Mob {
    @Unique
    protected int animalPen$foodCooldown = 0;
    @Unique
    protected long animalPen$animalCount = 0L;

    protected AnimalPenWaterAnimal(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        this.animalPen$animalPenSaveTag(compoundTag);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.animalPen$animalPenLoadTag(compoundTag);
    }

    @Intrinsic
    public boolean animalPen$animalPenUpdateCount(long change) {
        if (change < 0L && this.animalPen$animalCount + change < 0L) {
            return false;
        }
        long maxCount = AnimalPen.CONFIG_MANAGER.getConfiguration().getMaximalAnimalCount();
        if (maxCount > 0L && this.animalPen$animalCount + change > maxCount) {
            return false;
        }
        this.animalPen$animalCount += change;
        return true;
    }

    @Intrinsic
    public long animalPen$animalPenGetCount() {
        return this.animalPen$animalCount;
    }

    @Intrinsic
    public boolean animalPen$animalPenTick(BlockEntity blockEntity) {
        if (this.animalPen$foodCooldown > 0) {
            --this.animalPen$foodCooldown;
            return true;
        }
        return false;
    }

    @Intrinsic
    public void animalPen$animalPenSaveTag(CompoundTag tag) {
        tag.m_128405_("food_cooldown", this.animalPen$foodCooldown);
        tag.m_128356_("animal_count", this.animalPen$animalCount);
    }

    @Intrinsic
    public void animalPen$animalPenLoadTag(CompoundTag tag) {
        this.animalPen$foodCooldown = tag.m_128451_("food_cooldown");
        this.animalPen$animalCount = tag.m_128454_("animal_count");
    }

    @Intrinsic
    public boolean animalPen$animalPenInteract(Player player, InteractionHand hand, BlockPos position) {
        ItemStack itemStack = player.m_21120_(hand);
        if (AnimalPenFoodRegistry.isFood(this.m_6095_().arch$registryName(), itemStack)) {
            if (this.animalPen$foodCooldown > 0) {
                return false;
            }
            long maxCount = AnimalPen.CONFIG_MANAGER.getConfiguration().getMaximalAnimalCount();
            if (maxCount > 0L && this.animalPen$animalCount >= maxCount) {
                return false;
            }
            int stackSize = itemStack.m_41613_();
            if ((stackSize = (int)Math.min(this.animalPen$animalCount, (long)stackSize)) < 2) {
                return false;
            }
            if (player.m_183503_().m_5776_()) {
                return true;
            }
            stackSize = (int)Math.min((maxCount - this.animalPen$animalCount) * 2L, (long)stackSize);
            if (!player.m_150110_().f_35937_) {
                if (stackSize % 2 == 1) {
                    itemStack.m_41774_(stackSize - 1);
                    player.m_21008_(hand, itemStack);
                } else {
                    itemStack.m_41774_(stackSize);
                    player.m_21008_(hand, itemStack);
                }
            }
            this.animalPen$animalCount += (long)(stackSize / 2);
            Level level = player.m_183503_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, (double)((float)position.m_123341_() + 0.5f), (double)position.m_123342_() + 1.5, (double)((float)position.m_123343_() + 0.5f), 5, 0.2, 0.2, 0.2, 0.05);
            }
            player.m_183503_().m_5594_(null, position, this.m_7866_(itemStack), SoundSource.NEUTRAL, 1.0f, Mth.m_144924_((Random)player.m_183503_().f_46441_, (float)0.8f, (float)1.2f));
            SoundEvent soundEvent = this.m_7515_();
            if (soundEvent != null) {
                player.m_183503_().m_5594_(null, position, soundEvent, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            this.animalPen$foodCooldown = AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.m_6095_(), Items.f_42410_, stackSize);
            return true;
        }
        return false;
    }

    @Intrinsic
    public List<Pair<ItemStack, Component>> animalPen$animalPenGetLines(int tick) {
        ItemStack foodItem;
        LinkedList<Pair<ItemStack, Component>> lines = new LinkedList<Pair<ItemStack, Component>>();
        if (AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.m_6095_(), Items.f_42410_, this.animalPen$animalCount) == 0) {
            return lines;
        }
        TextComponent component = new TextComponent("");
        if (this.animalPen$foodCooldown == 0) {
            component.m_7220_((Component)new TranslatableComponent("display.animal_pen.food_ready").m_130940_(ChatFormatting.GREEN));
        } else {
            component.m_7220_((Component)new TranslatableComponent("display.animal_pen.food_cooldown", new Object[]{LocalTime.of(0, 0, 0).plusSeconds(this.animalPen$foodCooldown / 20).format(AnimalPen.DATE_FORMATTER)}));
        }
        ItemStack[] food = this.animalPen$getFood();
        if (food == null || food.length == 0) {
            return lines;
        }
        if (food.length == 1) {
            foodItem = food[0];
        } else {
            int size = food.length;
            int index = tick / 100 % size;
            foodItem = food[index];
        }
        lines.add((Pair<ItemStack, Component>)Pair.of((Object)foodItem, (Object)component));
        return lines;
    }

    @Intrinsic
    @Nullable
    public ItemStack[] animalPen$getFood() {
        return AnimalPenFoodRegistry.getFood(this.m_6095_().arch$registryName());
    }
}

