/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.blocks.entities;

import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.AquariumBlock;
import lv.id.bonne.animalpen.blocks.entities.AnimalPenBlockInterface;
import lv.id.bonne.animalpen.interfaces.AnimalPenInterface;
import lv.id.bonne.animalpen.items.AnimalContainerItem;
import lv.id.bonne.animalpen.network.packets.UpdateVariantScreenData;
import lv.id.bonne.animalpen.registries.AnimalPenDataComponentRegistry;
import lv.id.bonne.animalpen.registries.AnimalPenTileEntityRegistry;
import lv.id.bonne.animalpen.registries.AnimalPensItemRegistry;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AquariumTileEntity
extends BlockEntity
implements AnimalPenBlockInterface<PathfinderMob> {
    private final SimpleContainer inventory = new SimpleContainer(1){

        public boolean canPlaceItem(int slot, ItemStack stack) {
            return stack.is((Item)AnimalPensItemRegistry.ANIMAL_CONTAINER.get());
        }

        public void setChanged() {
            super.setChanged();
            AquariumTileEntity.this.triggerUpdate();
        }
    };
    private PathfinderMob storedAnimal;
    private long displaySize = -1L;
    private UUID ownerUUID;
    private long protectedAmount = 0L;
    private int tickCounter;
    private final List<Integer> deathTicker = new ArrayList<Integer>();
    public static final String TAG_INVENTORY = "inventory";
    public static final String TAG_DEATH_TICKER = "death_ticker";
    public static final String TAG_DISPLAY_SIZE = "display_size";
    public static final String TAG_OWNER_UUID = "owner_uuid";
    public static final String TAG_KEEP_AMOUNT = "keep_amount";

    public AquariumTileEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)AnimalPenTileEntityRegistry.AQUARIUM_TILE_ENTITY.get(), blockPos, blockState);
    }

    public void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        ContainerHelper.saveAllItems((ValueOutput)valueOutput, (NonNullList)this.inventory.getItems(), (boolean)true);
        if (!this.deathTicker.isEmpty()) {
            valueOutput.putIntArray(TAG_DEATH_TICKER, this.deathTicker.stream().mapToInt(i -> i).toArray());
        }
        valueOutput.putLong(TAG_DISPLAY_SIZE, this.displaySize);
        valueOutput.storeNullable(TAG_OWNER_UUID, UUIDUtil.CODEC, (Object)this.ownerUUID);
        valueOutput.putLong(TAG_KEEP_AMOUNT, this.protectedAmount);
    }

    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.inventory.clearContent();
        this.deathTicker.clear();
        this.storedAnimal = null;
        this.ownerUUID = null;
        ContainerHelper.loadAllItems((ValueInput)valueInput, (NonNullList)this.inventory.getItems());
        valueInput.child(TAG_INVENTORY).ifPresent(oldInput -> ContainerHelper.loadAllItems((ValueInput)oldInput, (NonNullList)this.inventory.getItems()));
        valueInput.getIntArray(TAG_DEATH_TICKER).ifPresent(deaths -> {
            for (int death : deaths) {
                this.deathTicker.add(death);
            }
        });
        this.displaySize = valueInput.getLongOr(TAG_DISPLAY_SIZE, -1L);
        valueInput.read(TAG_OWNER_UUID, UUIDUtil.CODEC).ifPresent(uuid -> {
            this.ownerUUID = uuid;
        });
        this.protectedAmount = valueInput.getLongOr(TAG_KEEP_AMOUNT, 0L);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    public Optional<PathfinderMob> getStoredAnimal() {
        if (this.storedAnimal == null && !this.getItemStack().isEmpty()) {
            TypedEntityData customData = (TypedEntityData)this.getItemStack().get(DataComponents.ENTITY_DATA);
            if (customData == null) {
                return Optional.ofNullable(this.storedAnimal);
            }
            CompoundTag tag = customData.copyTagWithoutId();
            if (this.level == null) {
                return Optional.ofNullable(this.storedAnimal);
            }
            try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(this.problemPath(), AnimalPen.LOGGER);){
                ValueInput valueInput = TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)tag);
                EntityType.create((EntityType)((EntityType)customData.type()), (ValueInput)valueInput, (Level)this.level, (EntitySpawnReason)EntitySpawnReason.TRIGGERED).map(entity -> (PathfinderMob)entity).ifPresent(animal -> {
                    this.storedAnimal = animal;
                });
            }
        } else if (this.storedAnimal != null && this.getItemStack().isEmpty()) {
            this.storedAnimal = null;
        }
        return Optional.ofNullable(this.storedAnimal);
    }

    public List<Integer> getDeathTicker() {
        return this.deathTicker;
    }

    public int getTickCounter() {
        return this.tickCounter;
    }

    public void tick() {
        ++this.tickCounter;
        if (this.getLevel() == null || this.getLevel().isClientSide()) {
            return;
        }
        boolean updated = this.getStoredAnimal().map(animal -> ((AnimalPenInterface)animal).animalPenTick(this)).orElse(false);
        for (int i = 0; i < this.deathTicker.size(); ++i) {
            this.deathTicker.set(i, this.deathTicker.get(i) + 1);
            updated = true;
        }
        this.deathTicker.removeIf(integer -> integer > 20);
        if (updated) {
            this.triggerUpdate();
        }
    }

    public boolean processContainer(Player player, InteractionHand interactionHand) {
        if (this.getOwner().isPresent() && !this.getOwner().get().equals(player.getUUID())) {
            AnimalPen.sendDebug("Protection is enabled");
            return false;
        }
        if (this.inventory.isEmpty()) {
            ItemStack itemInHand = player.getItemInHand(interactionHand);
            if (!itemInHand.has(DataComponents.ENTITY_DATA)) {
                return false;
            }
            if (!player.level().isClientSide()) {
                this.inventory.addItem(itemInHand);
                player.setItemInHand(interactionHand, ItemStack.EMPTY);
                if (this.level != null && !this.level.isClientSide()) {
                    NetworkManager.sendToPlayers(((ServerLevel)this.level).players().stream().filter(other -> other.distanceToSqr((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ()) < 50.0).toList(), (CustomPacketPayload)new UpdateVariantScreenData(this.getBlockPos()));
                }
                AnimalPen.sendDebug("Deposit animal cage into pen");
            }
            return true;
        }
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        if (!itemInHand.has(DataComponents.ENTITY_DATA)) {
            CompoundTag tag;
            if (!player.isCrouching()) {
                return false;
            }
            if (player.level().isClientSide()) {
                return true;
            }
            LivingEntity animal = this.getStoredAnimal().orElse(null);
            if (animal == null) {
                return false;
            }
            long currentCount = ((AnimalPenInterface)animal).animalPenGetCount();
            if (currentCount < 2L) {
                AnimalPen.sendDebug("Cannot split 1");
                return false;
            }
            long newCount = Math.min(currentCount - this.protectedAmount, currentCount / 2L);
            if (newCount <= 0L) {
                AnimalPen.sendDebug("Protected amount prevents from splitting");
                return false;
            }
            if (!((AnimalPenInterface)animal).animalPenUpdateCount(-newCount)) {
                AnimalPen.sendDebug("Fail to reduce animal count");
                return false;
            }
            try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(this.problemPath(), AnimalPen.LOGGER);){
                TagValueOutput valueOutput = TagValueOutput.createWithContext((ProblemReporter)scopedCollector, (HolderLookup.Provider)animal.registryAccess());
                animal.save((ValueOutput)valueOutput);
                tag = valueOutput.buildResult();
            }
            tag.putLong("animal_count", newCount);
            itemInHand.set(DataComponents.ENTITY_DATA, (Object)TypedEntityData.of((Object)animal.getType(), (CompoundTag)tag));
            player.setItemInHand(interactionHand, itemInHand);
            this.inventory.setChanged();
            AnimalPen.sendDebug("Half the amount of animals in pen");
            return true;
        }
        Mob animal = this.getStoredAnimal().orElse(null);
        TypedEntityData entityData = (TypedEntityData)itemInHand.get(DataComponents.ENTITY_DATA);
        if (animal == null || !((EntityType)entityData.type()).equals(animal.getType())) {
            AnimalPen.sendDebug("Different animals");
            return false;
        }
        if (player.level().isClientSide()) {
            return true;
        }
        CompoundTag itemInHandTag = entityData.copyTagWithoutId();
        long newCount = itemInHandTag.getLongOr("animal_count", 0L);
        if (newCount <= 0L || !((AnimalPenInterface)animal).animalPenUpdateCount(newCount)) {
            AnimalPen.sendDebug("Failed to deposit animal");
            return false;
        }
        if (newCount > 1L && !AnimalContainerItem.canMergeAnimalVariants(this.getItemStack(), itemInHand, player)) {
            AnimalPen.sendDebug("Variants could not be merged");
            ((AnimalPenInterface)animal).animalPenUpdateCount(-1L);
            itemInHandTag.putLong("animal_count", 1L);
            itemInHand.set(DataComponents.ENTITY_DATA, (Object)TypedEntityData.of((Object)animal.getType(), (CompoundTag)itemInHandTag));
        } else {
            AnimalContainerItem.mergeAnimalVariants(this.getItemStack(), itemInHand, player);
            itemInHand.remove(DataComponents.ENTITY_DATA);
            itemInHand.remove((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
            if (this.level != null && !this.level.isClientSide()) {
                NetworkManager.sendToPlayers(((ServerLevel)this.level).players().stream().filter(other -> other.distanceToSqr((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ()) < 50.0).toList(), (CustomPacketPayload)new UpdateVariantScreenData(this.getBlockPos()));
            }
        }
        player.setItemInHand(interactionHand, itemInHand);
        this.inventory.setChanged();
        AnimalPen.sendDebug("Cage merged into pen");
        return true;
    }

    public boolean interactWithPen(Player player, InteractionHand interactionHand) {
        if (this.getOwner().isPresent() && !this.getOwner().get().equals(player.getUUID())) {
            AnimalPen.sendDebug("Protection is enabled");
            return false;
        }
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        if (itemInHand.isEmpty() && !this.inventory.isEmpty()) {
            if (player.isCrouching() && !player.level().isClientSide()) {
                ItemStack item = this.getItemStack();
                player.setItemInHand(interactionHand, item);
                this.inventory.setItem(0, ItemStack.EMPTY);
                this.inventory.setChanged();
                AnimalPen.sendDebug("Taking out animal cage");
            }
            return true;
        }
        Mob animal = this.getStoredAnimal().orElse(null);
        if (animal == null) {
            AnimalPen.sendDebug("Animal is not set");
            return false;
        }
        if (((AnimalPenInterface)animal).animalPenInteract(player, interactionHand, this.getBlockPos())) {
            CompoundTag tag;
            AnimalPen.sendDebug("Animal Interaction finished");
            ItemStack item = this.getItemStack();
            try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(this.problemPath(), AnimalPen.LOGGER);){
                TagValueOutput valueOutput = TagValueOutput.createWithContext((ProblemReporter)scopedCollector, (HolderLookup.Provider)animal.registryAccess());
                animal.save((ValueOutput)valueOutput);
                tag = valueOutput.buildResult();
            }
            item.set(DataComponents.ENTITY_DATA, (Object)TypedEntityData.of((Object)animal.getType(), (CompoundTag)tag));
            this.inventory.setChanged();
            return true;
        }
        return false;
    }

    public void attackThePen(Player player, Level level) {
        if (this.getOwner().isPresent() && !this.getOwner().get().equals(player.getUUID())) {
            AnimalPen.sendDebug("Protection is enabled");
            return;
        }
        ItemStack weapon = player.getItemInHand(InteractionHand.MAIN_HAND);
        Mob animal = this.getStoredAnimal().orElse(null);
        if (animal == null) {
            AnimalPen.sendDebug("Animal Pen is empty");
            return;
        }
        long amount = ((AnimalPenInterface)animal).animalPenGetCount();
        if (amount <= this.protectedAmount) {
            AnimalPen.sendDebug("Protected amount reached");
            return;
        }
        if (!((AnimalPenInterface)animal).animalPenUpdateCount(-1L)) {
            AnimalPen.sendDebug("Failed to update animal count");
            return;
        }
        EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)((ServerLevel)level), (Entity)animal, (DamageSource)level.damageSources().playerAttack(player), (ItemStack)weapon);
        if (AnimalPen.config().isIncreaseStatistics()) {
            player.awardStat(Stats.ITEM_USED.get((Object)weapon.getItem()));
        }
        weapon.hurtAndBreak(1, (LivingEntity)player, InteractionHand.MAIN_HAND);
        this.deathTicker.add(0);
        if (((AnimalPenInterface)animal).animalPenGetCount() <= 0L) {
            ItemStack item = this.getItemStack();
            item.remove(DataComponents.ENTITY_DATA);
            item.remove((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
            Block.popResource((Level)level, (BlockPos)this.getBlockPos().above(), (ItemStack)item);
            this.inventory.setItem(0, ItemStack.EMPTY);
            AnimalPen.sendDebug("Dropping empty cage");
        }
        this.triggerUpdate();
        Vec3 position = new Vec3((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ());
        LootTable lootTable = level.getServer().reloadableRegistries().getLootTable((ResourceKey)animal.getLootTable().get());
        LootParams.Builder paramsBuilder = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, (Object)position).withParameter(LootContextParams.THIS_ENTITY, (Object)animal).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)player).withParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)player).withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)player).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)level.damageSources().playerAttack(player)).withLuck(player.getLuck());
        lootTable.getRandomItems(paramsBuilder.create(LootContextParamSets.ENTITY), level.getRandom().nextLong()).forEach(itemStack -> Block.popResource((Level)level, (BlockPos)this.getBlockPos().above(), (ItemStack)itemStack));
        animal.clearFire();
        int reward = animal.getExperienceReward((ServerLevel)level, (Entity)player);
        ExperienceOrb.award((ServerLevel)((ServerLevel)this.level), (Vec3)position.add(0.5, 1.5, 0.5), (int)reward);
        if (AnimalPen.config().isTriggerAdvancements()) {
            CriteriaTriggers.PLAYER_KILLED_ENTITY.trigger((ServerPlayer)player, (Entity)animal, level.damageSources().playerAttack(player));
        }
        if (AnimalPen.config().isIncreaseStatistics()) {
            player.awardStat(Stats.MOB_KILLS);
            player.awardStat(Stats.ENTITY_KILLED.get((Object)animal.getType()));
        }
        AnimalPen.sendDebug("Animal Kill process finished");
    }

    public int getRedStoneSignal() {
        return this.getStoredAnimal().map(animal -> ((AnimalPenInterface)animal).getRedStoneSignal()).orElse(0);
    }

    @Override
    public void triggerUpdate() {
        this.setChanged();
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        this.getStoredAnimal().ifPresent(animal -> {
            CompoundTag tag;
            try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(this.problemPath(), AnimalPen.LOGGER);){
                TagValueOutput valueOutput = TagValueOutput.createWithContext((ProblemReporter)scopedCollector, (HolderLookup.Provider)animal.registryAccess());
                animal.save((ValueOutput)valueOutput);
                tag = valueOutput.buildResult();
            }
            this.getItemStack().set(DataComponents.ENTITY_DATA, (Object)TypedEntityData.of((Object)animal.getType(), (CompoundTag)tag));
        });
        BlockState oldState = this.getBlockState();
        BlockState newState = this.getBlockState();
        if (((Boolean)oldState.getValue((Property)AquariumBlock.FILLED)).booleanValue() == this.inventory.isEmpty()) {
            newState = (BlockState)oldState.setValue((Property)AquariumBlock.FILLED, (Comparable)Boolean.valueOf(!this.inventory.isEmpty()));
            this.level.setBlock(this.getBlockPos(), newState, 2);
            this.setChanged();
        }
        this.level.sendBlockUpdated(this.getBlockPos(), oldState, newState, 2);
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    private ItemStack getItemStack() {
        return this.inventory.getItem(0);
    }

    public void preRemoveSideEffects(BlockPos blockPos, BlockState blockState) {
        if (this.level != null) {
            Containers.dropContents((Level)this.level, (BlockPos)blockPos, (NonNullList)this.inventory.getItems());
        }
    }

    @Override
    public ListTag getEntityVariants() {
        return this.getStoredAnimal().map(animal -> AnimalContainerItem.getAnimalVariants(this.getItemStack()).orElseGet(ListTag::new)).orElseGet(ListTag::new);
    }

    @Override
    public long getAnimalDisplaySize() {
        return this.displaySize < 1L ? this.getAnimalCount() : Math.min(this.displaySize, this.getAnimalCount());
    }

    @Override
    public void setAnimalDisplaySize(long size) {
        this.displaySize = size;
        this.triggerUpdate();
    }

    @Override
    public void updateAnimalVariant(ValueInput animalVariant) {
        if (this.getStoredAnimal().isEmpty() || animalVariant == null) {
            return;
        }
        this.getStoredAnimal().ifPresent(animal -> {
            AnimalPen.sendDebug("Animal Variant changed");
            try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(this.problemPath(), AnimalPen.LOGGER);){
                TagValueOutput valueOutput = TagValueOutput.createWithContext((ProblemReporter)scopedCollector, (HolderLookup.Provider)this.level.registryAccess());
                ((AnimalPenInterface)animal).animalPenSaveTag((ValueOutput)valueOutput);
                CompoundTag extraData = valueOutput.buildResult();
                animal.load(animalVariant);
                ValueInput valueInput = TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)extraData);
                ((AnimalPenInterface)animal).animalPenLoadTag(valueInput);
            }
            this.triggerUpdate();
            if (this.level != null && !this.level.isClientSide()) {
                NetworkManager.sendToPlayers(((ServerLevel)this.level).players().stream().filter(other -> other.distanceToSqr((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ()) < 50.0).toList(), (CustomPacketPayload)new UpdateVariantScreenData(this.getBlockPos()));
            }
        });
    }

    @Override
    public void removeAnimalVariant(int index) {
        if (this.getStoredAnimal().isEmpty() || this.getEntityVariants().size() <= index) {
            return;
        }
        CustomData customData = (CustomData)this.getItemStack().get((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
        if (customData == null) {
            return;
        }
        this.getItemStack().set((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get(), (Object)customData.update(tag -> tag.getList("animal_variants").ifPresent(list -> list.remove(index))));
        this.inventory.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            NetworkManager.sendToPlayers(((ServerLevel)this.level).players().stream().filter(other -> other.distanceToSqr((double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ()) < 50.0).toList(), (CustomPacketPayload)new UpdateVariantScreenData(this.getBlockPos()));
            AnimalPen.sendDebug("Animal variant removed");
        }
    }

    @Override
    public long getAnimalCount() {
        return this.getStoredAnimal().map(animal -> ((AnimalPenInterface)animal).animalPenGetCount()).orElse(0L);
    }

    @Override
    public boolean canGrowEntity() {
        return AnimalPen.config().isGrowWaterAnimals();
    }

    @Override
    public List<Pair<ItemStack[], Component>> getCooldownLines(boolean shortText) {
        return this.getStoredAnimal().map(animal -> ((AnimalPenInterface)animal).animalPenGetLines(this.getTickCounter(), shortText)).orElse(Collections.emptyList());
    }

    @Override
    public long getProtectedAmount() {
        return this.protectedAmount;
    }

    @Override
    public void setProtectedAmount(long amount) {
        this.protectedAmount = amount;
        this.triggerUpdate();
    }

    @Override
    public Optional<UUID> getOwner() {
        return Optional.ofNullable(this.ownerUUID);
    }

    @Override
    public void setOwner(@Nullable UUID owner) {
        this.ownerUUID = owner;
        this.triggerUpdate();
    }
}

