/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.blocks.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Objects;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.AnimalPenBlock;
import lv.id.bonne.animalpen.blocks.entities.AquariumTileEntity;
import lv.id.bonne.animalpen.blocks.renderer.state.AnimalPenRenderState;
import lv.id.bonne.animalpen.mixin.accessors.EntityAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class AquariumRenderer
implements BlockEntityRenderer<AquariumTileEntity, AnimalPenRenderState> {
    private final EntityRenderDispatcher entityRenderer;
    private final ItemModelResolver itemModelResolver;
    private final Font font;
    private final Minecraft minecraft = Minecraft.getInstance();

    public AquariumRenderer(BlockEntityRendererProvider.Context context) {
        this.entityRenderer = context.entityRenderer();
        this.itemModelResolver = context.itemModelResolver();
        this.font = context.font();
    }

    @NotNull
    public AnimalPenRenderState createRenderState() {
        return new AnimalPenRenderState();
    }

    public void extractRenderState(AquariumTileEntity blockEntity, AnimalPenRenderState renderState, float partialTick, Vec3 position, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, position, crumblingOverlay);
        renderState.facing = (Direction)blockEntity.getBlockState().getValue((Property)AnimalPenBlock.FACING);
        renderState.animalDisplaySize = blockEntity.getAnimalDisplaySize();
        renderState.animalCount = blockEntity.getAnimalCount();
        renderState.cooldownLines = blockEntity.getCooldownLines(true);
        renderState.level = blockEntity.getLevel();
        Mob animal = blockEntity.getStoredAnimal().orElse(null);
        if (animal != null) {
            animal.yBodyRot = 0.0f;
            animal.setYRot(0.0f);
            animal.yHeadRot = 0.0f;
            animal.yHeadRotO = 0.0f;
            animal.setPose(Pose.SWIMMING);
            animal.setSwimming(true);
            ((EntityAccessor)animal).setWasTouchingWater(true);
            animal.tickCount = blockEntity.getTickCounter();
            renderState.displayEntity = this.entityRenderer.extractEntity((Entity)animal, partialTick);
            renderState.displayEntity.lightCoords = renderState.lightCoords;
            try (ProblemReporter.ScopedCollector reported = new ProblemReporter.ScopedCollector(animal.problemPath(), AnimalPen.LOGGER);){
                TagValueOutput tagOutput = TagValueOutput.createWithContext((ProblemReporter)reported, (HolderLookup.Provider)animal.registryAccess());
                animal.save((ValueOutput)tagOutput);
                ValueInput tagInput = TagValueInput.create((ProblemReporter)reported, (HolderLookup.Provider)animal.registryAccess(), (CompoundTag)tagOutput.buildResult());
                blockEntity.getDeathTicker().forEach(tick -> EntityType.create((EntityType)animal.getType(), (ValueInput)tagInput, (Level)animal.level(), (EntitySpawnReason)EntitySpawnReason.TRIGGERED).ifPresent(entity -> {
                    LivingEntity death = (LivingEntity)entity;
                    death.setPose(Pose.DYING);
                    death.deathTime = tick;
                    EntityRenderState entityRenderState = this.entityRenderer.extractEntity((Entity)death, partialTick);
                    entityRenderState.lightCoords = renderState.lightCoords;
                    renderState.dyingEntity.add(entityRenderState);
                    death.remove(Entity.RemovalReason.DISCARDED);
                }));
            }
        }
    }

    public void submit(AnimalPenRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (renderState.displayEntity == null) {
            return;
        }
        Direction facing = renderState.facing;
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        switch (facing) {
            case SOUTH: {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case EAST: {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(270.0f));
            }
        }
        poseStack.translate(0.0f, 0.0f, 0.0f);
        this.renderAnimal(renderState, poseStack, submitNodeCollector, cameraRenderState);
        this.renderCounter(renderState, poseStack, submitNodeCollector, cameraRenderState);
        if (this.minecraft.player != null && this.minecraft.player.isCrouching() || !AnimalPen.config().isShowCooldownsOnCrouch()) {
            this.renderTextLines(renderState, poseStack, submitNodeCollector, cameraRenderState);
        }
        poseStack.popPose();
    }

    private void renderAnimal(AnimalPenRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        poseStack.pushPose();
        poseStack.translate(0.0, 0.75, 0.0);
        float animalSize = AnimalPen.config().getWaterAnimalSize();
        poseStack.scale(animalSize, animalSize, animalSize);
        if (AnimalPen.config().isGrowWaterAnimals()) {
            float scale = 1.0f + animalSize * renderState.animalDisplaySize * AnimalPen.config().getGrowthMultiplier().floatValue();
            poseStack.scale(scale, scale, scale);
        }
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        this.entityRenderer.submit(renderState.displayEntity, cameraRenderState, 0.0, 0.0, 0.0, poseStack, submitNodeCollector);
        submitNodeCollector.order(5);
        renderState.dyingEntity.forEach(state -> this.entityRenderer.submit(state, cameraRenderState, 0.0, 0.0, 0.0, poseStack, submitNodeCollector));
        poseStack.popPose();
    }

    private void renderCounter(AnimalPenRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        long count = renderState.animalCount;
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.125f, -0.51f);
        MutableComponent text = Component.translatable((String)"display.animal_pen.count", (Object[])new Object[]{count});
        int textWidth = this.font.width((FormattedText)text);
        float maxWidth = 30.0f;
        float scale = Math.min(1.0f, maxWidth / (float)textWidth) * 0.015f;
        poseStack.scale(-scale, -scale, 0.0f);
        double d = (double)(-textWidth) / 2.0;
        Objects.requireNonNull(this.font);
        poseStack.translate(d, (double)((float)(-9) / 2.0f), 0.0);
        submitNodeCollector.submitText(poseStack, 0.0f, 0.0f, text.getVisualOrderText(), false, Font.DisplayMode.NORMAL, renderState.lightCoords, -1, 0, 0);
        poseStack.popPose();
    }

    private void renderTextLines(AnimalPenRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        Direction facing;
        Vec3 facingVec;
        List<Pair<ItemStack[], Component>> textList = renderState.cooldownLines;
        if (textList.isEmpty()) {
            return;
        }
        BlockPos blockPos = renderState.blockPos;
        Vec3 playerPos = cameraRenderState.pos;
        Vec3 toPlayer = new Vec3(playerPos.x() - (double)blockPos.getX(), 0.0, playerPos.z() - (double)blockPos.getZ());
        if (toPlayer.dot(facingVec = Vec3.atLowerCornerOf((Vec3i)(facing = renderState.facing).getUnitVec3i())) < 0.0) {
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        }
        double totalHeight = 1.75 + 0.25 * (double)(textList.size() - 1);
        double maxWidth = 0.0;
        for (Pair<ItemStack[], Component> pair : textList) {
            maxWidth = Math.max(maxWidth, this.calculateMaxWidth(pair));
        }
        poseStack.pushPose();
        poseStack.translate(0.0, totalHeight, 0.0);
        maxWidth = -maxWidth / 2.0;
        for (int i = 0; i < textList.size(); ++i) {
            poseStack.pushPose();
            poseStack.translate(0.0, -0.125 * (double)i, 0.0);
            poseStack.scale(-0.0125f, -0.0125f, 0.0125f);
            poseStack.translate(maxWidth, 0.0, 0.0);
            this.renderTextLine(textList.get(i), renderState, poseStack, submitNodeCollector, cameraRenderState);
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    private void renderTextLine(Pair<ItemStack[], Component> componentPair, AnimalPenRenderState renderState, @NotNull PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        Component text = (Component)componentPair.getRight();
        ItemStack first = ((ItemStack[])componentPair.getLeft()).length > 0 ? ((ItemStack[])componentPair.getLeft())[0] : null;
        ItemStack second = ((ItemStack[])componentPair.getLeft()).length > 1 ? ((ItemStack[])componentPair.getLeft())[1] : null;
        int whiteSpace = this.font.width(" ");
        boolean isFirst = true;
        int leftOffset = 0;
        for (Component part : text.toFlatList(Style.EMPTY)) {
            poseStack.translate((float)leftOffset, 0.0f, 0.0f);
            String content = part.getString();
            if (content.equals("\ue000")) {
                if (first == null) {
                    leftOffset = isFirst ? 0 : -whiteSpace;
                    continue;
                }
                poseStack.pushPose();
                poseStack.scale(-20.0f, -20.0f, 20.0f);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                itemStackRenderState = new ItemStackRenderState();
                this.itemModelResolver.updateForTopItem(itemStackRenderState, first, ItemDisplayContext.GROUND, renderState.level, null, 0);
                itemStackRenderState.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
                poseStack.popPose();
                leftOffset = 8 - whiteSpace;
            } else if (content.equals("\ue001")) {
                if (second == null) {
                    leftOffset = isFirst ? 0 : -whiteSpace;
                    continue;
                }
                poseStack.pushPose();
                poseStack.scale(-20.0f, -20.0f, 20.0f);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                itemStackRenderState = new ItemStackRenderState();
                this.itemModelResolver.updateForTopItem(itemStackRenderState, second, ItemDisplayContext.GROUND, renderState.level, null, 0);
                itemStackRenderState.submit(poseStack, submitNodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
                poseStack.popPose();
                leftOffset = 8 - whiteSpace;
            } else {
                poseStack.pushPose();
                submitNodeCollector.submitText(poseStack, 0.0f, -6.0f, part.getVisualOrderText(), false, Font.DisplayMode.NORMAL, renderState.lightCoords, -1, 0, 0);
                poseStack.popPose();
                leftOffset = this.font.width((FormattedText)part);
            }
            isFirst = false;
        }
    }

    private double calculateMaxWidth(Pair<ItemStack[], Component> pair) {
        Component text = (Component)pair.getRight();
        ItemStack first = ((ItemStack[])pair.getLeft()).length > 0 ? ((ItemStack[])pair.getLeft())[0] : null;
        ItemStack second = ((ItemStack[])pair.getLeft()).length > 1 ? ((ItemStack[])pair.getLeft())[1] : null;
        int whiteSpace = this.font.width(" ");
        boolean isFirst = true;
        double width = 0.0;
        for (Component part : text.toFlatList(Style.EMPTY)) {
            String content = part.getString();
            if (content.equals("\ue000")) {
                if (first == null) continue;
                if (!isFirst) {
                    width -= (double)whiteSpace;
                }
                width += (double)(16 - whiteSpace);
            } else if (content.equals("\ue001")) {
                if (second == null) continue;
                if (!isFirst) {
                    width -= (double)whiteSpace;
                }
                width += (double)(16 - whiteSpace);
            } else {
                width += (double)this.font.width((FormattedText)part);
            }
            isFirst = false;
        }
        return width;
    }

    public boolean shouldRenderOffScreen() {
        return AnimalPen.config().isGrowWaterAnimals();
    }

    public int getViewDistance() {
        return super.getViewDistance();
    }

    public boolean shouldRender(AquariumTileEntity blockEntity, Vec3 vec3) {
        return AnimalPen.config().isGrowWaterAnimals() || super.shouldRender((BlockEntity)blockEntity, vec3);
    }
}

