/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.client.screens;

import dev.architectury.networking.NetworkManager;
import java.util.Optional;
import lv.id.bonne.animalpen.client.screens.VariantScreenSelection;
import lv.id.bonne.animalpen.network.packets.UpdateConfigurationData;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public class VariantsConfigScreen
extends Screen {
    private final VariantScreenSelection parent;
    private final long maxAnimalAmount;
    private long displayAnimalAmount;
    private long minimalAnimalCount;
    private boolean enableProtection;
    private DisplayAnimalAmountSlider displayAnimalAmountSlider;
    private EditBox minimalAnimalCountField;
    private Checkbox protectionCheckbox;
    public static final Component TITLE = Component.translatable((String)"gui.animal_pen.variant_selection_screen.configure.title");
    public static final Component MINIMAL_ANIMAL_COUNT = Component.translatable((String)"gui.animal_pen.variant_selection_screen.configure.minimal_animal_count");
    public static final Component PROTECTION = Component.translatable((String)"gui.animal_pen.variant_selection_screen.configure.enable_protection");
    public static final Component SAVE = Component.translatable((String)"gui.animal_pen.variant_selection_screen.configure.save");
    public static final Component CANCEL = Component.translatable((String)"gui.animal_pen.variant_selection_screen.configure.cancel");

    public VariantsConfigScreen(VariantScreenSelection parent) {
        super(TITLE);
        this.parent = parent;
        this.maxAnimalAmount = this.parent.blockEntityInterface.getAnimalCount();
        this.displayAnimalAmount = this.parent.blockEntityInterface.getAnimalDisplaySize();
        if (!this.parent.blockEntityInterface.canGrowEntity()) {
            this.displayAnimalAmount = this.maxAnimalAmount;
        }
        this.minimalAnimalCount = this.parent.blockEntityInterface.getProtectedAmount();
        this.enableProtection = this.parent.blockEntityInterface.getOwner().isPresent();
    }

    protected void init() {
        super.init();
        int centerX = this.width / 2;
        int startY = this.height / 2 - 60;
        boolean canEdit = this.parent.blockEntityInterface.getOwner().isEmpty() || this.parent.blockEntityInterface.getOwner().map(owner -> owner.equals(this.minecraft.player.getUUID())).orElse(false) != false;
        this.displayAnimalAmountSlider = new DisplayAnimalAmountSlider(centerX - 100, startY, 200, 20, (int)this.displayAnimalAmount, (int)this.maxAnimalAmount);
        this.addRenderableWidget((GuiEventListener)this.displayAnimalAmountSlider);
        this.displayAnimalAmountSlider.active = canEdit;
        if (!this.parent.blockEntityInterface.canGrowEntity()) {
            this.displayAnimalAmountSlider.active = false;
        }
        this.minimalAnimalCountField = new EditBox(this.font, centerX - 100, startY + 40, 200, 20, MINIMAL_ANIMAL_COUNT);
        this.minimalAnimalCountField.setValue(String.valueOf(this.minimalAnimalCount));
        this.minimalAnimalCountField.setFilter(this::isValidNumber);
        this.minimalAnimalCountField.setMaxLength(3);
        this.addRenderableWidget((GuiEventListener)this.minimalAnimalCountField);
        this.minimalAnimalCountField.setEditable(canEdit);
        this.protectionCheckbox = Checkbox.builder((Component)PROTECTION, (Font)this.font).pos(centerX - 100, startY + 80).selected(this.enableProtection).build();
        this.addRenderableWidget((GuiEventListener)this.protectionCheckbox);
        this.protectionCheckbox.active = canEdit;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)SAVE, this::onSave).pos(centerX - 102, startY + 120).size(100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CANCEL, this::onCancel).pos(centerX + 2, startY + 120).size(100, 20).build());
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 20, -1);
        int centerX = this.width / 2;
        int startY = this.height / 2 - 60;
        MutableComponent size = Component.translatable((String)"gui.animal_pen.variant_selection_screen.configure.entity_size", (Object[])new Object[]{this.displayAnimalAmountSlider.getIntValue(), this.maxAnimalAmount});
        graphics.drawString(this.font, (Component)size, centerX - 100, startY - 12, -1);
        graphics.drawString(this.font, MINIMAL_ANIMAL_COUNT, centerX - 100, startY + 28, -1);
    }

    private void onSave(Button button) {
        this.displayAnimalAmount = this.displayAnimalAmountSlider.getIntValue();
        try {
            int inputValue = Integer.parseInt(this.minimalAnimalCountField.getValue());
            if (inputValue < 0) {
                this.minimalAnimalCount = 0L;
                this.minimalAnimalCountField.setValue("0");
            } else {
                this.minimalAnimalCount = inputValue;
            }
        }
        catch (NumberFormatException e) {
            this.minimalAnimalCountField.setValue(String.valueOf(this.minimalAnimalCount));
        }
        this.enableProtection = this.protectionCheckbox.selected();
        if (this.parent.blockEntityInterface.getOwner().isEmpty() || this.parent.blockEntityInterface.getOwner().map(owner -> owner.equals(this.minecraft.player.getUUID())).orElse(false).booleanValue()) {
            this.saveConfiguration();
        }
        this.minecraft.setScreen((Screen)this.parent);
    }

    private void onCancel(Button button) {
        this.minecraft.setScreen((Screen)this.parent);
    }

    private void saveConfiguration() {
        NetworkManager.sendToServer((CustomPacketPayload)new UpdateConfigurationData(this.parent.getPosition(), this.displayAnimalAmount, this.minimalAnimalCount, Optional.ofNullable(this.enableProtection ? this.minecraft.player.getUUID() : null)));
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void onClose() {
        this.minecraft.setScreen((Screen)this.parent);
    }

    private boolean isValidNumber(String input) {
        if (input.isEmpty()) {
            return true;
        }
        try {
            int value = Integer.parseInt(input);
            return value >= 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static class DisplayAnimalAmountSlider
    extends AbstractSliderButton {
        private final int maxValue;

        public DisplayAnimalAmountSlider(int x, int y, int width, int height, int initialValue, int maxValue) {
            super(x, y, width, height, (Component)Component.empty(), (double)(initialValue - 1) / (double)Math.max(1, maxValue - 1));
            this.maxValue = maxValue;
            this.updateMessage();
        }

        protected void updateMessage() {
            this.setMessage((Component)Component.literal((String)String.valueOf(this.getIntValue())));
        }

        protected void applyValue() {
        }

        public int getIntValue() {
            if (this.maxValue == 1) {
                return 1;
            }
            int minValue = 1;
            return minValue + (int)((double)(this.maxValue - minValue) * this.value);
        }
    }
}

