/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.items;

import java.util.Optional;
import java.util.function.Consumer;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.entities.AquariumTileEntity;
import lv.id.bonne.animalpen.registries.AnimalPenDataComponentRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.animal.AgeableWaterCreature;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimalContainerItem
extends Item {
    public static final String TAG_VARIANTS = "animal_variants";
    public static final String TAG_AMOUNT = "animal_count";

    public AnimalContainerItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> list, TooltipFlag tooltipFlag) {
        TypedEntityData tag;
        super.appendHoverText(itemStack, tooltipContext, tooltipDisplay, list, tooltipFlag);
        if (itemStack.has(DataComponents.ENTITY_DATA)) {
            tag = (TypedEntityData)itemStack.get(DataComponents.ENTITY_DATA);
            list.accept((Component)Component.translatable((String)"item.animal_pen.water_animal_container.entity", (Object[])new Object[]{Component.translatable((String)((EntityType)tag.type()).getDescriptionId())}).withStyle(ChatFormatting.GRAY));
            list.accept((Component)Component.translatable((String)"item.animal_pen.water_animal_container.amount", (Object[])new Object[]{tag.copyTagWithoutId().getLongOr(TAG_AMOUNT, 0L)}).withStyle(ChatFormatting.GRAY));
        }
        if (itemStack.has((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get())) {
            tag = ((CustomData)itemStack.get((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get())).copyTag();
            list.accept((Component)Component.translatable((String)"item.animal_pen.water_animal_container.variants", (Object[])new Object[]{tag.getListOrEmpty(TAG_VARIANTS).size()}).withStyle(ChatFormatting.GRAY));
        }
        if (!itemStack.has(DataComponents.ENTITY_DATA)) {
            list.accept((Component)Component.translatable((String)"item.animal_pen.water_animal_container.tip").withStyle(ChatFormatting.GRAY));
        } else {
            list.accept((Component)Component.empty());
            list.accept((Component)Component.translatable((String)"item.animal_pen.water_animal_container.release").withStyle(ChatFormatting.GRAY));
        }
    }

    @NotNull
    public InteractionResult interactLivingEntity(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand interactionHand) {
        CompoundTag itemTag;
        OwnableEntity ownableEntity;
        WaterAnimal animal;
        InteractionResult interactionResult = super.interactLivingEntity(itemStack, player, livingEntity, interactionHand);
        if (interactionResult == InteractionResult.FAIL) {
            player.displayClientMessage((Component)Component.translatable((String)"item.animal_pen.water_animal_container.error.unknown").withStyle(ChatFormatting.DARK_RED), true);
            return interactionResult;
        }
        if (player.level().isClientSide() || livingEntity instanceof Player || !livingEntity.isAlive()) {
            return InteractionResult.FAIL;
        }
        if (AnimalPen.config().isBlocked(livingEntity.getType())) {
            player.displayClientMessage((Component)Component.translatable((String)"item.animal_pen.animal_cage.error.blocked").withStyle(ChatFormatting.DARK_RED), true);
            return InteractionResult.FAIL;
        }
        if (!livingEntity.isAlive() || livingEntity.isBaby()) {
            player.displayClientMessage((Component)Component.translatable((String)"item.animal_pen.water_animal_container.error.baby").withStyle(ChatFormatting.DARK_RED), true);
            return InteractionResult.FAIL;
        }
        if (livingEntity instanceof WaterAnimal) {
            animal = (WaterAnimal)livingEntity;
        } else if (livingEntity instanceof AgeableWaterCreature) {
            AgeableWaterCreature creature = (AgeableWaterCreature)livingEntity;
        } else {
            player.displayClientMessage((Component)Component.translatable((String)"item.animal_pen.water_animal_container.error.not_water_animal").withStyle(ChatFormatting.DARK_RED), true);
            return InteractionResult.FAIL;
        }
        if (livingEntity instanceof OwnableEntity && (ownableEntity = (OwnableEntity)livingEntity).getOwnerReference() != null) {
            player.displayClientMessage((Component)Component.translatable((String)"item.animal_pen.water_animal_container.error.tame").withStyle(ChatFormatting.DARK_RED), true);
            return InteractionResult.FAIL;
        }
        animal = (PathfinderMob)livingEntity;
        if (animal.isLeashed()) {
            player.displayClientMessage((Component)Component.translatable((String)"item.animal_pen.water_animal_container.error.leashed").withStyle(ChatFormatting.DARK_RED), true);
            return InteractionResult.FAIL;
        }
        if (animal.isSaddled()) {
            player.displayClientMessage((Component)Component.translatable((String)"item.animal_pen.water_animal_container.error.saddled").withStyle(ChatFormatting.DARK_RED), true);
            return InteractionResult.FAIL;
        }
        if (!this.matchEntity(itemStack, livingEntity)) {
            player.displayClientMessage((Component)Component.translatable((String)"item.animal_pen.water_animal_container.error.wrong").withStyle(ChatFormatting.DARK_RED), true);
            return InteractionResult.FAIL;
        }
        animal.ejectPassengers();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (!animal.hasItemInSlot(slot)) continue;
            ItemStack itemBySlot = animal.getItemBySlot(slot);
            if (animal.getRandom().nextFloat() < animal.getDropChances().byEquipment(slot)) {
                Block.popResource((Level)animal.level(), (BlockPos)animal.blockPosition(), (ItemStack)itemBySlot);
            }
            animal.setDropChance(slot, 0.0f);
        }
        if (!itemStack.has(DataComponents.ENTITY_DATA)) {
            try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(livingEntity.problemPath(), AnimalPen.LOGGER);){
                TagValueOutput tagValueOutput = TagValueOutput.createWithContext((ProblemReporter)scopedCollector, (HolderLookup.Provider)livingEntity.registryAccess());
                livingEntity.save((ValueOutput)tagValueOutput);
                itemTag = tagValueOutput.buildResult();
            }
        } else {
            itemTag = ((TypedEntityData)itemStack.get(DataComponents.ENTITY_DATA)).copyTagWithoutId();
        }
        if (itemTag.contains(TAG_AMOUNT)) {
            long maxCount = AnimalPen.config().getMaximalAnimalCount();
            if (maxCount > 0L && itemTag.getLongOr(TAG_AMOUNT, 0L) + 1L > maxCount) {
                return InteractionResult.FAIL;
            }
            itemTag.putLong(TAG_AMOUNT, itemTag.getLongOr(TAG_AMOUNT, 0L) + 1L);
        }
        itemStack.set(DataComponents.ENTITY_DATA, (Object)TypedEntityData.of((Object)animal.getType(), (CompoundTag)itemTag));
        AnimalContainerItem.storeAnimalVariant(itemStack, livingEntity, player);
        player.setItemInHand(interactionHand, itemStack);
        livingEntity.remove(Entity.RemovalReason.DISCARDED);
        if (AnimalPen.config().isIncreaseStatistics()) {
            player.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext useOnContext) {
        AquariumTileEntity tileEntity;
        if (useOnContext.getLevel().isClientSide()) {
            return super.useOn(useOnContext);
        }
        BlockEntity blockEntity = useOnContext.getLevel().getBlockEntity(useOnContext.getClickedPos());
        Player player = useOnContext.getPlayer();
        if (player != null && blockEntity instanceof AquariumTileEntity && (tileEntity = (AquariumTileEntity)blockEntity).processContainer(player, useOnContext.getHand())) {
            return InteractionResult.SUCCESS;
        }
        if (player != null && player.isCrouching() && useOnContext.getClickedFace() == Direction.UP) {
            ItemStack itemInHand = useOnContext.getItemInHand();
            if (!itemInHand.has(DataComponents.ENTITY_DATA)) {
                return super.useOn(useOnContext);
            }
            TypedEntityData entityData = (TypedEntityData)itemInHand.get(DataComponents.ENTITY_DATA);
            CompoundTag itemTag = entityData.copyTagWithoutId();
            ServerLevel level = (ServerLevel)useOnContext.getLevel();
            ListTag pos = new ListTag();
            pos.add((Object)DoubleTag.valueOf((double)((double)useOnContext.getClickedPos().getX() + 0.5)));
            pos.add((Object)DoubleTag.valueOf((double)(useOnContext.getClickedPos().getY() + 1)));
            pos.add((Object)DoubleTag.valueOf((double)((double)useOnContext.getClickedPos().getZ() + 0.5)));
            itemTag.put("Pos", (Tag)pos);
            itemTag.remove("UUID");
            itemTag.remove(TAG_VARIANTS);
            itemTag.remove(TAG_AMOUNT);
            try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(player.problemPath(), AnimalPen.LOGGER);){
                ValueInput valueInput = TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)player.registryAccess(), (CompoundTag)itemTag);
                EntityType.create((EntityType)((EntityType)entityData.type()), (ValueInput)valueInput, (Level)level, (EntitySpawnReason)EntitySpawnReason.SPAWN_ITEM_USE).map(entity -> (Mob)entity).ifPresent(clone -> {
                    for (EquipmentSlot slot : EquipmentSlot.values()) {
                        clone.setItemSlot(slot, ItemStack.EMPTY);
                    }
                    level.addFreshEntity((Entity)clone);
                    CompoundTag tag = entityData.copyTagWithoutId();
                    long amount = tag.getLongOr(TAG_AMOUNT, 0L);
                    tag.putLong(TAG_AMOUNT, amount - 1L);
                    if (amount - 1L <= 0L) {
                        itemInHand.remove(DataComponents.ENTITY_DATA);
                        itemInHand.remove((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
                    } else {
                        itemInHand.set(DataComponents.ENTITY_DATA, (Object)TypedEntityData.of((Object)clone.getType(), (CompoundTag)tag));
                    }
                    player.setItemInHand(useOnContext.getHand(), itemInHand);
                });
            }
        }
        return super.useOn(useOnContext);
    }

    private boolean matchEntity(ItemStack itemStack, LivingEntity entity) {
        if (!itemStack.has(DataComponents.ENTITY_DATA)) {
            return true;
        }
        return ((EntityType)((TypedEntityData)itemStack.get(DataComponents.ENTITY_DATA)).type()).equals(entity.getType());
    }

    public static Optional<ListTag> getAnimalVariants(ItemStack itemStack) {
        if (!itemStack.has((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get())) {
            return Optional.empty();
        }
        CustomData customData = (CustomData)itemStack.get((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
        if (customData == null) {
            return Optional.empty();
        }
        CompoundTag tag = customData.copyTag();
        return tag.getList(TAG_VARIANTS);
    }

    public static boolean storeAnimalVariant(ItemStack itemStack, LivingEntity animal, @Nullable Player player) {
        CompoundTag variant;
        if (AnimalPen.config().getMaxStoredVariants() <= 0) {
            return false;
        }
        CustomData customData = (CustomData)itemStack.get((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
        CompoundTag itemTag = customData == null ? new CompoundTag() : customData.copyTag();
        ListTag variantList = itemTag.getListOrEmpty(TAG_VARIANTS);
        if (variantList.size() + 1 > AnimalPen.config().getMaxStoredVariants()) {
            if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)"item.animal_pen.water_animal_container.error.too_many_variants").withStyle(ChatFormatting.DARK_RED), true);
            }
            return false;
        }
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(animal.problemPath(), AnimalPen.LOGGER);){
            TagValueOutput tagValueOutput = TagValueOutput.createWithContext((ProblemReporter)scopedCollector, (HolderLookup.Provider)animal.registryAccess());
            animal.save((ValueOutput)tagValueOutput);
            variant = tagValueOutput.buildResult();
        }
        variantList.add((Object)variant);
        itemTag.put(TAG_VARIANTS, (Tag)variantList);
        itemStack.set((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get(), (Object)CustomData.of((CompoundTag)itemTag));
        return true;
    }

    public static boolean canMergeAnimalVariants(ItemStack mainItem, ItemStack redundantItem, @Nullable Player player) {
        if (AnimalPen.config().getMaxStoredVariants() <= 0) {
            return true;
        }
        CustomData mainData = (CustomData)mainItem.get((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
        CustomData redundantData = (CustomData)redundantItem.get((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
        if (redundantData == null) {
            return true;
        }
        CompoundTag itemTag = mainData == null ? new CompoundTag() : mainData.copyTag();
        CompoundTag redundantTag = redundantData.copyTag();
        ListTag variantList = itemTag.getListOrEmpty(TAG_VARIANTS);
        ListTag redundantList = redundantTag.getListOrEmpty(TAG_VARIANTS);
        if (variantList.size() + redundantList.size() > AnimalPen.config().getMaxStoredVariants()) {
            if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)"item.animal_pen.water_animal_container.error.too_many_variants").withStyle(ChatFormatting.DARK_RED), true);
            }
            return false;
        }
        return true;
    }

    public static void mergeAnimalVariants(ItemStack mainItem, ItemStack redundantItem, @Nullable Player player) {
        if (AnimalPen.config().getMaxStoredVariants() <= 0) {
            return;
        }
        CustomData mainData = (CustomData)mainItem.get((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
        CustomData redundantData = (CustomData)redundantItem.get((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
        if (redundantData == null) {
            return;
        }
        CompoundTag itemTag = mainData == null ? new CompoundTag() : mainData.copyTag();
        CompoundTag redundantTag = redundantData.copyTag();
        ListTag variantList = itemTag.getListOrEmpty(TAG_VARIANTS);
        ListTag redundantList = redundantTag.getListOrEmpty(TAG_VARIANTS);
        for (Tag tag : redundantList) {
            if (variantList.size() + 1 > AnimalPen.config().getMaxStoredVariants()) {
                if (player == null) break;
                player.displayClientMessage((Component)Component.translatable((String)"item.animal_pen.water_animal_container.error.too_many_variants").withStyle(ChatFormatting.DARK_RED), true);
                break;
            }
            variantList.add((Object)tag);
        }
        itemTag.put(TAG_VARIANTS, (Tag)variantList);
        mainItem.set((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get(), (Object)CustomData.of((CompoundTag)itemTag));
    }
}

