/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.animal;

import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.interfaces.AnimalPenInterface;
import lv.id.bonne.animalpen.mixin.animal.AnimalPenAnimal;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Axolotl.class})
public abstract class AnimalPenAxolotl
extends AnimalPenAnimal {
    @Unique
    private int animalPen$storedFood = 0;

    @Shadow
    public abstract void saveToBucketTag(ItemStack var1);

    protected AnimalPenAxolotl(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenSaveTag(ValueOutput tag) {
        super.animalPen$animalPenSaveTag(tag);
        tag.putInt("stored_food", this.animalPen$storedFood);
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenLoadTag(ValueInput tag) {
        super.animalPen$animalPenLoadTag(tag);
        this.animalPen$storedFood = tag.getIntOr("stored_food", 0);
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenInteract(Player player, InteractionHand hand, BlockPos position) {
        if (super.animalPen$animalPenInteract(player, hand, position)) {
            return true;
        }
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(Items.WATER_BUCKET)) {
            if (player.level().isClientSide()) {
                return true;
            }
            if (this.animalPen$animalCount <= 1L) {
                AnimalPen.sendDebug("Need at least 2 axolotls in pen");
                return false;
            }
            AnimalPenInterface.triggerItemUse((Entity)this, (ServerPlayer)player, itemStack, 1);
            ItemStack bucket = new ItemStack((ItemLike)Items.AXOLOTL_BUCKET);
            this.saveToBucketTag(bucket);
            --this.animalPen$animalCount;
            player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)bucket, (boolean)false));
            player.level().playSound(null, position, SoundEvents.BUCKET_FILL_AXOLOTL, SoundSource.NEUTRAL, 1.0f, 1.0f);
            if (AnimalPen.config().isTriggerAdvancements()) {
                CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, bucket);
            }
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.getItem().arch$registryName()));
            return true;
        }
        return false;
    }

    @Override
    @Intrinsic
    public ItemStack animalPen$animalPenInteract(ServerLevel level, ItemStack itemStack, BlockPos position) {
        if (itemStack.is(Items.WATER_BUCKET)) {
            if (this.animalPen$animalCount <= 1L) {
                AnimalPen.sendDebug("Need at least 2 axolotls in pen");
                return ItemStack.EMPTY;
            }
            ItemStack bucket = new ItemStack((ItemLike)Items.AXOLOTL_BUCKET);
            this.saveToBucketTag(bucket);
            itemStack.shrink(1);
            level.playSound(null, position, SoundEvents.BUCKET_FILL_AXOLOTL, SoundSource.NEUTRAL, 1.0f, 1.0f);
            --this.animalPen$animalCount;
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.getItem().arch$registryName()));
            return bucket;
        }
        return super.animalPen$animalPenInteract(level, itemStack, position);
    }

    @Override
    @Intrinsic
    public List<Pair<ItemStack[], Component>> animalPen$animalPenGetLines(int tick, boolean shortLine) {
        List<Pair<ItemStack[], Component>> lines = super.animalPen$animalPenGetLines(tick, shortLine);
        if (!AnimalPen.config().isShowAllInteractions() && shortLine || this.animalPen$animalCount <= 1L) {
            return lines;
        }
        MutableComponent component = Component.translatable((String)(shortLine ? "display.animal_pen.ready" : "display.animal_pen.full_ready"), (Object[])new Object[]{Component.literal((String)"\ue000"), Component.literal((String)"\ue001")}).withStyle(ChatFormatting.GREEN);
        ItemStack bucket = new ItemStack((ItemLike)Items.AXOLOTL_BUCKET);
        this.saveToBucketTag(bucket);
        lines.add((Pair<ItemStack[], Component>)Pair.of((Object)new ItemStack[]{Items.WATER_BUCKET.getDefaultInstance(), bucket}, (Object)component));
        return lines;
    }
}

