/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.animal;

import java.time.LocalTime;
import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.mixin.animal.AnimalPenAnimal;
import lv.id.bonne.animalpen.registries.AnimalPenFoodRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1481;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_1481.class})
public abstract class AnimalPenTurtle
extends AnimalPenAnimal {
    @Unique
    private int animalPen$eggCooldown;
    @Unique
    private int animalPen$scuteCount;

    protected AnimalPenTurtle(class_1299<? extends class_1308> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenTick(class_2586 blockEntity) {
        this.animalPen$processScute(blockEntity.method_10997(), blockEntity.method_11016());
        boolean value = super.animalPen$animalPenTick(blockEntity);
        if (this.animalPen$eggCooldown > 0) {
            --this.animalPen$eggCooldown;
            return true;
        }
        return value;
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenSaveTag(class_2487 tag) {
        super.animalPen$animalPenSaveTag(tag);
        tag.method_10569("egg_cooldown", this.animalPen$eggCooldown);
        tag.method_10569("scute_count", this.animalPen$scuteCount);
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenLoadTag(class_2487 tag) {
        super.animalPen$animalPenLoadTag(tag);
        this.animalPen$eggCooldown = tag.method_68083("egg_cooldown", 0);
        this.animalPen$scuteCount = tag.method_68083("scute_count", 0);
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenInteract(class_1657 player, class_1268 hand, class_2338 position) {
        this.animal$preProcesScute(player, hand, position);
        if (super.animalPen$animalPenInteract(player, hand, position)) {
            return true;
        }
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574(class_1802.field_8550)) {
            if (this.animalPen$eggCooldown > 0) {
                AnimalPen.sendDebug("Under cooldown for " + this.animalPen$eggCooldown);
                return false;
            }
            if (player.method_37908().method_8608()) {
                return true;
            }
            int dropLimits = AnimalPen.config().getDropLimits(class_1802.field_8618);
            if (dropLimits <= 0) {
                dropLimits = Integer.MAX_VALUE;
            }
            int eggCount = (int)Math.min(this.animalPen$animalCount, (long)dropLimits);
            while (eggCount > 0) {
                class_1799 eggStack = new class_1799((class_1935)class_1802.field_8618);
                if (eggCount > 64) {
                    eggStack.method_7939(64);
                    eggCount -= 64;
                } else {
                    eggStack.method_7939(eggCount);
                    eggCount = 0;
                }
                class_2248.method_9577((class_1937)player.method_37908(), (class_2338)position.method_10084(), (class_1799)eggStack);
            }
            player.method_37908().method_8396(null, position, class_3417.field_14634, class_3419.field_15254, 1.0f, 1.0f);
            this.animalPen$eggCooldown = AnimalPen.config().getEntityCooldown(this.method_5864(), class_1802.field_8550, this.animalPen$animalCount);
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.method_7909().arch$registryName()));
            return true;
        }
        return false;
    }

    @Override
    @Intrinsic
    public class_1799 animalPen$animalPenInteract(class_3218 level, class_1799 itemStack, class_2338 position) {
        if (this.animalPen$eggCooldown > 0) {
            AnimalPen.sendDebug("Under cooldown for " + this.animalPen$eggCooldown);
            return class_1799.field_8037;
        }
        if (itemStack.method_31574(class_1802.field_8550)) {
            int dropLimits = AnimalPen.config().getDropLimits(class_1802.field_8618);
            if (dropLimits <= 0) {
                dropLimits = Integer.MAX_VALUE;
            }
            int eggCount = (int)Math.min(this.animalPen$animalCount, (long)dropLimits);
            while (eggCount > 0) {
                class_1799 eggStack = new class_1799((class_1935)class_1802.field_8618);
                if (eggCount > 64) {
                    eggStack.method_7939(64);
                    eggCount -= 64;
                } else {
                    eggStack.method_7939(eggCount);
                    eggCount = 0;
                }
                class_2248.method_9577((class_1937)level, (class_2338)position.method_10084(), (class_1799)eggStack);
            }
            level.method_8396(null, position, class_3417.field_14634, class_3419.field_15254, 1.0f, 1.0f);
            this.animalPen$eggCooldown = AnimalPen.config().getEntityCooldown(this.method_5864(), class_1802.field_8550, this.animalPen$animalCount);
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.method_7909().arch$registryName()));
            return class_1799.field_8037;
        }
        return super.animalPen$animalPenInteract(level, itemStack, position);
    }

    @Unique
    private void animalPen$processScute(class_1937 level, class_2338 position) {
        if (this.animalPen$scuteCount <= 0) {
            return;
        }
        if (level.method_8608()) {
            return;
        }
        boolean dropScuteAtStart = AnimalPen.config().isDropScuteAtStart();
        if (!dropScuteAtStart && this.animalPen$foodCooldown != 0) {
            return;
        }
        int dropLimits = AnimalPen.config().getDropLimits(class_1802.field_8161);
        if (dropLimits <= 0) {
            dropLimits = Integer.MAX_VALUE;
        }
        int scuteCount = Math.min(this.animalPen$scuteCount, dropLimits);
        while (scuteCount > 0) {
            class_1799 scuteStack = new class_1799((class_1935)class_1802.field_8161);
            if (scuteCount > 64) {
                scuteStack.method_7939(64);
                scuteCount -= 64;
            } else {
                scuteStack.method_7939(scuteCount);
                scuteCount = 0;
            }
            class_2248.method_9577((class_1937)level, (class_2338)position.method_10084(), (class_1799)scuteStack);
        }
        level.method_8396(null, position, class_3417.field_14864, class_3419.field_15254, 1.0f, 1.0f);
        this.animalPen$scuteCount = 0;
    }

    @Unique
    private void animal$preProcesScute(class_1657 player, class_1268 hand, class_2338 position) {
        class_1799 itemStack = player.method_5998(hand);
        if (AnimalPenFoodRegistry.isFood(this.method_5864().arch$registryName(), itemStack)) {
            if (this.animalPen$foodCooldown > 0) {
                return;
            }
            long maxCount = AnimalPen.config().getMaximalAnimalCount();
            if (maxCount > 0L && this.animalPen$animalCount >= maxCount) {
                return;
            }
            int stackSize = itemStack.method_7947();
            if ((stackSize = (int)Math.min(this.animalPen$animalCount, (long)stackSize)) < 2) {
                return;
            }
            if (player.method_37908().method_8608()) {
                return;
            }
            stackSize = (int)Math.min((maxCount - this.animalPen$animalCount) * 2L, (long)stackSize);
            this.animalPen$scuteCount += stackSize / 2;
        }
    }

    @Override
    @Intrinsic
    public List<Pair<class_1799[], class_2561>> animalPen$animalPenGetLines(int tick, boolean shortLine) {
        List<Pair<class_1799[], class_2561>> lines = super.animalPen$animalPenGetLines(tick, shortLine);
        if (!AnimalPen.config().isShowAllInteractions() && shortLine && AnimalPen.config().getEntityCooldown(this.method_5864(), class_1802.field_8550, this.animalPen$animalCount) == 0) {
            return lines;
        }
        class_5250 component = this.animalPen$eggCooldown == 0 ? class_2561.method_43469((String)(shortLine ? "display.animal_pen.ready" : "display.animal_pen.full_ready"), (Object[])new Object[]{class_2561.method_43470((String)"\ue000"), class_2561.method_43470((String)"\ue001")}).method_27692(class_124.field_1060) : class_2561.method_43469((String)(shortLine ? "display.animal_pen.cooldown" : "display.animal_pen.egg_cooldown"), (Object[])new Object[]{class_2561.method_43470((String)"\ue000"), class_2561.method_43470((String)"\ue001"), LocalTime.of(0, 0, 0).plusSeconds(this.animalPen$eggCooldown / 20).format(AnimalPen.DATE_FORMATTER)});
        lines.add((Pair<class_1799[], class_2561>)Pair.of((Object)new class_1799[]{class_1802.field_8550.method_7854(), class_1802.field_8618.method_7854()}, (Object)component));
        return lines;
    }

    @Override
    @Intrinsic
    public int animalPen$getRedStoneSignal() {
        if (this.animalPen$eggCooldown > 0) {
            return super.animalPen$getRedStoneSignal();
        }
        return super.animalPen$getRedStoneSignal() | 4;
    }
}

