/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.blocks.renderer;

import java.util.List;
import java.util.Objects;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.AnimalPenBlock;
import lv.id.bonne.animalpen.blocks.entities.AnimalPenTileEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1429;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class AnimalPenRenderer
implements class_827<AnimalPenTileEntity> {
    private final class_310 minecraft = class_310.method_1551();
    private final class_327 font;
    private class_1429 dyingAnimal;

    public AnimalPenRenderer() {
        this.font = this.minecraft.field_1772;
    }

    public void render(AnimalPenTileEntity tileEntity, float partialTicks, @NotNull class_4587 poseStack, @NotNull class_4597 buffer, int combinedLight, int combinedOverlay) {
        class_1429 animal = tileEntity.getStoredAnimal();
        if (animal == null) {
            return;
        }
        if (this.dyingAnimal == null || this.dyingAnimal.method_5864() != animal.method_5864()) {
            this.dyingAnimal = null;
            class_2487 cloneTag = new class_2487();
            animal.method_5662(cloneTag);
            class_1299.method_5892((class_2487)cloneTag, (class_1937)tileEntity.method_10997()).map(entity -> (class_1429)entity).ifPresent(clone -> {
                this.dyingAnimal = clone;
                this.dyingAnimal.method_18380(class_4050.field_18082);
                this.dyingAnimal.field_6283 = 0.0f;
                this.dyingAnimal.method_36456(0.0f);
                this.dyingAnimal.field_6241 = 0.0f;
                this.dyingAnimal.field_6259 = 0.0f;
                this.dyingAnimal.field_6012 = 0;
                this.dyingAnimal.field_6213 = 0;
            });
        }
        class_2350 facing = (class_2350)tileEntity.method_11010().method_11654((class_2769)AnimalPenBlock.field_11177);
        poseStack.method_22903();
        poseStack.method_22904(0.5, 0.0, 0.5);
        switch (facing) {
            case field_11035: {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                break;
            }
            case field_11039: {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                break;
            }
            case field_11034: {
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(270.0f));
            }
        }
        poseStack.method_46416(0.0f, 0.0f, 0.0f);
        this.renderAnimal(animal, tileEntity, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        this.renderCounter(animal, tileEntity, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        if (this.minecraft.field_1724 != null && this.minecraft.field_1724.method_18276()) {
            this.renderTextLines(animal, tileEntity, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        }
        poseStack.method_22909();
    }

    private void renderAnimal(class_1429 animal, AnimalPenTileEntity tileEntity, float partialTicks, @NotNull class_4587 poseStack, @NotNull class_4597 buffer, int combinedLight, int combinedOverlay) {
        animal.field_6283 = 0.0f;
        animal.method_36456(0.0f);
        animal.field_6241 = 0.0f;
        animal.field_6259 = 0.0f;
        animal.field_6012 = tileEntity.getTickCounter();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.25f, 0.0f);
        float animalSize = AnimalPen.CONFIG_MANAGER.getConfiguration().getAnimalSize();
        poseStack.method_22905(animalSize, animalSize, animalSize);
        if (AnimalPen.CONFIG_MANAGER.getConfiguration().isGrowAnimals()) {
            float scale = 1.0f + animalSize * (float)tileEntity.getAnimalDisplaySize() * AnimalPen.CONFIG_MANAGER.getConfiguration().getGrowthMultiplier().floatValue();
            poseStack.method_22905(scale, scale, scale);
        }
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        this.minecraft.method_1561().method_3953((class_1297)animal).method_3936((class_1297)animal, 0.0f, this.minecraft.method_1488(), poseStack, buffer, combinedLight);
        class_2487 cloneTag = new class_2487();
        animal.method_5662(cloneTag);
        tileEntity.getDeathTicker().forEach(tick -> {
            if (this.dyingAnimal != null) {
                this.dyingAnimal.field_6213 = tick;
                this.minecraft.method_1561().method_3953((class_1297)this.dyingAnimal).method_3936((class_1297)this.dyingAnimal, 0.0f, this.minecraft.method_1488(), poseStack, buffer, combinedLight);
            }
        });
        poseStack.method_22909();
    }

    private void renderCounter(class_1429 animal, AnimalPenTileEntity tileEntity, float partialTicks, @NotNull class_4587 poseStack, @NotNull class_4597 buffer, int combinedLight, int combinedOverlay) {
        long count = tileEntity.getAnimalCount();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.125f, -0.51f);
        class_5250 text = class_2561.method_43469((String)"display.animal_pen.count", (Object[])new Object[]{count});
        int textWidth = this.font.method_27525((class_5348)text);
        float maxWidth = 30.0f;
        float scale = Math.min(1.0f, maxWidth / (float)textWidth) * 0.015f;
        poseStack.method_22905(-scale, -scale, 0.0f);
        double d = (double)(-textWidth) / 2.0;
        Objects.requireNonNull(this.font);
        poseStack.method_22904(d, (double)((float)(-9) / 2.0f), 0.0);
        this.font.method_30883(poseStack, (class_2561)text, 0.0f, 0.0f, 0xFFFFFF);
        poseStack.method_22909();
    }

    private void renderTextLines(class_1429 animal, AnimalPenTileEntity tileEntity, float partialTicks, @NotNull class_4587 poseStack, @NotNull class_4597 buffer, int combinedLight, int combinedOverlay) {
        class_2350 facing;
        class_243 facingVec;
        List<Pair<class_1799[], class_2561>> textList = tileEntity.getCooldownLines(true);
        if (textList.isEmpty()) {
            return;
        }
        class_2338 blockPos = tileEntity.method_11016();
        class_243 playerPos = this.minecraft.field_1724.method_19538();
        class_243 toPlayer = new class_243(playerPos.method_10216() - (double)blockPos.method_10263(), 0.0, playerPos.method_10215() - (double)blockPos.method_10260());
        if (toPlayer.method_1026(facingVec = class_243.method_24954((class_2382)(facing = (class_2350)tileEntity.method_11010().method_11654((class_2769)AnimalPenBlock.field_11177)).method_10163())) < 0.0) {
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        }
        double totalHeight = 1.5 + 0.125 * (double)(textList.size() - 1);
        double maxWidth = 0.0;
        for (Pair<class_1799[], class_2561> pair : textList) {
            maxWidth = Math.max(maxWidth, this.calculateMaxWidth(pair));
        }
        poseStack.method_22903();
        poseStack.method_22904(0.0, totalHeight, 0.0);
        maxWidth = -maxWidth / 2.0;
        for (int i = 0; i < textList.size(); ++i) {
            poseStack.method_22903();
            poseStack.method_22904(0.0, -0.125 * (double)i, 0.0);
            poseStack.method_22905(-0.0125f, -0.0125f, 0.0125f);
            poseStack.method_22904(maxWidth, 0.0, 0.0);
            this.renderTextLine(textList.get(i), poseStack, buffer, combinedLight, combinedOverlay);
            poseStack.method_22909();
        }
        poseStack.method_22909();
    }

    private double calculateMaxWidth(Pair<class_1799[], class_2561> pair) {
        class_2561 text = (class_2561)pair.getRight();
        class_1799 first = ((class_1799[])pair.getLeft()).length > 0 ? ((class_1799[])pair.getLeft())[0] : null;
        class_1799 second = ((class_1799[])pair.getLeft()).length > 1 ? ((class_1799[])pair.getLeft())[1] : null;
        int whiteSpace = this.font.method_1727(" ");
        boolean isFirst = true;
        double width = 0.0;
        for (class_2561 part : text.method_36136(class_2583.field_24360)) {
            String content = part.getString();
            if (content.equals("\ue000")) {
                if (first == null) continue;
                if (!isFirst) {
                    width -= (double)whiteSpace;
                }
                width += (double)(16 - whiteSpace);
            } else if (content.equals("\ue001")) {
                if (second == null) continue;
                if (!isFirst) {
                    width -= (double)whiteSpace;
                }
                width += (double)(16 - whiteSpace);
            } else {
                width += (double)this.font.method_27525((class_5348)part);
            }
            isFirst = false;
        }
        return width;
    }

    private void renderTextLine(Pair<class_1799[], class_2561> componentPair, @NotNull class_4587 poseStack, @NotNull class_4597 buffer, int combinedLight, int combinedOverlay) {
        class_2561 text = (class_2561)componentPair.getRight();
        class_1799 first = ((class_1799[])componentPair.getLeft()).length > 0 ? ((class_1799[])componentPair.getLeft())[0] : null;
        class_1799 second = ((class_1799[])componentPair.getLeft()).length > 1 ? ((class_1799[])componentPair.getLeft())[1] : null;
        int whiteSpace = this.font.method_1727(" ");
        boolean isFirst = true;
        int leftOffset = 0;
        for (class_2561 part : text.method_36136(class_2583.field_24360)) {
            poseStack.method_46416((float)leftOffset, 0.0f, 0.0f);
            String content = part.getString();
            if (content.equals("\ue000")) {
                if (first == null) {
                    leftOffset = isFirst ? 0 : -whiteSpace;
                    continue;
                }
                poseStack.method_22903();
                poseStack.method_22905(-20.0f, -20.0f, 20.0f);
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                this.minecraft.method_1480().method_23178(first, class_811.field_4318, combinedLight, combinedOverlay, poseStack, buffer, (class_1937)class_310.method_1551().field_1687, 0);
                poseStack.method_22909();
                leftOffset = 8 - whiteSpace;
            } else if (content.equals("\ue001")) {
                if (second == null) {
                    leftOffset = isFirst ? 0 : -whiteSpace;
                    continue;
                }
                poseStack.method_22903();
                poseStack.method_22905(-20.0f, -20.0f, 20.0f);
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                this.minecraft.method_1480().method_23178(second, class_811.field_4318, combinedLight, combinedOverlay, poseStack, buffer, (class_1937)class_310.method_1551().field_1687, 0);
                poseStack.method_22909();
                leftOffset = 8 - whiteSpace;
            } else {
                poseStack.method_22903();
                this.font.method_30883(poseStack, part, 0.0f, -6.0f, 0xFFFFFF);
                poseStack.method_22909();
                leftOffset = this.font.method_27525((class_5348)part);
            }
            isFirst = false;
        }
    }

    public boolean shouldRenderOffScreen(AnimalPenTileEntity blockEntity) {
        return !blockEntity.getInventory().method_5442() && AnimalPen.CONFIG_MANAGER.getConfiguration().isGrowAnimals();
    }

    public boolean shouldRender(AnimalPenTileEntity blockEntity, class_243 vec3) {
        return AnimalPen.CONFIG_MANAGER.getConfiguration().isGrowAnimals() || super.method_33892((class_2586)blockEntity, vec3);
    }
}

