/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.animal;

import java.time.LocalTime;
import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.mixin.animal.AnimalPenAnimal;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Bee.class})
public abstract class AnimalPenBee
extends AnimalPenAnimal {
    @Unique
    private int animalPen$pollenCooldown;
    @Unique
    private int animalPen$pollenCount = -1;

    protected AnimalPenBee(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenTick(BlockEntity blockEntity) {
        boolean value = super.animalPen$animalPenTick(blockEntity);
        if (this.animalPen$pollenCooldown > 0) {
            --this.animalPen$pollenCooldown;
            return true;
        }
        if (this.animalPen$pollenCount < 5) {
            ++this.animalPen$pollenCount;
            if (this.animalPen$pollenCount != 5) {
                this.animalPen$pollenCooldown = AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.m_6095_(), Items.f_42788_, this.animalPen$animalCount);
            }
            return true;
        }
        return value;
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenSaveTag(CompoundTag tag) {
        super.animalPen$animalPenSaveTag(tag);
        tag.m_128405_("pollen_cooldown", this.animalPen$pollenCooldown);
        tag.m_128405_("pollen_count", this.animalPen$pollenCount);
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenLoadTag(CompoundTag tag) {
        super.animalPen$animalPenLoadTag(tag);
        this.animalPen$pollenCooldown = tag.m_128451_("pollen_cooldown");
        this.animalPen$pollenCount = tag.m_128451_("pollen_count");
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenInteract(Player player, InteractionHand hand, BlockPos position) {
        if (super.animalPen$animalPenInteract(player, hand, position)) {
            return true;
        }
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_42574_)) {
            if (this.animalPen$pollenCount < 5) {
                return false;
            }
            if (player.m_9236_().m_5776_()) {
                return true;
            }
            itemStack.m_41622_(1, (LivingEntity)player, playerx -> playerx.m_21190_(hand));
            Block.m_49840_((Level)player.m_9236_(), (BlockPos)position.m_7494_(), (ItemStack)new ItemStack((ItemLike)Items.f_42784_, 3));
            player.m_9236_().m_5594_(null, position, SoundEvents.f_11697_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$pollenCount = 0;
            this.animalPen$pollenCooldown = AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.m_6095_(), Items.f_42788_, this.animalPen$animalCount);
            return true;
        }
        if (itemStack.m_150930_(Items.f_42590_)) {
            if (this.animalPen$pollenCount < 5) {
                return false;
            }
            if (player.m_9236_().m_5776_()) {
                return true;
            }
            ItemStack remainingStack = ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)Items.f_42787_.m_7968_());
            player.m_21008_(hand, remainingStack);
            player.m_9236_().m_5594_(null, position, SoundEvents.f_11770_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$pollenCount = 0;
            this.animalPen$pollenCooldown = AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.m_6095_(), Items.f_42788_, this.animalPen$animalCount);
            return true;
        }
        return false;
    }

    @Override
    @Intrinsic
    public List<Pair<ItemStack, Component>> animalPen$animalPenGetLines(int tick) {
        MutableComponent component;
        List<Pair<ItemStack, Component>> lines = super.animalPen$animalPenGetLines(tick);
        if (AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.m_6095_(), Items.f_42788_, this.animalPen$animalCount) == 0) {
            return lines;
        }
        if (this.animalPen$pollenCooldown != 0) {
            component = Component.m_237110_((String)"display.animal_pen.pollen_cooldown", (Object[])new Object[]{LocalTime.of(0, 0, 0).plusSeconds(this.animalPen$pollenCooldown / 20).format(AnimalPen.DATE_FORMATTER)});
            lines.add((Pair<ItemStack, Component>)Pair.of((Object)Items.f_42788_.m_7968_(), (Object)component));
        }
        if (this.animalPen$pollenCount >= 0) {
            component = this.animalPen$pollenCount == 5 ? Component.m_237110_((String)"display.animal_pen.pollen_level_max", (Object[])new Object[]{this.animalPen$pollenCount}) : Component.m_237110_((String)"display.animal_pen.pollen_level", (Object[])new Object[]{this.animalPen$pollenCount});
            ItemStack itemStack = tick / 100 % 2 == 0 ? Items.f_42574_.m_7968_() : Items.f_42590_.m_7968_();
            lines.add((Pair<ItemStack, Component>)Pair.of((Object)itemStack, (Object)component));
        }
        return lines;
    }
}

