/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.blocks.entities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.entities.AnimalPenBlockInterface;
import lv.id.bonne.animalpen.interfaces.AnimalPenInterface;
import lv.id.bonne.animalpen.items.AnimalCageItem;
import lv.id.bonne.animalpen.network.packets.UpdateVariantScreenData;
import lv.id.bonne.animalpen.registries.AnimalPenTileEntityRegistry;
import lv.id.bonne.animalpen.registries.AnimalPensItemRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_52;
import net.minecraft.class_8567;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimalPenTileEntity
extends class_2586
implements AnimalPenBlockInterface<class_1429> {
    private final class_1277 inventory = new class_1277(1){

        public boolean method_5437(int slot, class_1799 stack) {
            return stack.method_31574((class_1792)AnimalPensItemRegistry.ANIMAL_CAGE.get());
        }

        public void method_5431() {
            super.method_5431();
            AnimalPenTileEntity.this.triggerUpdate();
        }
    };
    private class_1429 storedAnimal;
    private long displaySize = -1L;
    private int tickCounter;
    private final List<Integer> deathTicker = new ArrayList<Integer>();
    public static final String TAG_INVENTORY = "inventory";
    public static final String TAG_DEATH_TICKER = "death_ticker";
    public static final String TAG_DISPLAY_SIZE = "display_size";

    public AnimalPenTileEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)AnimalPenTileEntityRegistry.ANIMAL_PEN_TILE_ENTITY.get(), blockPos, blockState);
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10566(TAG_INVENTORY, (class_2520)this.inventory.method_7660());
        tag.method_10566(TAG_DEATH_TICKER, (class_2520)new class_2495(this.deathTicker));
        tag.method_10544(TAG_DISPLAY_SIZE, this.displaySize);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.inventory.method_5448();
        this.deathTicker.clear();
        this.storedAnimal = null;
        if (tag.method_10573(TAG_INVENTORY, 9)) {
            this.inventory.method_7659(tag.method_10554(TAG_INVENTORY, 10));
        }
        if (tag.method_10573(TAG_DEATH_TICKER, 11)) {
            int[] intArray;
            for (int i : intArray = tag.method_10561(TAG_DEATH_TICKER)) {
                this.deathTicker.add(i);
            }
        }
        this.displaySize = tag.method_10573(TAG_DISPLAY_SIZE, 4) ? tag.method_10537(TAG_DISPLAY_SIZE) : -1L;
    }

    @NotNull
    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @Override
    public class_1429 getStoredAnimal() {
        if (this.storedAnimal == null && !this.getItemStack().method_7960()) {
            class_2487 tag = this.getItemStack().method_7948();
            if (!tag.method_10545("id") || this.field_11863 == null) {
                return this.storedAnimal;
            }
            class_1299.method_5892((class_2487)tag, (class_1937)this.field_11863).map(entity -> (class_1429)entity).ifPresent(animal -> {
                this.storedAnimal = animal;
            });
        } else if (this.storedAnimal != null && this.getItemStack().method_7960()) {
            this.storedAnimal = null;
        }
        return this.storedAnimal;
    }

    public List<Integer> getDeathTicker() {
        return this.deathTicker;
    }

    public int getTickCounter() {
        return this.tickCounter;
    }

    public void tick() {
        ++this.tickCounter;
        if (this.method_10997() == null || this.method_10997().method_8608()) {
            return;
        }
        boolean updated = false;
        class_1429 animal = this.getStoredAnimal();
        if (animal != null && ((AnimalPenInterface)animal).animalPenTick(this)) {
            updated = true;
        }
        for (int i = 0; i < this.deathTicker.size(); ++i) {
            this.deathTicker.set(i, this.deathTicker.get(i) + 1);
            updated = true;
        }
        this.deathTicker.removeIf(integer -> integer > 20);
        if (updated) {
            this.triggerUpdate();
        }
    }

    public boolean processContainer(class_1657 player, class_1268 interactionHand) {
        if (this.inventory.method_5442()) {
            class_1799 itemInHand = player.method_5998(interactionHand);
            if (!itemInHand.method_7948().method_10545("id")) {
                return false;
            }
            if (!player.method_37908().method_8608()) {
                this.inventory.method_5491(itemInHand);
                player.method_6122(interactionHand, class_1799.field_8037);
                if (this.field_11863 != null && !this.field_11863.method_8608()) {
                    AnimalPen.CHANNEL.sendToPlayers(((class_3218)this.field_11863).method_18456().stream().filter(other -> other.method_5649((double)this.method_11016().method_10263(), (double)this.method_11016().method_10264(), (double)this.method_11016().method_10260()) < 50.0).toList(), (Object)new UpdateVariantScreenData(this.method_11016()));
                }
            }
            return true;
        }
        class_1799 itemInHand = player.method_5998(interactionHand);
        class_2487 itemInHandTag = itemInHand.method_7948();
        if (!itemInHandTag.method_10545("id")) {
            if (!player.method_18276()) {
                return false;
            }
            if (player.method_37908().method_8608()) {
                return true;
            }
            class_1429 animal = this.getStoredAnimal();
            if (animal == null) {
                return false;
            }
            long currentCount = ((AnimalPenInterface)animal).animalPenGetCount();
            if (currentCount < 2L) {
                return false;
            }
            long newCount = currentCount / 2L;
            if (!((AnimalPenInterface)animal).animalPenUpdateCount(-newCount)) {
                return false;
            }
            animal.method_5662(itemInHandTag);
            itemInHandTag.method_10544("animal_count", newCount);
            player.method_6122(interactionHand, itemInHand);
            this.inventory.method_5431();
            return true;
        }
        class_1429 animal = this.getStoredAnimal();
        if (animal == null || !itemInHandTag.method_10558("id").equals(animal.method_5864().arch$registryName().toString())) {
            return false;
        }
        if (player.method_37908().method_8608()) {
            return true;
        }
        long newCount = itemInHandTag.method_10537("animal_count");
        if (newCount <= 0L || !((AnimalPenInterface)animal).animalPenUpdateCount(newCount)) {
            return false;
        }
        if (newCount > 1L && !AnimalCageItem.canMergeAnimalVariants(this.getItemStack(), itemInHand, player)) {
            ((AnimalPenInterface)animal).animalPenUpdateCount(-1L);
            itemInHandTag.method_10544("animal_count", 1L);
            itemInHand.method_7980(itemInHandTag);
        } else {
            AnimalCageItem.mergeAnimalVariants(this.getItemStack(), itemInHand, player);
            itemInHand.method_7980(new class_2487());
            if (this.field_11863 != null && !this.field_11863.method_8608()) {
                AnimalPen.CHANNEL.sendToPlayers(((class_3218)this.field_11863).method_18456().stream().filter(other -> other.method_5649((double)this.method_11016().method_10263(), (double)this.method_11016().method_10264(), (double)this.method_11016().method_10260()) < 50.0).toList(), (Object)new UpdateVariantScreenData(this.method_11016()));
            }
        }
        player.method_6122(interactionHand, itemInHand);
        this.inventory.method_5431();
        return true;
    }

    public boolean interactWithPen(class_1657 player, class_1268 interactionHand) {
        class_1799 itemInHand = player.method_5998(interactionHand);
        if (itemInHand.method_7960() && !this.inventory.method_5442()) {
            if (player.method_18276() && !player.method_37908().method_8608()) {
                class_1799 item = this.getItemStack();
                player.method_6122(interactionHand, item);
                this.inventory.method_5447(0, class_1799.field_8037);
                this.inventory.method_5431();
            }
            return true;
        }
        class_1429 animal = this.getStoredAnimal();
        if (animal == null) {
            return false;
        }
        if (((AnimalPenInterface)animal).animalPenInteract(player, interactionHand, this.method_11016())) {
            class_1799 item = this.getItemStack();
            Optional<class_2499> optionalVariants = AnimalCageItem.getAnimalVariants(item);
            class_2487 tag = new class_2487();
            animal.method_5662(tag);
            optionalVariants.ifPresent(variants -> tag.method_10566("animal_variants", (class_2520)variants));
            item.method_7980(tag);
            this.inventory.method_5431();
            return true;
        }
        return false;
    }

    public void attackThePen(class_1657 player, class_1937 level) {
        class_1799 weapon = player.method_5998(class_1268.field_5808);
        class_1429 animal = this.getStoredAnimal();
        if (animal == null) {
            return;
        }
        if (!((AnimalPenInterface)animal).animalPenUpdateCount(-1L)) {
            return;
        }
        weapon.method_7956(1, (class_1309)player, playerx -> playerx.method_20236(class_1268.field_5808));
        this.deathTicker.add(0);
        if (((AnimalPenInterface)animal).animalPenGetCount() <= 0L) {
            class_1799 item = this.getItemStack();
            item.method_7980(new class_2487());
            class_2248.method_9577((class_1937)level, (class_2338)this.method_11016().method_10084(), (class_1799)item);
            this.inventory.method_5447(0, class_1799.field_8037);
        }
        this.triggerUpdate();
        class_243 position = new class_243((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260());
        class_52 lootTable = level.method_8503().method_3857().getLootTable(animal.method_5989());
        class_8567.class_8568 paramsBuilder = new class_8567.class_8568((class_3218)level).method_51874(class_181.field_24424, (Object)position).method_51874(class_181.field_1226, (Object)animal).method_51874(class_181.field_1230, (Object)player).method_51874(class_181.field_1227, (Object)player).method_51874(class_181.field_1233, (Object)player).method_51874(class_181.field_1231, (Object)level.method_48963().method_48802(player)).method_51871(player.method_7292());
        lootTable.method_51879(paramsBuilder.method_51875(class_173.field_1173), level.method_8409().method_43055()).forEach(itemStack -> class_2248.method_9577((class_1937)level, (class_2338)this.method_11016().method_10084(), (class_1799)itemStack));
        int reward = animal.method_6110();
        class_1303.method_31493((class_3218)((class_3218)this.field_11863), (class_243)position.method_1031(0.5, 1.0, 0.5), (int)reward);
    }

    public int getRedStoneSignal() {
        if (this.getStoredAnimal() == null) {
            return 0;
        }
        return ((AnimalPenInterface)this.storedAnimal).getRedStoneSignal();
    }

    @Override
    public void triggerUpdate() {
        this.method_5431();
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return;
        }
        class_1429 animal = this.getStoredAnimal();
        if (animal != null) {
            animal.method_5662(this.getItemStack().method_7948());
        }
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
    }

    public class_1277 getInventory() {
        return this.inventory;
    }

    private class_1799 getItemStack() {
        return this.inventory.method_5438(0);
    }

    @Override
    public class_2499 getEntityVariants() {
        if (this.getStoredAnimal() == null) {
            return new class_2499();
        }
        return AnimalCageItem.getAnimalVariants(this.getItemStack()).orElseGet(class_2499::new);
    }

    @Override
    public long getAnimalDisplaySize() {
        return this.displaySize < 1L ? this.getAnimalCount() : Math.min(this.displaySize, this.getAnimalCount());
    }

    @Override
    public void setAnimalDisplaySize(long size) {
        this.displaySize = size;
        this.triggerUpdate();
    }

    @Override
    public void updateAnimalVariant(class_2487 animalVariant) {
        if (this.getStoredAnimal() == null || animalVariant == null || animalVariant.method_33133()) {
            return;
        }
        class_2487 extraData = new class_2487();
        ((AnimalPenInterface)this.storedAnimal).animalPenSaveTag(extraData);
        this.storedAnimal.method_5651(animalVariant);
        ((AnimalPenInterface)this.storedAnimal).animalPenLoadTag(extraData);
        this.triggerUpdate();
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            AnimalPen.CHANNEL.sendToPlayers(((class_3218)this.field_11863).method_18456().stream().filter(other -> other.method_5649((double)this.method_11016().method_10263(), (double)this.method_11016().method_10264(), (double)this.method_11016().method_10260()) < 50.0).toList(), (Object)new UpdateVariantScreenData(this.method_11016()));
        }
    }

    @Override
    public void removeAnimalVariant(int index) {
        if (this.getStoredAnimal() == null || this.getEntityVariants().size() <= index) {
            return;
        }
        this.getEntityVariants().method_10536(index);
        this.inventory.method_5431();
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            AnimalPen.CHANNEL.sendToPlayers(((class_3218)this.field_11863).method_18456().stream().filter(other -> other.method_5649((double)this.method_11016().method_10263(), (double)this.method_11016().method_10264(), (double)this.method_11016().method_10260()) < 50.0).toList(), (Object)new UpdateVariantScreenData(this.method_11016()));
        }
    }

    @Override
    public long getAnimalCount() {
        return this.getStoredAnimal() == null ? 0L : ((AnimalPenInterface)this.getStoredAnimal()).animalPenGetCount();
    }

    @Override
    public boolean canGrowEntity() {
        return AnimalPen.CONFIG_MANAGER.getConfiguration().isGrowAnimals();
    }

    @Override
    public List<Pair<class_1799[], class_2561>> getCooldownLines(boolean shortText) {
        if (this.getStoredAnimal() == null) {
            return Collections.emptyList();
        }
        return ((AnimalPenInterface)this.storedAnimal).animalPenGetLines(this.getTickCounter(), shortText);
    }
}

