/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.blocks.entities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.AquariumBlock;
import lv.id.bonne.animalpen.blocks.entities.AnimalPenBlockInterface;
import lv.id.bonne.animalpen.interfaces.AnimalPenInterface;
import lv.id.bonne.animalpen.items.AnimalContainerItem;
import lv.id.bonne.animalpen.network.packets.UpdateVariantScreenData;
import lv.id.bonne.animalpen.registries.AnimalPenTileEntityRegistry;
import lv.id.bonne.animalpen.registries.AnimalPensItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AquariumTileEntity
extends BlockEntity
implements AnimalPenBlockInterface<WaterAnimal> {
    private final SimpleContainer inventory = new SimpleContainer(1){

        public boolean m_7013_(int slot, ItemStack stack) {
            return stack.m_150930_((Item)AnimalPensItemRegistry.ANIMAL_CONTAINER.get());
        }

        public void m_6596_() {
            super.m_6596_();
            AquariumTileEntity.this.triggerUpdate();
        }
    };
    private WaterAnimal storedAnimal;
    private long displaySize = -1L;
    private int tickCounter;
    private final List<Integer> deathTicker = new ArrayList<Integer>();
    public static final String TAG_INVENTORY = "inventory";
    public static final String TAG_DEATH_TICKER = "death_ticker";
    public static final String TAG_DISPLAY_SIZE = "display_size";

    public AquariumTileEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)AnimalPenTileEntityRegistry.AQUARIUM_TILE_ENTITY.get(), blockPos, blockState);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(TAG_INVENTORY, (Tag)this.inventory.m_7927_());
        tag.m_128365_(TAG_DEATH_TICKER, (Tag)new IntArrayTag(this.deathTicker));
        tag.m_128356_(TAG_DISPLAY_SIZE, this.displaySize);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.m_6211_();
        this.deathTicker.clear();
        this.storedAnimal = null;
        if (tag.m_128425_(TAG_INVENTORY, 9)) {
            this.inventory.m_7797_(tag.m_128437_(TAG_INVENTORY, 10));
        }
        if (tag.m_128425_(TAG_DEATH_TICKER, 11)) {
            int[] intArray;
            for (int i : intArray = tag.m_128465_(TAG_DEATH_TICKER)) {
                this.deathTicker.add(i);
            }
        }
        this.displaySize = tag.m_128425_(TAG_DISPLAY_SIZE, 4) ? tag.m_128454_(TAG_DISPLAY_SIZE) : -1L;
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public WaterAnimal getStoredAnimal() {
        if (this.storedAnimal == null && !this.getItemStack().m_41619_()) {
            CompoundTag tag = this.getItemStack().m_41784_();
            if (!tag.m_128441_("id") || this.f_58857_ == null) {
                return this.storedAnimal;
            }
            EntityType.m_20642_((CompoundTag)tag, (Level)this.f_58857_).map(entity -> (WaterAnimal)entity).ifPresent(animal -> {
                this.storedAnimal = animal;
            });
        } else if (this.storedAnimal != null && this.getItemStack().m_41619_()) {
            this.storedAnimal = null;
        }
        return this.storedAnimal;
    }

    public List<Integer> getDeathTicker() {
        return this.deathTicker;
    }

    public int getTickCounter() {
        return this.tickCounter;
    }

    public void tick() {
        ++this.tickCounter;
        if (this.m_58904_() == null || this.m_58904_().m_5776_()) {
            return;
        }
        boolean updated = false;
        WaterAnimal animal = this.getStoredAnimal();
        if (animal != null && ((AnimalPenInterface)animal).animalPenTick(this)) {
            updated = true;
        }
        for (int i = 0; i < this.deathTicker.size(); ++i) {
            this.deathTicker.set(i, this.deathTicker.get(i) + 1);
            updated = true;
        }
        this.deathTicker.removeIf(integer -> integer > 20);
        if (updated) {
            this.triggerUpdate();
        }
    }

    public boolean processContainer(Player player, InteractionHand interactionHand) {
        if (this.inventory.m_7983_()) {
            ItemStack itemInHand = player.m_21120_(interactionHand);
            if (!itemInHand.m_41784_().m_128441_("id")) {
                return false;
            }
            if (!player.m_9236_().m_5776_()) {
                this.inventory.m_19173_(itemInHand);
                player.m_21008_(interactionHand, ItemStack.f_41583_);
                if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
                    AnimalPen.CHANNEL.sendToPlayers(((ServerLevel)this.f_58857_).m_6907_().stream().filter(other -> other.m_20275_((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_()) < 50.0).toList(), (Object)new UpdateVariantScreenData(this.m_58899_()));
                }
            }
            return true;
        }
        ItemStack itemInHand = player.m_21120_(interactionHand);
        CompoundTag itemInHandTag = itemInHand.m_41784_();
        if (!itemInHandTag.m_128441_("id")) {
            if (!player.m_6047_()) {
                return false;
            }
            if (player.m_9236_().m_5776_()) {
                return true;
            }
            WaterAnimal animal = this.getStoredAnimal();
            if (animal == null) {
                return false;
            }
            long currentCount = ((AnimalPenInterface)animal).animalPenGetCount();
            if (currentCount < 2L) {
                return false;
            }
            long newCount = currentCount / 2L;
            if (!((AnimalPenInterface)animal).animalPenUpdateCount(-newCount)) {
                return false;
            }
            animal.m_20223_(itemInHandTag);
            itemInHandTag.m_128356_("animal_count", newCount);
            player.m_21008_(interactionHand, itemInHand);
            this.inventory.m_6596_();
            return true;
        }
        WaterAnimal animal = this.getStoredAnimal();
        if (animal == null || !itemInHandTag.m_128461_("id").equals(animal.m_6095_().arch$registryName().toString())) {
            return false;
        }
        if (player.m_9236_().m_5776_()) {
            return true;
        }
        long newCount = itemInHandTag.m_128454_("animal_count");
        if (newCount <= 0L || !((AnimalPenInterface)animal).animalPenUpdateCount(newCount)) {
            return false;
        }
        if (newCount > 1L && !AnimalContainerItem.canMergeAnimalVariants(this.getItemStack(), itemInHand, player)) {
            ((AnimalPenInterface)animal).animalPenUpdateCount(-1L);
            itemInHandTag.m_128356_("animal_count", 1L);
            itemInHand.m_41751_(itemInHandTag);
        } else {
            AnimalContainerItem.mergeAnimalVariants(this.getItemStack(), itemInHand, player);
            itemInHand.m_41751_(new CompoundTag());
            if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
                AnimalPen.CHANNEL.sendToPlayers(((ServerLevel)this.f_58857_).m_6907_().stream().filter(other -> other.m_20275_((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_()) < 50.0).toList(), (Object)new UpdateVariantScreenData(this.m_58899_()));
            }
        }
        player.m_21008_(interactionHand, itemInHand);
        this.inventory.m_6596_();
        return true;
    }

    public boolean interactWithPen(Player player, InteractionHand interactionHand) {
        ItemStack itemInHand = player.m_21120_(interactionHand);
        if (itemInHand.m_41619_() && !this.inventory.m_7983_()) {
            if (player.m_6047_() && !player.m_9236_().m_5776_()) {
                ItemStack item = this.getItemStack();
                player.m_21008_(interactionHand, item);
                this.inventory.m_6836_(0, ItemStack.f_41583_);
                this.inventory.m_6596_();
            }
            return true;
        }
        WaterAnimal animal = this.getStoredAnimal();
        if (animal == null) {
            return false;
        }
        if (((AnimalPenInterface)animal).animalPenInteract(player, interactionHand, this.m_58899_())) {
            ItemStack item = this.getItemStack();
            Optional<ListTag> optionalVariants = AnimalContainerItem.getAnimalVariants(item);
            CompoundTag tag = new CompoundTag();
            animal.m_20223_(tag);
            optionalVariants.ifPresent(variants -> tag.m_128365_("animal_variants", (Tag)variants));
            item.m_41751_(tag);
            this.inventory.m_6596_();
            return true;
        }
        return false;
    }

    public void attackThePen(Player player, Level level) {
        ItemStack weapon = player.m_21120_(InteractionHand.MAIN_HAND);
        WaterAnimal animal = this.getStoredAnimal();
        if (animal == null) {
            return;
        }
        if (!((AnimalPenInterface)animal).animalPenUpdateCount(-1L)) {
            return;
        }
        weapon.m_41622_(1, (LivingEntity)player, playerx -> playerx.m_21190_(InteractionHand.MAIN_HAND));
        this.deathTicker.add(0);
        if (((AnimalPenInterface)animal).animalPenGetCount() <= 0L) {
            ItemStack item = this.getItemStack();
            item.m_41751_(new CompoundTag());
            Block.m_49840_((Level)level, (BlockPos)this.m_58899_().m_7494_(), (ItemStack)item);
            this.inventory.m_6836_(0, ItemStack.f_41583_);
        }
        this.triggerUpdate();
        Vec3 position = new Vec3((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_());
        LootTable lootTable = level.m_7654_().m_129898_().m_79217_(animal.m_5743_());
        LootContext.Builder contextBuilder = new LootContext.Builder((ServerLevel)level).m_78972_(LootContextParams.f_81460_, (Object)position).m_78972_(LootContextParams.f_81455_, (Object)animal).m_78972_(LootContextParams.f_81458_, (Object)player).m_78972_(LootContextParams.f_81459_, (Object)player).m_78972_(LootContextParams.f_81456_, (Object)player).m_78972_(LootContextParams.f_81457_, (Object)DamageSource.m_19344_((Player)player)).m_78963_(player.m_36336_()).m_230911_(level.f_46441_);
        lootTable.m_230922_(contextBuilder.m_78975_(LootContextParamSets.f_81415_)).forEach(itemStack -> Block.m_49840_((Level)level, (BlockPos)this.m_58899_().m_7637_(0.5, 1.5, 0.5), (ItemStack)itemStack));
        int reward = animal.m_213860_();
        ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)this.f_58857_), (Vec3)position.m_82520_(0.5, 1.5, 0.5), (int)reward);
    }

    public int getRedStoneSignal() {
        if (this.getStoredAnimal() == null) {
            return 0;
        }
        return ((AnimalPenInterface)this.storedAnimal).getRedStoneSignal();
    }

    @Override
    public void triggerUpdate() {
        this.m_6596_();
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        WaterAnimal animal = this.getStoredAnimal();
        if (animal != null) {
            animal.m_20223_(this.getItemStack().m_41784_());
        }
        BlockState oldState = this.m_58900_();
        BlockState newState = this.m_58900_();
        if (((Boolean)oldState.m_61143_((Property)AquariumBlock.FILLED)).booleanValue() == this.inventory.m_7983_()) {
            newState = (BlockState)oldState.m_61124_((Property)AquariumBlock.FILLED, (Comparable)Boolean.valueOf(!this.inventory.m_7983_()));
            this.f_58857_.m_7731_(this.m_58899_(), newState, 2);
            this.m_6596_();
        }
        this.f_58857_.m_7260_(this.m_58899_(), oldState, newState, 2);
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    private ItemStack getItemStack() {
        return this.inventory.m_8020_(0);
    }

    @Override
    public ListTag getEntityVariants() {
        if (this.getStoredAnimal() == null) {
            return new ListTag();
        }
        return AnimalContainerItem.getAnimalVariants(this.getItemStack()).orElseGet(ListTag::new);
    }

    @Override
    public long getAnimalDisplaySize() {
        return this.displaySize < 1L ? this.getAnimalCount() : Math.min(this.displaySize, this.getAnimalCount());
    }

    @Override
    public void setAnimalDisplaySize(long size) {
        this.displaySize = size;
        this.triggerUpdate();
    }

    @Override
    public void updateAnimalVariant(CompoundTag animalVariant) {
        if (this.getStoredAnimal() == null || animalVariant == null || animalVariant.m_128456_()) {
            return;
        }
        CompoundTag extraData = new CompoundTag();
        ((AnimalPenInterface)this.storedAnimal).animalPenSaveTag(extraData);
        this.storedAnimal.m_20258_(animalVariant);
        ((AnimalPenInterface)this.storedAnimal).animalPenLoadTag(extraData);
        this.triggerUpdate();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            AnimalPen.CHANNEL.sendToPlayers(((ServerLevel)this.f_58857_).m_6907_().stream().filter(other -> other.m_20275_((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_()) < 50.0).toList(), (Object)new UpdateVariantScreenData(this.m_58899_()));
        }
    }

    @Override
    public void removeAnimalVariant(int index) {
        if (this.getStoredAnimal() == null || this.getEntityVariants().size() <= index) {
            return;
        }
        this.getEntityVariants().remove(index);
        this.inventory.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            AnimalPen.CHANNEL.sendToPlayers(((ServerLevel)this.f_58857_).m_6907_().stream().filter(other -> other.m_20275_((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_()) < 50.0).toList(), (Object)new UpdateVariantScreenData(this.m_58899_()));
        }
    }

    @Override
    public long getAnimalCount() {
        return ((AnimalPenInterface)this.getStoredAnimal()).animalPenGetCount();
    }

    @Override
    public boolean canGrowEntity() {
        return AnimalPen.CONFIG_MANAGER.getConfiguration().isGrowWaterAnimals();
    }

    @Override
    public List<Pair<ItemStack[], Component>> getCooldownLines(boolean shortText) {
        if (this.getStoredAnimal() == null) {
            return Collections.emptyList();
        }
        return ((AnimalPenInterface)this.storedAnimal).animalPenGetLines(this.getTickCounter(), shortText);
    }
}

