/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.animal;

import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.mixin.animal.AnimalPenAnimal;
import lv.id.bonne.animalpen.registries.AnimalPenFoodRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Axolotl.class})
public abstract class AnimalPenAxolotl
extends AnimalPenAnimal {
    @Unique
    private int animalPen$storedFood = 0;

    @Shadow
    public abstract void m_6872_(ItemStack var1);

    protected AnimalPenAxolotl(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenSaveTag(CompoundTag tag) {
        super.animalPen$animalPenSaveTag(tag);
        tag.m_128405_("stored_food", this.animalPen$storedFood);
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenLoadTag(CompoundTag tag) {
        super.animalPen$animalPenLoadTag(tag);
        this.animalPen$storedFood = tag.m_128451_("stored_food");
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenInteract(Player player, InteractionHand hand, BlockPos position) {
        ItemStack itemStack = player.m_21120_(hand);
        if (AnimalPenFoodRegistry.isFood(this.m_6095_().arch$registryName(), itemStack)) {
            if (player.m_9236_().m_5776_()) {
                return true;
            }
            ++this.animalPen$storedFood;
            if (!player.m_150110_().f_35937_) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42447_));
            }
            if (this.animalPen$foodCooldown > 0 || this.animalPen$storedFood < 2) {
                return false;
            }
            long maxCount = AnimalPen.CONFIG_MANAGER.getConfiguration().getMaximalAnimalCount();
            if (maxCount > 0L && this.animalPen$animalCount >= maxCount) {
                return false;
            }
            int stackSize = (int)Math.min(this.animalPen$animalCount, (long)this.animalPen$storedFood);
            if (stackSize < 2) {
                return false;
            }
            stackSize = (int)Math.min((maxCount - this.animalPen$animalCount) * 2L, (long)stackSize);
            this.animalPen$animalCount += (long)(stackSize / 2);
            this.animalPen$storedFood -= stackSize;
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, (double)((float)position.m_123341_() + 0.5f), (double)position.m_123342_() + 1.5, (double)((float)position.m_123343_() + 0.5f), 5, 0.2, 0.2, 0.2, 0.05);
            }
            player.m_9236_().m_5594_(null, position, this.m_7866_(itemStack), SoundSource.NEUTRAL, 1.0f, Mth.m_216283_((RandomSource)player.m_9236_().f_46441_, (float)0.8f, (float)1.2f));
            SoundEvent soundEvent = this.m_7515_();
            if (soundEvent != null) {
                player.m_9236_().m_5594_(null, position, soundEvent, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            this.animalPen$foodCooldown = AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.m_6095_(), Items.f_42410_, stackSize);
            return true;
        }
        if (itemStack.m_150930_(Items.f_42447_)) {
            if (player.m_9236_().m_5776_()) {
                return true;
            }
            if (this.animalPen$animalCount <= 1L) {
                return false;
            }
            ItemStack bucket = new ItemStack((ItemLike)Items.f_151057_);
            this.m_6872_(bucket);
            --this.animalPen$animalCount;
            player.m_21008_(hand, ItemUtils.m_41817_((ItemStack)itemStack, (Player)player, (ItemStack)bucket, (boolean)false));
            player.m_9236_().m_5594_(null, position, SoundEvents.f_144077_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    @Intrinsic
    public ItemStack animalPen$animalPenInteract(ServerLevel level, ItemStack itemStack, BlockPos position) {
        if (itemStack.m_150930_(Items.f_42447_)) {
            if (this.animalPen$animalCount <= 1L) {
                return ItemStack.f_41583_;
            }
            ItemStack bucket = new ItemStack((ItemLike)Items.f_151057_);
            this.m_6872_(bucket);
            itemStack.m_41774_(1);
            level.m_5594_(null, position, SoundEvents.f_144077_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            --this.animalPen$animalCount;
            return bucket;
        }
        return super.animalPen$animalPenInteract(level, itemStack, position);
    }

    @Override
    @Intrinsic
    public List<Pair<ItemStack[], Component>> animalPen$animalPenGetLines(int tick, boolean shortLine) {
        List<Pair<ItemStack[], Component>> lines = super.animalPen$animalPenGetLines(tick, shortLine);
        if (this.animalPen$getFood() == null || this.animalPen$getFood().length == 0 || AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.m_6095_(), Items.f_42410_, this.animalPen$animalCount) == 0) {
            return lines;
        }
        MutableComponent component = Component.m_237110_((String)"display.animal_pen.stored_food", (Object[])new Object[]{Component.m_237113_((String)"\ue000"), this.animalPen$storedFood});
        ItemStack[] food = this.animalPen$getFood();
        if (food != null && food.length != 0) {
            ItemStack foodItem;
            if (food.length == 1) {
                foodItem = food[0];
            } else {
                int size = food.length;
                int index = tick / 100 % size;
                foodItem = food[index];
            }
            lines.add((Pair<ItemStack[], Component>)Pair.of((Object)new ItemStack[]{foodItem}, (Object)component));
        }
        if (!shortLine && this.animalPen$animalCount > 1L) {
            component = Component.m_237110_((String)"display.animal_pen.full_ready", (Object[])new Object[]{Component.m_237113_((String)"\ue000"), Component.m_237113_((String)"\ue001")}).m_130940_(ChatFormatting.GREEN);
            ItemStack bucket = new ItemStack((ItemLike)Items.f_151057_);
            this.m_6872_(bucket);
            lines.add((Pair<ItemStack[], Component>)Pair.of((Object)new ItemStack[]{Items.f_42447_.m_7968_(), bucket}, (Object)component));
        }
        return lines;
    }
}

