/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.registries;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import lv.id.bonne.animalpen.blocks.AnimalPenBlock;
import lv.id.bonne.animalpen.blocks.AquariumBlock;
import lv.id.bonne.animalpen.registries.AnimalPensCreativeTabRegistry;
import lv.id.bonne.animalpen.registries.AnimalPensItemRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;

public class AnimalPenBlockRegistry {
    public static final DeferredRegister<Block> REGISTRY = DeferredRegister.create((String)"animal_pen", (ResourceKey)Registry.f_122901_);
    public static final Map<WoodType, RegistrySupplier<Block>> ANIMAL_PENS = new HashMap<WoodType, RegistrySupplier<Block>>();
    public static final RegistrySupplier<Block> AQUARIUM = AnimalPenBlockRegistry.registerBlock("aquarium_block", () -> new AquariumBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60978_(1.0f).m_60918_(SoundType.f_56744_).m_60955_()));

    public static void register() {
        REGISTRY.register();
    }

    private static <T extends Block> RegistrySupplier<T> registerBlock(String name, Supplier<T> block) {
        RegistrySupplier toReturn = REGISTRY.register(name, block);
        AnimalPenBlockRegistry.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistrySupplier<Item> registerBlockItem(String name, RegistrySupplier<T> block) {
        return AnimalPensItemRegistry.REGISTRY.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(AnimalPensCreativeTabRegistry.ANIMAL_PEN_TAB)));
    }

    public static void registerPen(WoodType woodType, Material material, MaterialColor materialColor, SoundType soundType) {
        String woodName = woodType.m_61846_().toLowerCase();
        if (woodType.m_61846_().contains(":")) {
            woodName = woodName.replaceAll(":", "_");
        }
        RegistrySupplier<Block> block = AnimalPenBlockRegistry.registerBlock("animal_pen_" + woodName, () -> new AnimalPenBlock(BlockBehaviour.Properties.m_60944_((Material)material, (MaterialColor)materialColor).m_60978_(1.0f).m_60918_(soundType).m_60955_()));
        ANIMAL_PENS.put(woodType, block);
    }

    static {
        AnimalPenBlockRegistry.registerPen(WoodType.f_61830_, Material.f_76320_, MaterialColor.f_76411_, SoundType.f_56736_);
        AnimalPenBlockRegistry.registerPen(WoodType.f_61831_, Material.f_76320_, MaterialColor.f_76370_, SoundType.f_56736_);
        AnimalPenBlockRegistry.registerPen(WoodType.f_61832_, Material.f_76320_, MaterialColor.f_76400_, SoundType.f_56736_);
        AnimalPenBlockRegistry.registerPen(WoodType.f_61833_, Material.f_76320_, MaterialColor.f_76419_, SoundType.f_56736_);
        AnimalPenBlockRegistry.registerPen(WoodType.f_61834_, Material.f_76320_, MaterialColor.f_76408_, SoundType.f_56736_);
        AnimalPenBlockRegistry.registerPen(WoodType.f_61835_, Material.f_76320_, MaterialColor.f_76362_, SoundType.f_56736_);
        AnimalPenBlockRegistry.registerPen(WoodType.f_61836_, Material.f_76321_, MaterialColor.f_76390_, SoundType.f_56763_);
        AnimalPenBlockRegistry.registerPen(WoodType.f_61837_, Material.f_76321_, MaterialColor.f_76393_, SoundType.f_56763_);
        AnimalPenBlockRegistry.registerPen(WoodType.f_223002_, Material.f_76320_, MaterialColor.f_76364_, SoundType.f_56736_);
    }
}

