/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.animal;

import java.time.LocalTime;
import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.mixin.animal.AnimalPenAnimal;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Armadillo.class})
public abstract class AnimalPenArmadillo
extends AnimalPenAnimal {
    @Unique
    private int animalPen$scuteCooldown;

    protected AnimalPenArmadillo(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenTick(BlockEntity blockEntity) {
        boolean value = super.animalPen$animalPenTick(blockEntity);
        if (this.animalPen$scuteCooldown > 0) {
            --this.animalPen$scuteCooldown;
            return true;
        }
        return value;
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenSaveTag(CompoundTag tag) {
        super.animalPen$animalPenSaveTag(tag);
        if (this.animalPen$scuteCooldown > 0) {
            tag.putInt("scute_cooldown", this.animalPen$scuteCooldown);
        }
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenLoadTag(CompoundTag tag) {
        super.animalPen$animalPenLoadTag(tag);
        if (tag.contains("scute_cooldown", 3)) {
            this.animalPen$scuteCooldown = tag.getInt("scute_cooldown");
        }
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenInteract(Player player, InteractionHand hand, BlockPos position) {
        if (super.animalPen$animalPenInteract(player, hand, position)) {
            return true;
        }
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(Items.BRUSH)) {
            if (this.animalPen$scuteCooldown > 0) {
                return false;
            }
            if (player.level().isClientSide()) {
                return true;
            }
            itemStack.hurtAndBreak(16, (LivingEntity)player, AnimalPenArmadillo.getSlotForHand((InteractionHand)hand));
            Block.popResource((Level)player.level(), (BlockPos)position.above(), (ItemStack)new ItemStack((ItemLike)Items.ARMADILLO_SCUTE));
            player.level().playSound(null, position, SoundEvents.ARMADILLO_SCUTE_DROP, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$scuteCooldown = AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.getType(), Items.BRUSH, this.animalPen$animalCount);
            return true;
        }
        return false;
    }

    @Override
    @Intrinsic
    public List<Pair<ItemStack, Component>> animalPen$animalPenGetLines(int tick) {
        List<Pair<ItemStack, Component>> lines = super.animalPen$animalPenGetLines(tick);
        if (AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.getType(), Items.BRUSH, this.animalPen$animalCount) == 0) {
            return lines;
        }
        MutableComponent component = this.animalPen$scuteCooldown == 0 ? Component.translatable((String)"display.animal_pen.brush_ready").withStyle(ChatFormatting.GREEN) : Component.translatable((String)"display.animal_pen.brush_cooldown", (Object[])new Object[]{LocalTime.of(0, 0, 0).plusSeconds(this.animalPen$scuteCooldown / 20).format(AnimalPen.DATE_FORMATTER)});
        lines.add((Pair<ItemStack, Component>)Pair.of((Object)Items.ARMADILLO_SCUTE.getDefaultInstance(), (Object)component));
        return lines;
    }
}

