/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.registries;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import lv.id.bonne.animalpen.blocks.AnimalPenBlock;
import lv.id.bonne.animalpen.blocks.AquariumBlock;
import lv.id.bonne.animalpen.registries.AnimalPensCreativeTabRegistry;
import lv.id.bonne.animalpen.registries.AnimalPensItemRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;

public class AnimalPenBlockRegistry {
    public static final DeferredRegister<Block> REGISTRY = DeferredRegister.create((String)"animal_pen", (ResourceKey)Registries.BLOCK);
    public static final Map<WoodType, RegistrySupplier<Block>> ANIMAL_PENS = new HashMap<WoodType, RegistrySupplier<Block>>();
    public static final RegistrySupplier<Block> AQUARIUM = AnimalPenBlockRegistry.registerBlock("aquarium_block", () -> new AquariumBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LOOM).strength(1.0f).sound(SoundType.GLASS).noOcclusion().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"animal_pen", (String)"aquarium_block")))));

    public static void register() {
        REGISTRY.register();
    }

    private static <T extends Block> RegistrySupplier<T> registerBlock(String name, Supplier<T> block) {
        RegistrySupplier toReturn = REGISTRY.register(name, block);
        AnimalPenBlockRegistry.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistrySupplier<Item> registerBlockItem(String name, RegistrySupplier<T> block) {
        return AnimalPensItemRegistry.REGISTRY.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().arch$tab(AnimalPensCreativeTabRegistry.ANIMAL_PEN_TAB).setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"animal_pen", (String)name)))));
    }

    static {
        WoodType.values().forEach(woodType -> {
            String woodName = woodType.name().contains(":") ? woodType.name().toLowerCase().replaceAll(":", "_") : woodType.name().toLowerCase();
            RegistrySupplier<Block> block = AnimalPenBlockRegistry.registerBlock("animal_pen_" + woodName, () -> new AnimalPenBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LOOM).strength(1.0f).sound(SoundType.WOOD).noOcclusion().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"animal_pen", (String)("animal_pen_" + woodName))))));
            ANIMAL_PENS.put((WoodType)woodType, block);
        });
    }
}

