/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.listeners;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.platform.Platform;
import java.util.Map;
import java.util.Optional;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.listeners.TaggableIngredient;
import lv.id.bonne.animalpen.registries.AnimalPenFoodRegistry;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class AnimalFoodReloadListener
extends SimpleJsonResourceReloadListener<AnimalFoodEntry> {
    public static final Codec<AnimalFoodEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("condition").forGetter(AnimalFoodEntry::condition), (App)TaggableIngredient.CODEC.fieldOf("food_items").forGetter(AnimalFoodEntry::ingredient)).apply((Applicative)instance, AnimalFoodEntry::new));
    private static final String FOLDER = "animal_foods";

    public AnimalFoodReloadListener() {
        super(CODEC, FileToIdConverter.json((String)FOLDER));
    }

    protected void apply(Map<ResourceLocation, AnimalFoodEntry> objectMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        AnimalPenFoodRegistry.clear();
        objectMap.forEach((id, entry) -> {
            String modId;
            String condition;
            if (entry.condition().isPresent() && (condition = entry.condition().get()).startsWith("mod:") && !(modId = condition.substring(4)).isBlank() && !Platform.isModLoaded((String)modId)) {
                return;
            }
            if (!entry.ingredient().isEmpty()) {
                AnimalPenFoodRegistry.AnimalFoodData data = new AnimalPenFoodRegistry.AnimalFoodData(entry.ingredient());
                AnimalPenFoodRegistry.register(id, data);
            }
        });
        AnimalPen.LOGGER.info("Loaded " + AnimalPenFoodRegistry.getAll().size() + " animal food entries.");
    }

    public record AnimalFoodEntry(Optional<String> condition, TaggableIngredient ingredient) {
    }
}

