/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.animal;

import java.time.LocalTime;
import java.util.List;
import java.util.Optional;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.mixin.animal.AnimalPenAnimal;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={MushroomCow.class})
public abstract class AnimalPenMushroomCow
extends AnimalPenAnimal {
    @Shadow
    @Nullable
    private SuspiciousStewEffects stewEffects;
    @Unique
    private int animalPen$supCooldown;

    protected AnimalPenMushroomCow(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract MushroomCow.Variant getVariant();

    @Shadow
    protected abstract Optional<SuspiciousStewEffects> getEffectsFromItemStack(ItemStack var1);

    @Override
    @Intrinsic
    public boolean animalPen$animalPenTick(BlockEntity blockEntity) {
        boolean value = super.animalPen$animalPenTick(blockEntity);
        if (this.animalPen$supCooldown > 0) {
            --this.animalPen$supCooldown;
            return true;
        }
        return value;
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenSaveTag(ValueOutput tag) {
        super.animalPen$animalPenSaveTag(tag);
        tag.putInt("sup_cooldown", this.animalPen$supCooldown);
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenLoadTag(ValueInput tag) {
        super.animalPen$animalPenLoadTag(tag);
        this.animalPen$supCooldown = tag.getIntOr("sup_cooldown", 0);
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenInteract(Player player, InteractionHand hand, BlockPos position) {
        if (super.animalPen$animalPenInteract(player, hand, position)) {
            return true;
        }
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(Items.BOWL)) {
            ItemStack bowlStack;
            boolean suspicious;
            if (this.animalPen$supCooldown > 0) {
                return false;
            }
            if (player.level().isClientSide()) {
                return true;
            }
            boolean bl = suspicious = this.stewEffects != null;
            if (suspicious) {
                bowlStack = new ItemStack((ItemLike)Items.SUSPICIOUS_STEW);
                bowlStack.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, (Object)this.stewEffects);
                this.stewEffects = null;
            } else {
                bowlStack = new ItemStack((ItemLike)Items.MUSHROOM_STEW);
            }
            ItemStack remainingStack = ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)bowlStack, (boolean)false);
            player.setItemInHand(hand, remainingStack);
            SoundEvent soundEvent = suspicious ? SoundEvents.MOOSHROOM_MILK_SUSPICIOUSLY : SoundEvents.MOOSHROOM_MILK;
            player.level().playSound(null, position, soundEvent, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$supCooldown = AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.getType(), Items.BOWL, this.animalPen$animalCount);
            return true;
        }
        if (itemStack.is(ItemTags.SMALL_FLOWERS) && this.getVariant() == MushroomCow.Variant.BROWN) {
            if (this.stewEffects != null) {
                Level suspicious = player.level();
                if (suspicious instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)suspicious;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)((float)position.getX() + 0.5f), (double)position.getY() + 1.5, (double)((float)position.getZ() + 0.5f), 2, 0.2, 0.2, 0.2, 0.05);
                }
            } else {
                ServerLevel serverLevel;
                Optional<SuspiciousStewEffects> optional = this.getEffectsFromItemStack(itemStack);
                if (optional.isEmpty()) {
                    return false;
                }
                if (player.level().isClientSide()) {
                    return true;
                }
                Level level = player.level();
                if (level instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.EFFECT, (double)((float)position.getX() + 0.5f), (double)position.getY() + 1.5, (double)((float)position.getZ() + 0.5f), 4, 0.2, 0.2, 0.2, 0.05);
                }
                if (!player.getAbilities().instabuild) {
                    itemStack.shrink(1);
                    player.setItemInHand(hand, itemStack);
                }
                this.stewEffects = optional.get();
                level = player.level();
                if (level instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level;
                    serverLevel.playSound(null, position, SoundEvents.MOOSHROOM_EAT, SoundSource.NEUTRAL, 2.0f, 1.0f);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    @Intrinsic
    public ItemStack animalPen$animalPenInteract(ServerLevel level, ItemStack itemStack, BlockPos position) {
        if (itemStack.is(Items.BOWL)) {
            ItemStack bowlStack;
            boolean suspicious;
            if (this.animalPen$supCooldown > 0) {
                return ItemStack.EMPTY;
            }
            boolean bl = suspicious = this.stewEffects != null;
            if (suspicious) {
                bowlStack = new ItemStack((ItemLike)Items.SUSPICIOUS_STEW);
                bowlStack.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, (Object)this.stewEffects);
                this.stewEffects = null;
            } else {
                bowlStack = new ItemStack((ItemLike)Items.MUSHROOM_STEW);
            }
            SoundEvent soundEvent = suspicious ? SoundEvents.MOOSHROOM_MILK_SUSPICIOUSLY : SoundEvents.MOOSHROOM_MILK;
            level.playSound(null, position, soundEvent, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$supCooldown = AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.getType(), Items.BOWL, this.animalPen$animalCount);
            return bowlStack;
        }
        return super.animalPen$animalPenInteract(level, itemStack, position);
    }

    @Override
    @Intrinsic
    public List<Pair<ItemStack[], Component>> animalPen$animalPenGetLines(int tick, boolean shortLine) {
        List<Pair<ItemStack[], Component>> lines = super.animalPen$animalPenGetLines(tick, shortLine);
        if (shortLine && AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.getType(), Items.BOWL, this.animalPen$animalCount) == 0) {
            return lines;
        }
        MutableComponent component = this.animalPen$supCooldown == 0 ? Component.translatable((String)(shortLine ? "display.animal_pen.ready" : "display.animal_pen.full_ready"), (Object[])new Object[]{Component.literal((String)"\ue000"), Component.literal((String)"\ue001")}).withStyle(ChatFormatting.GREEN) : Component.translatable((String)(shortLine ? "display.animal_pen.cooldown" : "display.animal_pen.soup_cooldown"), (Object[])new Object[]{Component.literal((String)"\ue000"), Component.literal((String)"\ue001"), LocalTime.of(0, 0, 0).plusSeconds(this.animalPen$supCooldown / 20).format(AnimalPen.DATE_FORMATTER)});
        ItemStack itemStack = this.stewEffects == null ? Items.MUSHROOM_STEW.getDefaultInstance() : Items.SUSPICIOUS_STEW.getDefaultInstance();
        lines.add((Pair<ItemStack[], Component>)Pair.of((Object)new ItemStack[]{Items.BOWL.getDefaultInstance(), itemStack}, (Object)component));
        return lines;
    }

    @Override
    @Intrinsic
    public int animalPen$getRedStoneSignal() {
        if (this.animalPen$supCooldown > 0) {
            return super.animalPen$getRedStoneSignal();
        }
        return super.animalPen$getRedStoneSignal() | 8;
    }
}

