/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.network.packets;

import dev.architectury.networking.NetworkManager;
import java.util.HashMap;
import java.util.Map;
import lv.id.bonne.animalpen.registries.AnimalPenFoodRegistry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public record AnimalFoodRegistryData(Map<ResourceLocation, AnimalPenFoodRegistry.AnimalFoodData> data) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AnimalFoodRegistryData> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"animal_pen", (String)"animal_food_registry_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, AnimalFoodRegistryData> STREAM_CODEC = StreamCodec.of((buf, registryData) -> {
        Map<ResourceLocation, AnimalPenFoodRegistry.AnimalFoodData> map = registryData.data();
        buf.writeVarInt(map.size());
        for (Map.Entry<ResourceLocation, AnimalPenFoodRegistry.AnimalFoodData> entry : map.entrySet()) {
            ResourceLocation.STREAM_CODEC.encode(buf, (Object)entry.getKey());
            AnimalPenFoodRegistry.AnimalFoodData.STREAM_CODEC.encode(buf, (Object)entry.getValue());
        }
    }, buf -> {
        int size = buf.readVarInt();
        HashMap<ResourceLocation, AnimalPenFoodRegistry.AnimalFoodData> map = new HashMap<ResourceLocation, AnimalPenFoodRegistry.AnimalFoodData>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation key = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode(buf);
            AnimalPenFoodRegistry.AnimalFoodData value = (AnimalPenFoodRegistry.AnimalFoodData)AnimalPenFoodRegistry.AnimalFoodData.STREAM_CODEC.decode(buf);
            map.put(key, value);
        }
        return new AnimalFoodRegistryData(map);
    });

    public static void handle(AnimalFoodRegistryData data, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> AnimalPenFoodRegistry.setSyncedData(data.data()));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

