/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.network.packets;

import dev.architectury.networking.NetworkManager;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.entities.AnimalPenBlockInterface;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public record RemoveDisplayAnimalData(BlockPos position, int index) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RemoveDisplayAnimalData> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"animal_pen", (String)"remove_display_animal"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RemoveDisplayAnimalData> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, RemoveDisplayAnimalData::position, (StreamCodec)ByteBufCodecs.INT, RemoveDisplayAnimalData::index, RemoveDisplayAnimalData::new);

    public static void handle(RemoveDisplayAnimalData data, NetworkManager.PacketContext packetContext) {
        BlockPos blockPos = data.position();
        int index = data.index();
        packetContext.queue(() -> {
            Level level = packetContext.getPlayer().level();
            BlockEntity patt0$temp = level.getBlockEntity(blockPos);
            if (patt0$temp instanceof AnimalPenBlockInterface) {
                AnimalPenBlockInterface animalPen = (AnimalPenBlockInterface)patt0$temp;
                animalPen.removeAnimalVariant(index);
            } else {
                AnimalPen.LOGGER.error("Block entity not found at the position!");
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

