/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.network.packets;

import dev.architectury.networking.NetworkManager;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.entities.AnimalPenBlockInterface;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public record UpdateAnimalSizeData(BlockPos position, long size) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateAnimalSizeData> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"animal_pen", (String)"update_animal_size"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateAnimalSizeData> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, UpdateAnimalSizeData::position, (StreamCodec)ByteBufCodecs.VAR_LONG, UpdateAnimalSizeData::size, UpdateAnimalSizeData::new);

    public static void handle(UpdateAnimalSizeData data, NetworkManager.PacketContext packetContext) {
        BlockPos blockPos = data.position();
        long size = data.size();
        packetContext.queue(() -> {
            Level level = packetContext.getPlayer().level();
            BlockEntity patt0$temp = level.getBlockEntity(blockPos);
            if (patt0$temp instanceof AnimalPenBlockInterface) {
                AnimalPenBlockInterface animalPen = (AnimalPenBlockInterface)patt0$temp;
                animalPen.setAnimalDisplaySize(size);
            } else {
                AnimalPen.LOGGER.error("Block entity not found at the position!");
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

