/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.blocks.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Objects;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.AnimalPenBlock;
import lv.id.bonne.animalpen.blocks.entities.AnimalPenTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class AnimalPenRenderer
implements BlockEntityRenderer<AnimalPenTileEntity> {
    private final Minecraft minecraft = Minecraft.getInstance();
    private final Font font;
    private Animal dyingAnimal;

    public AnimalPenRenderer() {
        this.font = this.minecraft.font;
    }

    public void render(AnimalPenTileEntity tileEntity, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Animal animal = tileEntity.getStoredAnimal();
        if (animal == null) {
            return;
        }
        if (this.dyingAnimal == null || this.dyingAnimal.getType() != animal.getType()) {
            this.dyingAnimal = null;
            CompoundTag cloneTag = new CompoundTag();
            animal.save(cloneTag);
            EntityType.create((CompoundTag)cloneTag, (Level)tileEntity.getLevel()).map(entity -> (Animal)entity).ifPresent(clone -> {
                this.dyingAnimal = clone;
                this.dyingAnimal.setPose(Pose.DYING);
                this.dyingAnimal.yBodyRot = 0.0f;
                this.dyingAnimal.setYRot(0.0f);
                this.dyingAnimal.yHeadRot = 0.0f;
                this.dyingAnimal.yHeadRotO = 0.0f;
                this.dyingAnimal.tickCount = 0;
                this.dyingAnimal.deathTime = 0;
            });
        }
        Direction facing = (Direction)tileEntity.getBlockState().getValue((Property)AnimalPenBlock.FACING);
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        switch (facing) {
            case SOUTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case EAST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
            }
        }
        poseStack.translate(0.0f, 0.0f, 0.0f);
        this.renderAnimal(animal, tileEntity, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        this.renderCounter(animal, tileEntity, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        if (this.minecraft.player != null && this.minecraft.player.isCrouching()) {
            this.renderTextLines(animal, tileEntity, partialTicks, poseStack, buffer, combinedLight, combinedOverlay);
        }
        poseStack.popPose();
    }

    private void renderAnimal(Animal animal, AnimalPenTileEntity tileEntity, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        animal.yBodyRot = 0.0f;
        animal.setYRot(0.0f);
        animal.yHeadRot = 0.0f;
        animal.yHeadRotO = 0.0f;
        animal.tickCount = tileEntity.getTickCounter();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.25f, 0.0f);
        float animalSize = AnimalPen.CONFIG_MANAGER.getConfiguration().getAnimalSize();
        poseStack.scale(animalSize, animalSize, animalSize);
        if (AnimalPen.CONFIG_MANAGER.getConfiguration().isGrowAnimals()) {
            float scale = 1.0f + animalSize * (float)tileEntity.getAnimalDisplaySize() * AnimalPen.CONFIG_MANAGER.getConfiguration().getGrowthMultiplier().floatValue();
            poseStack.scale(scale, scale, scale);
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        this.minecraft.getEntityRenderDispatcher().getRenderer((Entity)animal).render((Entity)animal, 0.0f, partialTicks, poseStack, buffer, combinedLight);
        CompoundTag cloneTag = new CompoundTag();
        animal.save(cloneTag);
        tileEntity.getDeathTicker().forEach(tick -> {
            if (this.dyingAnimal != null) {
                this.dyingAnimal.deathTime = tick;
                this.minecraft.getEntityRenderDispatcher().getRenderer((Entity)this.dyingAnimal).render((Entity)this.dyingAnimal, 0.0f, partialTicks, poseStack, buffer, combinedLight);
            }
        });
        poseStack.popPose();
    }

    private void renderCounter(Animal animal, AnimalPenTileEntity tileEntity, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        long count = tileEntity.getAnimalCount();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.125f, -0.51f);
        MutableComponent text = Component.translatable((String)"display.animal_pen.count", (Object[])new Object[]{count});
        int textWidth = this.font.width((FormattedText)text);
        float maxWidth = 30.0f;
        float scale = Math.min(1.0f, maxWidth / (float)textWidth) * 0.015f;
        poseStack.scale(-scale, -scale, 0.0f);
        double d = (double)(-textWidth) / 2.0;
        Objects.requireNonNull(this.font);
        poseStack.translate(d, (double)((float)(-9) / 2.0f), 0.0);
        this.font.drawInBatch((Component)text, 0.0f, 0.0f, 0xFFFFFF, false, poseStack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, combinedLight);
        poseStack.popPose();
    }

    private void renderTextLines(Animal animal, AnimalPenTileEntity tileEntity, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Direction facing;
        Vec3 facingVec;
        List<Pair<ItemStack, Component>> textList = tileEntity.getCooldownLines();
        if (textList.isEmpty()) {
            return;
        }
        BlockPos blockPos = tileEntity.getBlockPos();
        Vec3 playerPos = this.minecraft.player.position();
        Vec3 toPlayer = new Vec3(playerPos.x() - (double)blockPos.getX(), 0.0, playerPos.z() - (double)blockPos.getZ());
        if (toPlayer.dot(facingVec = Vec3.atLowerCornerOf((Vec3i)(facing = (Direction)tileEntity.getBlockState().getValue((Property)AnimalPenBlock.FACING)).getNormal())) < 0.0) {
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        }
        double totalHeight = 1.5 + 0.125 * (double)(textList.size() - 1);
        double maxWidth = 0.0;
        for (Pair<ItemStack, Component> pair : textList) {
            maxWidth = Math.max(0, this.font.width((FormattedText)pair.getRight()));
        }
        maxWidth += 4.0;
        poseStack.pushPose();
        poseStack.translate(0.0, totalHeight, 0.0);
        for (int i = 0; i < textList.size(); ++i) {
            poseStack.pushPose();
            poseStack.translate(0.0, -0.125 * (double)i, 0.0);
            poseStack.pushPose();
            poseStack.scale(-0.0125f, -0.0125f, -0.0125f);
            poseStack.translate(-maxWidth / 2.0, -6.0, 0.0);
            this.font.drawInBatch((Component)textList.get(i).getRight(), 8.0f, 0.0f, 0xFFFFFF, false, poseStack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, combinedLight);
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.scale(0.25f, 0.25f, 0.25f);
            poseStack.translate(maxWidth / 2.0 * 0.05, 0.0, 0.0);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            this.minecraft.getItemRenderer().renderStatic((ItemStack)textList.get(i).getLeft(), ItemDisplayContext.GROUND, combinedLight, combinedOverlay, poseStack, buffer, tileEntity.getLevel(), 0);
            poseStack.popPose();
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    public boolean shouldRenderOffScreen(AnimalPenTileEntity blockEntity) {
        return !blockEntity.getInventory().isEmpty() && AnimalPen.CONFIG_MANAGER.getConfiguration().isGrowAnimals();
    }

    public boolean shouldRender(AnimalPenTileEntity blockEntity, Vec3 vec3) {
        return AnimalPen.CONFIG_MANAGER.getConfiguration().isGrowAnimals() || super.shouldRender((BlockEntity)blockEntity, vec3);
    }
}

