/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lv.id.bonne.animalpen.blocks.entities.AnimalPenBlockInterface;
import lv.id.bonne.animalpen.mixin.accessors.EntityAccessor;
import lv.id.bonne.animalpen.network.packets.RemoveDisplayAnimalData;
import lv.id.bonne.animalpen.network.packets.UpdateAnimalSizeData;
import lv.id.bonne.animalpen.network.packets.UpdateDisplayAnimalData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class VariantScreenSelection
extends Screen {
    private final BlockPos position;
    private final int imageWidth;
    private final int cooldownWidth;
    private final int imageHeight;
    private final List<Button> buttons = new ArrayList<Button>();
    private final int buttonAreaHeight = 106;
    private final int sliderAreaWidth = 64;
    private AnimalPenBlockInterface<?> blockEntityInterface;
    private int leftPos;
    private int topPos;
    private int bodyTopPos;
    private int sliderBarPos;
    private float currentVariantScroll;
    private boolean isScrollingVariants;
    private boolean isCooldownOpened;
    private int selectedButton = -1;
    private Button deleteButton;
    private Button applyButton;
    private Button sliderButton;
    private Button cooldownButton;
    private LivingEntity displayEntity;
    private float entityScale;
    private float entityOffset;
    private float entityRotation = -45.0f;
    private int currentXOnEntity;
    private boolean isSelectingEntity;
    private boolean isSelectingSizeBar;
    private static final Component TITLE = Component.translatable((String)"gui.animal_pen.variant_selection_screen");
    private static final Component APPLY = Component.translatable((String)"gui.animal_pen.variant_selection_screen.apply_tooltip");
    private static final Component DELETE = Component.translatable((String)"gui.animal_pen.variant_selection_screen.delete_tooltip");
    private static final Component SELECT_TO_DELETE = Component.translatable((String)"gui.animal_pen.variant_selection_screen.select_to_delete_tooltip");
    private static final Component COOLDOWN_OPEN = Component.translatable((String)"gui.animal_pen.variant_selection_screen.cooldown_open_tooltip");
    private static final Component COOLDOWN_CLOSE = Component.translatable((String)"gui.animal_pen.variant_selection_screen.cooldown_close_tooltip");
    private static final Component SLIDER = Component.translatable((String)"gui.animal_pen.variant_selection_screen.slider_tooltip");
    private static final Component SLIDER_HELPER_DRAG = Component.translatable((String)"gui.animal_pen.variant_selection_screen.slider_tooltip_drag");
    private static final Component SLIDER_HELPER_ARROW = Component.translatable((String)"gui.animal_pen.variant_selection_screen.slider_tooltip_arrow");
    private static final String BUTTON_TEXT = "gui.animal_pen.variant_selection_screen.select_variant";
    private static final String SIZE_TEXT = "gui.animal_pen.variant_selection_screen.entity_size";
    private static final String FIXED_TEXT = "gui.animal_pen.variant_selection_screen.fixed_size";
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"animal_pen", (String)"textures/gui/animal_selection.png");
    private static final ResourceLocation COOLDOWN_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"animal_pen", (String)"textures/gui/cooldown_area.png");

    public VariantScreenSelection(BlockPos position) {
        super(TITLE);
        this.position = position;
        this.imageWidth = 176;
        this.imageHeight = 136;
        this.cooldownWidth = 149;
    }

    protected void init() {
        super.init();
        this.clearWidgets();
        this.leftPos = this.isCooldownOpened ? (this.width - this.imageWidth + this.cooldownWidth) / 2 : (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.buttons.clear();
        this.bodyTopPos = this.topPos + 18;
        int buttonPos = this.leftPos + 24;
        int buttonWidth = 46;
        int buttonHeight = 20;
        if (this.minecraft == null || this.minecraft.level == null) {
            return;
        }
        BlockEntity blockEntity = this.minecraft.level.getBlockEntity(this.position);
        if (!(blockEntity instanceof AnimalPenBlockInterface)) {
            return;
        }
        AnimalPenBlockInterface animalPenEntity = (AnimalPenBlockInterface)blockEntity;
        this.blockEntityInterface = animalPenEntity;
        ListTag entityList = this.blockEntityInterface.getEntityVariants();
        if (entityList == null) {
            entityList = new ListTag();
        }
        int i = 0;
        while (i < entityList.size()) {
            int y = this.bodyTopPos + i * buttonHeight;
            int index = i++;
            this.buttons.add((Button)this.addWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)BUTTON_TEXT, (Object[])new Object[]{index + 1}), button -> this.handleVariantButton(button, index)).pos(buttonPos, y).size(buttonWidth, buttonHeight).build()));
        }
        this.deleteButton = (Button)this.addWidget((GuiEventListener)Button.builder((Component)Component.empty(), this::handleDeleteButton).pos(this.leftPos + 157, this.topPos + 111).size(11, 14).build());
        this.applyButton = (Button)this.addWidget((GuiEventListener)Button.builder((Component)Component.empty(), this::handleApplyButton).pos(this.leftPos + 73, this.topPos + 111).size(14, 14).build());
        this.applyButton.active = false;
        long currentValue = this.blockEntityInterface.getAnimalDisplaySize();
        long maxValue = this.blockEntityInterface.getAnimalCount();
        if (currentValue < 1L) {
            currentValue = 1L;
        }
        if (currentValue > maxValue && maxValue != 0L) {
            currentValue = maxValue;
        }
        this.sliderBarPos = this.leftPos + 89;
        Button.Builder builder = Button.builder((Component)Component.empty(), button -> {}).pos(this.sliderBarPos, this.topPos + 112);
        Objects.requireNonNull(this);
        this.sliderButton = (Button)this.addWidget((GuiEventListener)builder.size(Math.max(6, (int)(64L / maxValue)), 12).build());
        this.sliderButton.active = maxValue > 1L;
        this.sliderButton.visible = this.blockEntityInterface.canGrowEntity() && maxValue > 1L;
        int initialX = this.calculateSizeBarOffset(currentValue);
        this.sliderButton.setX(this.sliderBarPos + initialX);
        CompoundTag defaultAnimal = new CompoundTag();
        this.blockEntityInterface.getStoredAnimal().save(defaultAnimal);
        EntityType.create((CompoundTag)defaultAnimal, (Level)this.minecraft.level).map(entity -> (LivingEntity)entity).ifPresent(entity -> {
            this.displayEntity = entity;
            float width = this.displayEntity.getBbWidth();
            float height = this.displayEntity.getBbHeight();
            float entitySize = Math.max(1.0f, Math.max(width, height));
            this.entityScale = 60.0f / entitySize * 0.8f;
            this.entityOffset = Math.max(height, entitySize) * 0.5f;
        });
        this.cooldownButton = (Button)this.addWidget((GuiEventListener)Button.builder((Component)Component.empty(), this::handleCooldownButton).pos(this.leftPos - 12, this.topPos + (this.imageHeight - 18) / 2).size(11, 18).build());
    }

    public void tick() {
        super.tick();
        if (this.displayEntity != null) {
            ++this.displayEntity.tickCount;
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    private int calculateSizeBarOffset(long value) {
        if (this.blockEntityInterface.getAnimalCount() <= 1L) {
            return 0;
        }
        float percentage = (float)(value - 1L) / (float)(this.blockEntityInterface.getAnimalCount() - 1L);
        return Math.round(percentage * (float)(this.sliderAreaWidth - this.sliderButton.getWidth()));
    }

    private long calculateSizeFromPosition(int scrollX) {
        float percentage = (float)(scrollX - this.sliderBarPos) / (float)(this.sliderAreaWidth - this.sliderButton.getWidth());
        long maxValue = this.blockEntityInterface.getAnimalCount();
        return 1 + Math.round(percentage * (float)(maxValue - 1L));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        this.updateButtonPositions();
        super.render(graphics, mouseX, mouseY, partialTicks);
        int n = this.leftPos + 88 - this.font.width((FormattedText)this.title) / 2;
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, this.title, n, this.topPos + 3 + 7 - 9 / 2, 0x404040, false);
        this.renderVariantButtons(graphics, mouseX, mouseY, partialTicks);
        this.renderOtherButtons(graphics, mouseX, mouseY);
        this.renderScrollBar(graphics, mouseX, mouseY);
        this.renderSizeBar(graphics, mouseX, mouseY, partialTicks);
        this.renderEntity(graphics, partialTicks);
        this.renderCooldown(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltips(graphics, mouseX, mouseY, partialTicks);
    }

    public void renderMenuBackground(GuiGraphics graphics) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int offsetX = this.leftPos;
        int offsetY = this.topPos;
        graphics.blit(TEXTURE, offsetX, offsetY, 0, 0, this.imageWidth, this.imageHeight);
    }

    private void renderVariantButtons(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.enableScissor(10, this.bodyTopPos, this.width - 10, this.bodyTopPos + this.buttonAreaHeight);
        for (int i = 0; i < this.buttons.size(); ++i) {
            Button button = this.buttons.get(i);
            button.render(graphics, mouseX, mouseY, partialTicks);
            if (i != this.selectedButton) continue;
            this.renderButtonBorder(graphics, button, -2147418368);
        }
        graphics.disableScissor();
    }

    private void renderButtonBorder(GuiGraphics graphics, Button button, int color) {
        int width = button.getWidth();
        int height = button.getHeight();
        graphics.fill(button.getX(), button.getY(), button.getX() + width, button.getY() + 1, color);
        graphics.fill(button.getX(), button.getY() + height - 1, button.getX() + width, button.getY() + height, color);
        graphics.fill(button.getX(), button.getY(), button.getX() + 1, button.getY() + height, color);
        graphics.fill(button.getX() + width - 1, button.getY(), button.getX() + width, button.getY() + height, color);
    }

    private void renderOtherButtons(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.blit(TEXTURE, this.deleteButton.getX() + 1, this.deleteButton.getY() + 1, 176 + (this.selectedButton != -1 ? 0 : 9), 39, 9, 12);
        graphics.blit(TEXTURE, this.applyButton.getX() + 1, this.applyButton.getY() + 1, 176 + (this.selectedButton != -1 ? 0 : 12), 51, 12, 12);
    }

    private void renderScrollBar(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        int scrollThumbHeight = 15;
        int scrollPosition = this.needsScrollBars() ? this.bodyTopPos + (int)((float)(this.buttonAreaHeight - scrollThumbHeight) * this.currentVariantScroll) : this.bodyTopPos;
        graphics.blit(TEXTURE, this.leftPos + 9, scrollPosition, 176 + (this.needsScrollBars() ? 0 : 12), 0, 12, scrollThumbHeight);
    }

    private void renderSizeBar(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int n;
        this.sliderButton.render(graphics, mouseX, mouseY, partialTicks);
        MutableComponent text = this.blockEntityInterface.canGrowEntity() ? Component.translatable((String)SIZE_TEXT, (Object[])new Object[]{this.blockEntityInterface.getAnimalDisplaySize(), this.blockEntityInterface.getAnimalCount()}) : Component.translatable((String)FIXED_TEXT, (Object[])new Object[]{this.blockEntityInterface.getAnimalDisplaySize()});
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        float textWidth = this.font.width((FormattedText)text);
        Objects.requireNonNull(this);
        float scale = Math.min(1.0f, 64.0f / textWidth);
        float f = this.sliderBarPos;
        float f2 = this.topPos + 112 + 7;
        Objects.requireNonNull(this.font);
        poseStack.translate(f, f2 - 9.0f * scale / 2.0f, 0.0f);
        poseStack.scale(scale, scale, 1.0f);
        if (scale < 1.0f) {
            n = 0;
        } else {
            Objects.requireNonNull(this);
            n = (int)(64.0f - textWidth) / 2;
        }
        graphics.drawString(this.font, (Component)text, n, 0, 0xFFFFFF);
        poseStack.popPose();
    }

    private void renderEntity(@NotNull GuiGraphics graphics, float partialTicks) {
        float x = this.leftPos + 73 + 48;
        float y = this.bodyTopPos + 46;
        this.displayEntity.yBodyRot = 0.0f;
        this.displayEntity.setYRot(0.0f);
        this.displayEntity.yHeadRot = 0.0f;
        this.displayEntity.yHeadRotO = 0.0f;
        LivingEntity livingEntity = this.displayEntity;
        if (livingEntity instanceof WaterAnimal) {
            WaterAnimal animal = (WaterAnimal)livingEntity;
            animal.setPose(Pose.SWIMMING);
            animal.setSwimming(true);
            ((EntityAccessor)animal).setWasTouchingWater(true);
            y -= 10.0f;
        }
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate(x, y, 50.0f);
        poseStack.scale(this.entityScale, this.entityScale, this.entityScale);
        poseStack.translate(0.0f, this.entityOffset, 0.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(this.entityRotation));
        EntityRenderDispatcher erd = Minecraft.getInstance().getEntityRenderDispatcher();
        MultiBufferSource.BufferSource immediate = Minecraft.getInstance().renderBuffers().bufferSource();
        erd.setRenderShadow(false);
        erd.render((Entity)this.displayEntity, 0.0, 0.0, 0.0, 0.0f, partialTicks, poseStack, (MultiBufferSource)immediate, 0xF000F0);
        erd.setRenderShadow(true);
        immediate.endBatch();
        poseStack.popPose();
    }

    private void renderCooldown(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)COOLDOWN_TEXTURE);
        graphics.blit(COOLDOWN_TEXTURE, this.leftPos - 12, this.topPos + (this.imageHeight - 18) / 2, 149 + (this.isCooldownOpened ? 0 : 11), this.cooldownButton.isMouseOver((double)mouseX, (double)mouseY) ? 18 : 1, 11, 18);
        if (this.isCooldownOpened) {
            graphics.blit(COOLDOWN_TEXTURE, this.leftPos - 12 - this.cooldownWidth, this.topPos, 0, 1, this.cooldownWidth, this.imageHeight + 1);
            List<Pair<ItemStack, Component>> textList = this.blockEntityInterface.getCooldownLines();
            if (!textList.isEmpty()) {
                int leftOffset = this.leftPos - this.cooldownWidth;
                Objects.requireNonNull(this.font);
                int top = this.topPos + 9;
                for (int i = 0; i < textList.size(); ++i) {
                    Pair<ItemStack, Component> cooldown = textList.get(i);
                    int y = top + i * 16;
                    graphics.renderItem((ItemStack)cooldown.getLeft(), leftOffset, y);
                    Component component = (Component)cooldown.getRight();
                    Objects.requireNonNull(this.font);
                    graphics.drawString(this.font, component, leftOffset + 18, y + 9 / 2, 0xFFFFFF);
                    if (mouseX < leftOffset || mouseX > leftOffset + 16 || mouseY < y || mouseY > y + 16) continue;
                    graphics.renderTooltip(this.font, (ItemStack)cooldown.getLeft(), mouseX, mouseY);
                }
            }
        }
    }

    private void renderTooltips(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.applyButton.isMouseOver((double)mouseX, (double)mouseY)) {
            graphics.renderTooltip(this.font, APPLY, mouseX, mouseY);
        }
        if (this.deleteButton.isMouseOver((double)mouseX, (double)mouseY)) {
            graphics.renderTooltip(this.font, this.selectedButton != -1 ? DELETE : SELECT_TO_DELETE, mouseX, mouseY);
        }
        if (this.sliderButton.isMouseOver((double)mouseX, (double)mouseY)) {
            List<Component> list = List.of(SLIDER, Component.empty(), SLIDER_HELPER_DRAG, SLIDER_HELPER_ARROW);
            graphics.renderComponentTooltip(this.font, list, mouseX, mouseY);
        }
        if (this.cooldownButton.isMouseOver((double)mouseX, (double)mouseY)) {
            graphics.renderTooltip(this.font, this.isCooldownOpened ? COOLDOWN_CLOSE : COOLDOWN_OPEN, mouseX, mouseY);
        }
    }

    private boolean needsScrollBars() {
        return this.buttons.size() > 5;
    }

    private void handleDeleteButton(Button button) {
        if (this.selectedButton == -1) {
            return;
        }
        this.blockEntityInterface.removeAnimalVariant(this.selectedButton);
        NetworkManager.sendToServer((CustomPacketPayload)new RemoveDisplayAnimalData(this.position, this.selectedButton));
        this.selectedButton = -1;
        this.applyButton.active = false;
        this.init();
    }

    private void handleApplyButton(Button button) {
        NetworkManager.sendToServer((CustomPacketPayload)new UpdateDisplayAnimalData(this.position, this.blockEntityInterface.getEntityVariants().getCompound(this.selectedButton)));
        this.displayEntity.load(this.blockEntityInterface.getEntityVariants().getCompound(this.selectedButton));
        this.selectedButton = -1;
    }

    private void handleVariantButton(Button button, int index) {
        CompoundTag tag;
        if (button.getY() + button.getHeight() < this.bodyTopPos || button.getY() > this.bodyTopPos + this.buttonAreaHeight) {
            return;
        }
        if (this.selectedButton == index) {
            this.selectedButton = -1;
            this.applyButton.active = false;
        } else {
            this.selectedButton = index;
            boolean bl = this.applyButton.active = !this.buttons.isEmpty();
        }
        if (this.selectedButton != -1) {
            tag = (CompoundTag)this.blockEntityInterface.getEntityVariants().get(index);
        } else {
            tag = new CompoundTag();
            this.blockEntityInterface.getStoredAnimal().save(tag);
        }
        this.displayEntity.load(tag);
        this.currentXOnEntity = 0;
    }

    private void handleCooldownButton(Button button) {
        this.isCooldownOpened = !this.isCooldownOpened;
        this.init();
    }

    private boolean scrollBarClicked(double mouseX, double mouseY) {
        int scrollLeft = this.leftPos + 9;
        int scrollRight = scrollLeft + 12;
        int scrollBottom = this.bodyTopPos + this.buttonAreaHeight;
        return mouseX >= (double)scrollLeft && mouseY >= (double)this.bodyTopPos && mouseX < (double)scrollRight && mouseY < (double)scrollBottom;
    }

    private boolean entityAreaClicked(double mouseX, double mouseY) {
        int left = this.leftPos + 73;
        int top = this.bodyTopPos;
        int right = left + 96;
        int bottom = top + 92;
        return mouseX >= (double)left && mouseX < (double)right && mouseY >= (double)top && mouseY < (double)bottom;
    }

    private boolean sizeBarClicked(double mouseX, double mouseY) {
        return this.sliderButton.isMouseOver(mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.scrollBarClicked(mouseX, mouseY)) {
            this.isScrollingVariants = true;
            this.mouseDragged(mouseX, mouseY, button, 0.0, 0.0);
            return true;
        }
        if (this.entityAreaClicked(mouseX, mouseY)) {
            this.currentXOnEntity = (int)mouseX;
            this.isSelectingEntity = true;
            return true;
        }
        if (this.sizeBarClicked(mouseX, mouseY)) {
            this.isSelectingSizeBar = true;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isSelectingEntity = false;
        this.isScrollingVariants = false;
        this.isSelectingSizeBar = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double var, double amount) {
        if (!this.needsScrollBars()) {
            return false;
        }
        this.currentVariantScroll = (float)((double)this.currentVariantScroll - amount / 10.0);
        this.currentVariantScroll = Mth.clamp((float)this.currentVariantScroll, (float)0.0f, (float)1.0f);
        this.updateButtonPositions();
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrollingVariants && this.needsScrollBars()) {
            int scrollBottom = this.bodyTopPos + this.buttonAreaHeight;
            this.currentVariantScroll = ((float)mouseY - (float)this.bodyTopPos) / (float)(scrollBottom - this.bodyTopPos);
            this.currentVariantScroll = Mth.clamp((float)this.currentVariantScroll, (float)0.0f, (float)1.0f);
            this.updateButtonPositions();
            return true;
        }
        if (this.isSelectingEntity) {
            int deltaX = (int)mouseX - this.currentXOnEntity;
            this.entityRotation -= (float)deltaX;
            while (this.entityRotation < 0.0f) {
                this.entityRotation += 360.0f;
            }
            while (this.entityRotation >= 360.0f) {
                this.entityRotation -= 360.0f;
            }
            this.currentXOnEntity = (int)mouseX;
            return true;
        }
        if (this.isSelectingSizeBar && this.sliderButton.isActive() && this.blockEntityInterface.canGrowEntity()) {
            int newX = (int)Mth.clamp((double)mouseX, (double)this.sliderBarPos, (double)(this.sliderBarPos + this.sliderAreaWidth - this.sliderButton.getWidth()));
            long newValue = this.calculateSizeFromPosition(newX);
            this.blockEntityInterface.setAnimalDisplaySize(newValue);
            NetworkManager.sendToServer((CustomPacketPayload)new UpdateAnimalSizeData(this.position, newValue));
            int snapPoint = this.calculateSizeBarOffset(newValue);
            this.sliderButton.setX(this.sliderBarPos + snapPoint);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if ((keyCode == 263 || keyCode == 262) && this.sliderButton.isActive() && this.blockEntityInterface.canGrowEntity()) {
            long currentValue = this.blockEntityInterface.getAnimalDisplaySize();
            long maxValue = this.blockEntityInterface.getAnimalCount();
            long newValue = keyCode == 263 ? Math.max(1L, currentValue - 1L) : Math.min(maxValue, currentValue + 1L);
            if (newValue != currentValue) {
                this.sliderButton.setX(this.sliderBarPos + this.calculateSizeBarOffset(newValue));
                this.blockEntityInterface.setAnimalDisplaySize(newValue);
                NetworkManager.sendToServer((CustomPacketPayload)new UpdateAnimalSizeData(this.position, newValue));
                return true;
            }
        } else {
            if ((keyCode == 265 || keyCode == 264) && this.buttons.size() > 1) {
                int button = keyCode == 264 ? Math.min(this.selectedButton + 1, this.buttons.size() - 1) : Math.max(this.selectedButton - 1, 0);
                if (button != this.selectedButton) {
                    this.ensureButtonVisible(button);
                    this.handleVariantButton(this.buttons.get(button), button);
                }
                return true;
            }
            if (keyCode == 257) {
                if (this.selectedButton >= 0 && this.selectedButton < this.buttons.size() && this.applyButton.isActive()) {
                    this.handleApplyButton(null);
                    return true;
                }
            } else if (keyCode == 261 && this.selectedButton >= 0 && this.selectedButton < this.buttons.size()) {
                this.handleDeleteButton(null);
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    private void updateButtonPositions() {
        int buttonHeight = 20;
        int totalButtonsHeight = this.buttons.size() * buttonHeight;
        int maxScrollPixels = Math.max(0, totalButtonsHeight - this.buttonAreaHeight);
        int scrollOffset = (int)((float)maxScrollPixels * this.currentVariantScroll);
        for (int i = 0; i < this.buttons.size(); ++i) {
            Button button = this.buttons.get(i);
            button.setY(this.bodyTopPos + i * buttonHeight - scrollOffset);
        }
    }

    private void ensureButtonVisible(int buttonIndex) {
        if (buttonIndex < 0 || buttonIndex >= this.buttons.size()) {
            return;
        }
        Button targetButton = this.buttons.get(buttonIndex);
        int buttonTop = targetButton.getY();
        int buttonBottom = buttonTop + targetButton.getHeight();
        float areaDifference = this.buttons.size() * targetButton.getHeight() - this.buttonAreaHeight;
        if (buttonTop < this.bodyTopPos) {
            float newScrollPos = (float)(this.bodyTopPos - buttonTop) / areaDifference;
            this.currentVariantScroll = Mth.clamp((float)(this.currentVariantScroll - newScrollPos), (float)0.0f, (float)1.0f);
            this.updateButtonPositions();
        } else if (buttonBottom > this.bodyTopPos + this.buttonAreaHeight) {
            float newScrollPos = (float)(buttonBottom - this.bodyTopPos - 106) / areaDifference;
            this.currentVariantScroll = Mth.clamp((float)(this.currentVariantScroll + newScrollPos), (float)0.0f, (float)1.0f);
            this.updateButtonPositions();
        }
    }
}

