/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.animal;

import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.mixin.animal.AnimalPenAnimal;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Sheep.class})
public abstract class AnimalPenSheep
extends AnimalPenAnimal {
    @Shadow
    @Final
    private static Map<DyeColor, ItemLike> ITEM_BY_DYE;
    @Unique
    private int animalPen$woolCooldown;

    protected AnimalPenSheep(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract DyeColor getColor();

    @Shadow
    public abstract void setColor(DyeColor var1);

    @Shadow
    public abstract void setSheared(boolean var1);

    @Shadow
    public abstract boolean isSheared();

    @Override
    @Intrinsic
    public boolean animalPen$animalPenTick(BlockEntity blockEntity) {
        boolean value = super.animalPen$animalPenTick(blockEntity);
        if (this.animalPen$woolCooldown > 0) {
            --this.animalPen$woolCooldown;
            return true;
        }
        if (this.isSheared()) {
            this.setSheared(false);
            return true;
        }
        return value;
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenSaveTag(CompoundTag tag) {
        super.animalPen$animalPenSaveTag(tag);
        tag.putInt("wool_cooldown", this.animalPen$woolCooldown);
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenLoadTag(CompoundTag tag) {
        super.animalPen$animalPenLoadTag(tag);
        this.animalPen$woolCooldown = tag.getInt("wool_cooldown");
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenInteract(Player player, InteractionHand hand, BlockPos position) {
        if (super.animalPen$animalPenInteract(player, hand, position)) {
            return true;
        }
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(Items.SHEARS)) {
            if (this.animalPen$woolCooldown > 0) {
                return false;
            }
            if (player.level().isClientSide()) {
                return true;
            }
            this.setSheared(true);
            itemStack.hurtAndBreak(1, (LivingEntity)player, AnimalPenSheep.getSlotForHand((InteractionHand)hand));
            ItemLike itemLike = ITEM_BY_DYE.get(this.getColor());
            int woolCount = 1;
            int dropLimits = AnimalPen.CONFIG_MANAGER.getConfiguration().getDropLimits(Items.WHITE_WOOL);
            if (dropLimits <= 0) {
                dropLimits = Integer.MAX_VALUE;
            }
            int i = 0;
            while ((long)i < this.animalPen$animalCount && woolCount < dropLimits) {
                woolCount += player.level().getRandom().nextInt(3);
                ++i;
            }
            while (woolCount > 0) {
                ItemStack woolStack = new ItemStack(itemLike);
                if (woolCount > 64) {
                    woolStack.setCount(64);
                    woolCount -= 64;
                } else {
                    woolStack.setCount(woolCount);
                    woolCount = 0;
                }
                Block.popResource((Level)player.level(), (BlockPos)position.above(), (ItemStack)woolStack);
            }
            player.level().playSound(null, position, SoundEvents.SHEEP_SHEAR, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$woolCooldown = AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.getType(), Items.SHEARS, this.animalPen$animalCount);
            return true;
        }
        Item item = itemStack.getItem();
        if (item instanceof DyeItem) {
            DyeItem dye = (DyeItem)item;
            if (player.level().isClientSide()) {
                return true;
            }
            this.setColor(dye.getDyeColor());
            if (!player.getAbilities().instabuild) {
                itemStack.shrink(1);
                player.setItemInHand(hand, itemStack);
            }
            player.level().playSound(null, position, SoundEvents.DYE_USE, SoundSource.NEUTRAL, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    @Intrinsic
    public List<Pair<ItemStack, Component>> animalPen$animalPenGetLines(int tick) {
        List<Pair<ItemStack, Component>> lines = super.animalPen$animalPenGetLines(tick);
        if (AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.getType(), Items.SHEARS, this.animalPen$animalCount) == 0) {
            return lines;
        }
        MutableComponent component = this.animalPen$woolCooldown == 0 ? Component.translatable((String)"display.animal_pen.wool_ready").withStyle(ChatFormatting.GREEN) : Component.translatable((String)"display.animal_pen.wool_cooldown", (Object[])new Object[]{LocalTime.of(0, 0, 0).plusSeconds(this.animalPen$woolCooldown / 20).format(AnimalPen.DATE_FORMATTER)});
        lines.add((Pair<ItemStack, Component>)Pair.of((Object)Items.SHEARS.getDefaultInstance(), (Object)component));
        return lines;
    }
}

