/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.animal;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.mixin.animal.AnimalPenAnimal;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.ChickenVariant;
import net.minecraft.world.entity.animal.ChickenVariants;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Chicken.class})
public abstract class AnimalPenChicken
extends AnimalPenAnimal {
    @Unique
    private int animalPen$eggCooldown;

    @Shadow
    public abstract Holder<ChickenVariant> getVariant();

    protected AnimalPenChicken(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenTick(BlockEntity blockEntity) {
        boolean value = super.animalPen$animalPenTick(blockEntity);
        if (this.animalPen$eggCooldown > 0) {
            --this.animalPen$eggCooldown;
            return true;
        }
        return value;
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenSaveTag(ValueOutput tag) {
        super.animalPen$animalPenSaveTag(tag);
        tag.putInt("egg_cooldown", this.animalPen$eggCooldown);
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenLoadTag(ValueInput tag) {
        super.animalPen$animalPenLoadTag(tag);
        this.animalPen$eggCooldown = tag.getIntOr("egg_cooldown", 0);
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenInteract(Player player, InteractionHand hand, BlockPos position) {
        if (super.animalPen$animalPenInteract(player, hand, position)) {
            return true;
        }
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(Items.BUCKET)) {
            ObjectArrayList randomItems;
            if (this.animalPen$eggCooldown > 0) {
                AnimalPen.sendDebug("Under cooldown for " + this.animalPen$eggCooldown);
                return false;
            }
            Level level = player.level();
            if (!(level instanceof ServerLevel)) {
                return true;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.CHICKEN_LAY);
            LootParams lootParams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)position.getCenter()).withParameter(LootContextParams.THIS_ENTITY, (Object)this).create(LootContextParamSets.GIFT);
            int dropLimits = AnimalPen.config().getDropLimits(Items.EGG);
            if (dropLimits <= 0) {
                dropLimits = Integer.MAX_VALUE;
            }
            ArrayList itemStackList = new ArrayList();
            for (int eggCount = (int)Math.min(this.animalPen$animalCount, (long)dropLimits); eggCount > 0 && !(randomItems = lootTable.getRandomItems(lootParams)).isEmpty(); eggCount -= randomItems.stream().mapToInt(ItemStack::getCount).sum()) {
                randomItems.forEach(item -> {
                    boolean added = false;
                    for (ItemStack stack : itemStackList) {
                        if (!ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)stack) || stack.getCount() >= stack.getMaxStackSize()) continue;
                        stack.grow(item.getCount());
                        added = true;
                        break;
                    }
                    if (!added) {
                        itemStackList.add(item);
                    }
                });
            }
            itemStackList.forEach(eggStack -> Block.popResource((Level)player.level(), (BlockPos)position.above(), (ItemStack)eggStack));
            player.level().playSound(null, position, SoundEvents.CHICKEN_EGG, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$eggCooldown = AnimalPen.config().getEntityCooldown(this.getType(), Items.BUCKET, this.animalPen$animalCount);
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.getItem().arch$registryName()));
            return true;
        }
        return false;
    }

    @Override
    @Intrinsic
    public ItemStack animalPen$animalPenInteract(ServerLevel level, ItemStack itemStack, BlockPos position) {
        if (this.animalPen$eggCooldown > 0) {
            AnimalPen.sendDebug("Under cooldown for " + this.animalPen$eggCooldown);
            return ItemStack.EMPTY;
        }
        if (itemStack.is(Items.BUCKET)) {
            int dropLimits = AnimalPen.config().getDropLimits(Items.EGG);
            if (dropLimits <= 0) {
                dropLimits = Integer.MAX_VALUE;
            }
            int eggCount = (int)Math.min(this.animalPen$animalCount, (long)dropLimits);
            while (eggCount > 0) {
                ItemStack eggStack = new ItemStack((ItemLike)Items.EGG);
                if (eggCount > 16) {
                    eggStack.setCount(16);
                    eggCount -= 16;
                } else {
                    eggStack.setCount(eggCount);
                    eggCount = 0;
                }
                Block.popResource((Level)level, (BlockPos)position.above(), (ItemStack)eggStack);
            }
            level.playSound(null, position, SoundEvents.CHICKEN_EGG, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$eggCooldown = AnimalPen.config().getEntityCooldown(this.getType(), Items.BUCKET, this.animalPen$animalCount);
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.getItem().arch$registryName()));
            return ItemStack.EMPTY;
        }
        return super.animalPen$animalPenInteract(level, itemStack, position);
    }

    @Override
    @Intrinsic
    public List<Pair<ItemStack[], Component>> animalPen$animalPenGetLines(int tick, boolean shortLine) {
        List<Pair<ItemStack[], Component>> lines = super.animalPen$animalPenGetLines(tick, shortLine);
        if (!AnimalPen.config().isShowAllInteractions() && shortLine && AnimalPen.config().getEntityCooldown(this.getType(), Items.BUCKET, this.animalPen$animalCount) == 0) {
            return lines;
        }
        MutableComponent component = Component.literal((String)"");
        if (this.animalPen$eggCooldown == 0) {
            component.append((Component)Component.translatable((String)(shortLine ? "display.animal_pen.ready" : "display.animal_pen.full_ready"), (Object[])new Object[]{Component.literal((String)"\ue000"), Component.literal((String)"\ue001")}).withStyle(ChatFormatting.GREEN));
        } else {
            component.append((Component)Component.translatable((String)(shortLine ? "display.animal_pen.cooldown" : "display.animal_pen.egg_cooldown"), (Object[])new Object[]{Component.literal((String)"\ue000"), Component.literal((String)"\ue001"), LocalTime.of(0, 0, 0).plusSeconds(this.animalPen$eggCooldown / 20).format(AnimalPen.DATE_FORMATTER)}));
        }
        lines.add((Pair<ItemStack[], Component>)Pair.of((Object)new ItemStack[]{Items.BUCKET.getDefaultInstance(), this.pen$getEggItem().getDefaultInstance()}, (Object)component));
        return lines;
    }

    @Unique
    private Item pen$getEggItem() {
        Holder<ChickenVariant> variant = this.getVariant();
        Item eggItem = variant.is(ChickenVariants.WARM) ? Items.BROWN_EGG : (variant.is(ChickenVariants.COLD) ? Items.BLUE_EGG : Items.EGG);
        return eggItem;
    }

    @Override
    @Intrinsic
    public int animalPen$getRedStoneSignal() {
        if (this.animalPen$eggCooldown > 0) {
            return super.animalPen$getRedStoneSignal();
        }
        return super.animalPen$getRedStoneSignal() | 4;
    }
}

