/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.network.packets;

import dev.architectury.networking.NetworkManager;
import java.util.Optional;
import java.util.UUID;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.entities.AnimalPenBlockInterface;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public record UpdateConfigurationData(BlockPos position, long size, long protectedAmount, Optional<UUID> uuid) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateConfigurationData> ID = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"animal_pen", (String)"update_configuration"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateConfigurationData> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, UpdateConfigurationData::position, (StreamCodec)ByteBufCodecs.VAR_LONG, UpdateConfigurationData::size, (StreamCodec)ByteBufCodecs.VAR_LONG, UpdateConfigurationData::protectedAmount, (StreamCodec)ByteBufCodecs.optional((StreamCodec)UUIDUtil.STREAM_CODEC), UpdateConfigurationData::uuid, UpdateConfigurationData::new);

    public static void handle(UpdateConfigurationData data, NetworkManager.PacketContext packetContext) {
        BlockPos blockPos = data.position();
        long displaySize = data.size();
        long protectedAmount = data.protectedAmount();
        Optional<UUID> owner = data.uuid();
        packetContext.queue(() -> {
            Level level = packetContext.getPlayer().level();
            BlockEntity patt0$temp = level.getBlockEntity(blockPos);
            if (patt0$temp instanceof AnimalPenBlockInterface) {
                AnimalPenBlockInterface animalPen = (AnimalPenBlockInterface)patt0$temp;
                animalPen.setAnimalDisplaySize(displaySize);
                animalPen.setProtectedAmount(protectedAmount);
                animalPen.setOwner(owner.orElse(null));
            } else {
                AnimalPen.LOGGER.error("Block entity not found at the position!");
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

