/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.blocks;

import dev.architectury.hooks.level.entity.PlayerHooks;
import java.util.Objects;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.entities.AnimalPenTileEntity;
import lv.id.bonne.animalpen.registries.AnimalPenTileEntityRegistry;
import lv.id.bonne.animalpen.registries.AnimalPensItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimalPenBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    private final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)3.0, (double)8.0, (double)3.0), Block.m_49796_((double)0.0, (double)4.0, (double)13.0, (double)3.0, (double)8.0, (double)16.0), Block.m_49796_((double)13.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)3.0), Block.m_49796_((double)13.0, (double)4.0, (double)13.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)3.0, (double)5.0, (double)0.0, (double)13.0, (double)7.0, (double)2.0), Block.m_49796_((double)3.0, (double)5.0, (double)14.0, (double)13.0, (double)7.0, (double)16.0), Block.m_49796_((double)0.0, (double)5.0, (double)3.0, (double)2.0, (double)7.0, (double)13.0), Block.m_49796_((double)14.0, (double)5.0, (double)3.0, (double)16.0, (double)7.0, (double)13.0)});
    public static final TagKey<Item> ATTACK_TOOLS = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("animal_pen", "can_attack_pen"));
    public static final TagKey<Block> ANIMAL_PENS = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("animal_pen", "animal_pens"));

    public AnimalPenBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        InteractionResult result = super.m_6227_(blockState, level, blockPos, player, interactionHand, blockHitResult);
        if (result == InteractionResult.FAIL || interactionHand != InteractionHand.MAIN_HAND) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemInHand = player.m_21120_(interactionHand);
        if (itemInHand.m_150930_((Item)AnimalPensItemRegistry.ANIMAL_CAGE.get())) {
            AnimalPenTileEntity entity;
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof AnimalPenTileEntity && (entity = (AnimalPenTileEntity)blockEntity).processContainer(player, interactionHand)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (!(blockEntity instanceof AnimalPenTileEntity)) {
            return InteractionResult.FAIL;
        }
        AnimalPenTileEntity entity = (AnimalPenTileEntity)blockEntity;
        if (PlayerHooks.isFake((Player)player) && itemInHand.m_204117_(ATTACK_TOOLS)) {
            this.m_6256_(blockState, level, blockPos, player);
            return InteractionResult.SUCCESS;
        }
        if (entity.interactWithPen(player, interactionHand)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_6256_(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        BlockEntity blockEntity;
        ItemStack weapon = player.m_21120_(InteractionHand.MAIN_HAND);
        if (weapon.m_204117_(ATTACK_TOOLS) && !level.m_5776_() && (blockEntity = level.m_7702_(blockPos)) instanceof AnimalPenTileEntity) {
            AnimalPenTileEntity entity = (AnimalPenTileEntity)blockEntity;
            if (player.m_36335_().m_41519_(weapon.m_41720_())) {
                return;
            }
            entity.attackThePen(player, level);
            if (PlayerHooks.isFake((Player)player)) {
                return;
            }
            int cooldown = AnimalPen.CONFIG_MANAGER.getConfiguration().getAttackCooldown();
            if (cooldown > 0) {
                player.m_36335_().m_41524_(weapon.m_41720_(), cooldown);
            }
            return;
        }
        super.m_6256_(blockState, level, blockPos, player);
    }

    public float m_5880_(BlockState blockState, Player player, BlockGetter blockGetter, BlockPos blockPos) {
        ItemStack weapon = player.m_21120_(InteractionHand.MAIN_HAND);
        if (weapon.m_204117_(ATTACK_TOOLS)) {
            return 0.0f;
        }
        return super.m_5880_(blockState, player, blockGetter, blockPos);
    }

    public void m_6810_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile;
        if (!state.m_60713_(newState.m_60734_()) && (tile = level.m_7702_(pos)) instanceof AnimalPenTileEntity) {
            AnimalPenTileEntity entity = (AnimalPenTileEntity)tile;
            for (int i = 0; i < entity.getInventory().m_6643_(); ++i) {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)entity.getInventory().m_8020_(i));
            }
            entity.getInventory().m_6211_();
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        return (BlockState)Objects.requireNonNull(super.m_5573_(context)).m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)AnimalPenTileEntityRegistry.ANIMAL_PEN_TILE_ENTITY.get()).m_155264_(blockPos, blockState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return AnimalPenBlock.createTickerHelper(type, (BlockEntityType)AnimalPenTileEntityRegistry.ANIMAL_PEN_TILE_ENTITY.get(), (world, pos, blockState, tileEntity) -> tileEntity.tick());
    }

    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> type, BlockEntityType<E> expectedType, BlockEntityTicker<? super E> ticker) {
        return type == expectedType ? ticker : null;
    }

    @Nullable
    public <T extends BlockEntity> GameEventListener m_214009_(ServerLevel level, T blockEntity) {
        return super.m_214009_(level, blockEntity);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

