/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.blocks.entities;

import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.entities.AnimalPenBlockInterface;
import lv.id.bonne.animalpen.interfaces.AnimalPenInterface;
import lv.id.bonne.animalpen.items.AnimalCageItem;
import lv.id.bonne.animalpen.network.packets.UpdateVariantScreenData;
import lv.id.bonne.animalpen.registries.AnimalPenDataComponentRegistry;
import lv.id.bonne.animalpen.registries.AnimalPenTileEntityRegistry;
import lv.id.bonne.animalpen.registries.AnimalPensItemRegistry;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_11580;
import net.minecraft.class_1262;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3730;
import net.minecraft.class_4844;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_8567;
import net.minecraft.class_8710;
import net.minecraft.class_8942;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimalPenTileEntity
extends class_2586
implements AnimalPenBlockInterface<class_1429> {
    private final class_1277 inventory = new class_1277(1){

        public boolean method_5437(int slot, class_1799 stack) {
            return stack.method_31574((class_1792)AnimalPensItemRegistry.ANIMAL_CAGE.get());
        }

        public void method_5431() {
            super.method_5431();
            AnimalPenTileEntity.this.triggerUpdate();
        }
    };
    private class_1429 storedAnimal;
    private long displaySize = -1L;
    private UUID ownerUUID;
    private long protectedAmount = 0L;
    private int tickCounter;
    private final List<Integer> deathTicker = new ArrayList<Integer>();
    public static final String TAG_INVENTORY = "inventory";
    public static final String TAG_DEATH_TICKER = "death_ticker";
    public static final String TAG_DISPLAY_SIZE = "display_size";
    public static final String TAG_OWNER_UUID = "owner_uuid";
    public static final String TAG_KEEP_AMOUNT = "keep_amount";

    public AnimalPenTileEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)AnimalPenTileEntityRegistry.ANIMAL_PEN_TILE_ENTITY.get(), blockPos, blockState);
    }

    public void method_11007(class_11372 valueOutput) {
        super.method_11007(valueOutput);
        class_1262.method_5427((class_11372)valueOutput, (class_2371)this.inventory.method_54454(), (boolean)true);
        if (!this.deathTicker.isEmpty()) {
            valueOutput.method_71473(TAG_DEATH_TICKER, this.deathTicker.stream().mapToInt(i -> i).toArray());
        }
        valueOutput.method_71466(TAG_DISPLAY_SIZE, this.displaySize);
        valueOutput.method_71477(TAG_OWNER_UUID, class_4844.field_25122, (Object)this.ownerUUID);
        valueOutput.method_71466(TAG_KEEP_AMOUNT, this.protectedAmount);
    }

    protected void method_11014(class_11368 valueInput) {
        super.method_11014(valueInput);
        this.inventory.method_5448();
        this.deathTicker.clear();
        this.storedAnimal = null;
        this.ownerUUID = null;
        class_1262.method_5429((class_11368)valueInput, (class_2371)this.inventory.method_54454());
        valueInput.method_71420(TAG_INVENTORY).ifPresent(oldInput -> class_1262.method_5429((class_11368)oldInput, (class_2371)this.inventory.method_54454()));
        valueInput.method_71442(TAG_DEATH_TICKER).ifPresent(deaths -> {
            for (int death : deaths) {
                this.deathTicker.add(death);
            }
        });
        this.displaySize = valueInput.method_71425(TAG_DISPLAY_SIZE, -1L);
        valueInput.method_71426(TAG_OWNER_UUID, class_4844.field_25122).ifPresent(uuid -> {
            this.ownerUUID = uuid;
        });
        this.protectedAmount = valueInput.method_71425(TAG_KEEP_AMOUNT, 0L);
    }

    @NotNull
    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_38244(provider);
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @Override
    public Optional<class_1429> getStoredAnimal() {
        if (this.storedAnimal == null && !this.getItemStack().method_7960()) {
            class_11580 customData = (class_11580)this.getItemStack().method_58694(class_9334.field_49609);
            if (customData == null) {
                return Optional.ofNullable(this.storedAnimal);
            }
            class_2487 tag = customData.method_72540();
            if (this.field_11863 == null) {
                return Optional.ofNullable(this.storedAnimal);
            }
            try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(this.method_71402(), AnimalPen.LOGGER);){
                class_11368 valueInput = class_11352.method_71417((class_8942)scopedCollector, (class_7225.class_7874)this.field_11863.method_30349(), (class_2487)tag);
                class_1299.method_72384((class_1299)((class_1299)customData.method_72530()), (class_11368)valueInput, (class_1937)this.field_11863, (class_3730)class_3730.field_16461).map(entity -> (class_1429)entity).ifPresent(animal -> {
                    this.storedAnimal = animal;
                });
            }
        } else if (this.storedAnimal != null && this.getItemStack().method_7960()) {
            this.storedAnimal = null;
        }
        return Optional.ofNullable(this.storedAnimal);
    }

    public List<Integer> getDeathTicker() {
        return this.deathTicker;
    }

    public int getTickCounter() {
        return this.tickCounter;
    }

    public void tick() {
        ++this.tickCounter;
        if (this.method_10997() == null || this.method_10997().method_8608()) {
            return;
        }
        boolean updated = this.getStoredAnimal().map(animal -> ((AnimalPenInterface)animal).animalPenTick(this)).orElse(false);
        for (int i = 0; i < this.deathTicker.size(); ++i) {
            this.deathTicker.set(i, this.deathTicker.get(i) + 1);
            updated = true;
        }
        this.deathTicker.removeIf(integer -> integer > 20);
        if (updated) {
            this.triggerUpdate();
        }
    }

    public boolean processContainer(class_1657 player, class_1268 interactionHand) {
        if (this.getOwner().isPresent() && !this.getOwner().get().equals(player.method_5667())) {
            AnimalPen.sendDebug("Protection is enabled");
            return false;
        }
        if (this.inventory.method_5442()) {
            class_1799 itemInHand = player.method_5998(interactionHand);
            if (!itemInHand.method_57826(class_9334.field_49609)) {
                return false;
            }
            if (!player.method_73183().method_8608()) {
                this.inventory.method_5491(itemInHand);
                player.method_6122(interactionHand, class_1799.field_8037);
                if (this.field_11863 != null && !this.field_11863.method_8608()) {
                    NetworkManager.sendToPlayers(((class_3218)this.field_11863).method_18456().stream().filter(other -> other.method_5649((double)this.method_11016().method_10263(), (double)this.method_11016().method_10264(), (double)this.method_11016().method_10260()) < 50.0).toList(), (class_8710)new UpdateVariantScreenData(this.method_11016()));
                }
                AnimalPen.sendDebug("Deposit animal cage into pen");
            }
            return true;
        }
        class_1799 itemInHand = player.method_5998(interactionHand);
        if (!itemInHand.method_57826(class_9334.field_49609)) {
            class_2487 tag;
            if (!player.method_18276()) {
                return false;
            }
            if (player.method_73183().method_8608()) {
                return true;
            }
            class_1429 animal = this.getStoredAnimal().orElse(null);
            if (animal == null) {
                return false;
            }
            long currentCount = ((AnimalPenInterface)animal).animalPenGetCount();
            if (currentCount < 2L) {
                AnimalPen.sendDebug("Cannot split 1");
                return false;
            }
            long newCount = Math.min(currentCount - this.protectedAmount, currentCount / 2L);
            if (newCount <= 0L) {
                AnimalPen.sendDebug("Protected amount prevents from splitting");
                return false;
            }
            if (!((AnimalPenInterface)animal).animalPenUpdateCount(-newCount)) {
                AnimalPen.sendDebug("Fail to reduce animal count");
                return false;
            }
            try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(this.method_71402(), AnimalPen.LOGGER);){
                class_11362 valueOutput = class_11362.method_71459((class_8942)scopedCollector, (class_7225.class_7874)animal.method_56673());
                animal.method_5662((class_11372)valueOutput);
                tag = valueOutput.method_71475();
            }
            tag.method_10544("animal_count", newCount);
            itemInHand.method_57379(class_9334.field_49609, (Object)class_11580.method_72535((Object)animal.method_5864(), (class_2487)tag));
            player.method_6122(interactionHand, itemInHand);
            this.inventory.method_5431();
            AnimalPen.sendDebug("Half the amount of animals in pen");
            return true;
        }
        class_1429 animal = this.getStoredAnimal().orElse(null);
        class_11580 entityData = (class_11580)itemInHand.method_58694(class_9334.field_49609);
        if (animal == null || !((class_1299)entityData.method_72530()).equals(animal.method_5864())) {
            AnimalPen.sendDebug("Different animals");
            return false;
        }
        if (player.method_73183().method_8608()) {
            return true;
        }
        class_2487 itemInHandTag = entityData.method_72540();
        long newCount = itemInHandTag.method_68080("animal_count", 0L);
        if (newCount <= 0L || !((AnimalPenInterface)animal).animalPenUpdateCount(newCount)) {
            AnimalPen.sendDebug("Failed to deposit animal");
            return false;
        }
        if (newCount > 1L && !AnimalCageItem.canMergeAnimalVariants(this.getItemStack(), itemInHand, player)) {
            AnimalPen.sendDebug("Variants could not be merged");
            ((AnimalPenInterface)animal).animalPenUpdateCount(-1L);
            itemInHandTag.method_10544("animal_count", 1L);
            itemInHand.method_57379(class_9334.field_49609, (Object)class_11580.method_72535((Object)animal.method_5864(), (class_2487)itemInHandTag));
        } else {
            AnimalCageItem.mergeAnimalVariants(this.getItemStack(), itemInHand, player);
            itemInHand.method_57381(class_9334.field_49609);
            itemInHand.method_57381((class_9331)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
            if (this.field_11863 != null && !this.field_11863.method_8608()) {
                NetworkManager.sendToPlayers(((class_3218)this.field_11863).method_18456().stream().filter(other -> other.method_5649((double)this.method_11016().method_10263(), (double)this.method_11016().method_10264(), (double)this.method_11016().method_10260()) < 50.0).toList(), (class_8710)new UpdateVariantScreenData(this.method_11016()));
            }
        }
        player.method_6122(interactionHand, itemInHand);
        this.inventory.method_5431();
        AnimalPen.sendDebug("Cage merged into pen");
        return true;
    }

    public boolean interactWithPen(class_1657 player, class_1268 interactionHand) {
        if (this.getOwner().isPresent() && !this.getOwner().get().equals(player.method_5667())) {
            AnimalPen.sendDebug("Protection is enabled");
            return false;
        }
        class_1799 itemInHand = player.method_5998(interactionHand);
        if (itemInHand.method_7960() && !this.inventory.method_5442()) {
            if (player.method_18276() && !player.method_73183().method_8608()) {
                class_1799 item = this.getItemStack();
                player.method_6122(interactionHand, item);
                this.inventory.method_5447(0, class_1799.field_8037);
                this.inventory.method_5431();
                AnimalPen.sendDebug("Taking out animal cage");
            }
            return true;
        }
        class_1429 animal = this.getStoredAnimal().orElse(null);
        if (animal == null) {
            AnimalPen.sendDebug("Animal is not set");
            return false;
        }
        if (((AnimalPenInterface)animal).animalPenInteract(player, interactionHand, this.method_11016())) {
            class_2487 tag;
            AnimalPen.sendDebug("Animal Interaction finished");
            class_1799 item = this.getItemStack();
            try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(this.method_71402(), AnimalPen.LOGGER);){
                class_11362 valueOutput = class_11362.method_71459((class_8942)scopedCollector, (class_7225.class_7874)animal.method_56673());
                animal.method_5662((class_11372)valueOutput);
                tag = valueOutput.method_71475();
            }
            item.method_57379(class_9334.field_49609, (Object)class_11580.method_72535((Object)animal.method_5864(), (class_2487)tag));
            this.inventory.method_5431();
            return true;
        }
        return false;
    }

    public void attackThePen(class_1657 player, class_1937 level) {
        if (this.getOwner().isPresent() && !this.getOwner().get().equals(player.method_5667())) {
            AnimalPen.sendDebug("Protection is enabled");
            return;
        }
        class_1799 weapon = player.method_5998(class_1268.field_5808);
        class_1429 animal = this.getStoredAnimal().orElse(null);
        if (animal == null) {
            AnimalPen.sendDebug("Animal Pen is empty");
            return;
        }
        long amount = ((AnimalPenInterface)animal).animalPenGetCount();
        if (amount <= this.protectedAmount) {
            AnimalPen.sendDebug("Protected amount reached");
            return;
        }
        if (!((AnimalPenInterface)animal).animalPenUpdateCount(-1L)) {
            AnimalPen.sendDebug("Failed to update animal count");
            return;
        }
        class_1890.method_60619((class_3218)((class_3218)level), (class_1297)animal, (class_1282)level.method_48963().method_48802(player), (class_1799)weapon);
        if (AnimalPen.config().isIncreaseStatistics()) {
            player.method_7259(class_3468.field_15372.method_14956((Object)weapon.method_7909()));
        }
        weapon.method_71012(1, (class_1309)player, class_1268.field_5808);
        this.deathTicker.add(0);
        if (((AnimalPenInterface)animal).animalPenGetCount() <= 0L) {
            class_1799 item = this.getItemStack();
            item.method_57381(class_9334.field_49609);
            item.method_57381((class_9331)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
            class_2248.method_9577((class_1937)level, (class_2338)this.method_11016().method_10084(), (class_1799)item);
            this.inventory.method_5447(0, class_1799.field_8037);
            AnimalPen.sendDebug("Dropping empty cage");
        }
        this.triggerUpdate();
        class_243 position = new class_243((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260());
        class_52 lootTable = level.method_8503().method_58576().method_58295((class_5321)animal.method_5991().get());
        class_8567.class_8568 paramsBuilder = new class_8567.class_8568((class_3218)level).method_51874(class_181.field_24424, (Object)position).method_51874(class_181.field_1226, (Object)animal).method_51874(class_181.field_1230, (Object)player).method_51874(class_181.field_1227, (Object)player).method_51874(class_181.field_1233, (Object)player).method_51874(class_181.field_1231, (Object)level.method_48963().method_48802(player)).method_51871(player.method_7292());
        lootTable.method_51879(paramsBuilder.method_51875(class_173.field_1173), level.method_8409().method_43055()).forEach(itemStack -> class_2248.method_9577((class_1937)level, (class_2338)this.method_11016().method_10084(), (class_1799)itemStack));
        animal.method_5646();
        int reward = animal.method_59923((class_3218)level, (class_1297)player);
        class_1303.method_31493((class_3218)((class_3218)this.field_11863), (class_243)position.method_1031(0.5, 1.0, 0.5), (int)reward);
        if (AnimalPen.config().isTriggerAdvancements()) {
            class_174.field_1192.method_8990((class_3222)player, (class_1297)animal, level.method_48963().method_48802(player));
        }
        if (AnimalPen.config().isIncreaseStatistics()) {
            player.method_7281(class_3468.field_15414);
            player.method_7259(class_3468.field_15403.method_14956((Object)animal.method_5864()));
        }
        AnimalPen.sendDebug("Animal Kill process finished");
    }

    public int getRedStoneSignal() {
        return this.getStoredAnimal().map(animal -> ((AnimalPenInterface)animal).getRedStoneSignal()).orElse(0);
    }

    @Override
    public void triggerUpdate() {
        this.method_5431();
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return;
        }
        this.getStoredAnimal().ifPresent(animal -> {
            class_2487 tag;
            try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(this.method_71402(), AnimalPen.LOGGER);){
                class_11362 valueOutput = class_11362.method_71459((class_8942)scopedCollector, (class_7225.class_7874)animal.method_56673());
                animal.method_5662((class_11372)valueOutput);
                tag = valueOutput.method_71475();
            }
            this.getItemStack().method_57379(class_9334.field_49609, (Object)class_11580.method_72535((Object)animal.method_5864(), (class_2487)tag));
        });
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
    }

    public class_1277 getInventory() {
        return this.inventory;
    }

    private class_1799 getItemStack() {
        return this.inventory.method_5438(0);
    }

    public void method_66473(class_2338 blockPos, class_2680 blockState) {
        if (this.field_11863 != null) {
            class_1264.method_17349((class_1937)this.field_11863, (class_2338)blockPos, (class_2371)this.inventory.method_54454());
        }
    }

    @Override
    public class_2499 getEntityVariants() {
        return this.getStoredAnimal().map(animal -> AnimalCageItem.getAnimalVariants(this.getItemStack()).orElseGet(class_2499::new)).orElseGet(class_2499::new);
    }

    @Override
    public long getAnimalDisplaySize() {
        return this.displaySize < 1L ? this.getAnimalCount() : Math.min(this.displaySize, this.getAnimalCount());
    }

    @Override
    public void setAnimalDisplaySize(long size) {
        this.displaySize = size;
        this.triggerUpdate();
    }

    @Override
    public void updateAnimalVariant(class_11368 animalVariant) {
        if (this.getStoredAnimal().isEmpty() || animalVariant == null) {
            return;
        }
        this.getStoredAnimal().ifPresent(animal -> {
            AnimalPen.sendDebug("Animal Variant changed");
            try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(this.method_71402(), AnimalPen.LOGGER);){
                class_11362 valueOutput = class_11362.method_71459((class_8942)scopedCollector, (class_7225.class_7874)this.field_11863.method_30349());
                ((AnimalPenInterface)animal).animalPenSaveTag((class_11372)valueOutput);
                class_2487 extraData = valueOutput.method_71475();
                animal.method_5651(animalVariant);
                class_11368 valueInput = class_11352.method_71417((class_8942)scopedCollector, (class_7225.class_7874)this.field_11863.method_30349(), (class_2487)extraData);
                ((AnimalPenInterface)animal).animalPenLoadTag(valueInput);
            }
            this.triggerUpdate();
            if (this.field_11863 != null && !this.field_11863.method_8608()) {
                NetworkManager.sendToPlayers(((class_3218)this.field_11863).method_18456().stream().filter(other -> other.method_5649((double)this.method_11016().method_10263(), (double)this.method_11016().method_10264(), (double)this.method_11016().method_10260()) < 50.0).toList(), (class_8710)new UpdateVariantScreenData(this.method_11016()));
            }
        });
    }

    @Override
    public void removeAnimalVariant(int index) {
        if (this.getStoredAnimal().isEmpty() || this.getEntityVariants().size() <= index) {
            return;
        }
        class_9279 customData = (class_9279)this.getItemStack().method_58694((class_9331)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
        if (customData == null) {
            return;
        }
        this.getItemStack().method_57379((class_9331)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get(), (Object)customData.method_57451(tag -> tag.method_10554("animal_variants").ifPresent(list -> list.method_10536(index))));
        this.inventory.method_5431();
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            NetworkManager.sendToPlayers(((class_3218)this.field_11863).method_18456().stream().filter(other -> other.method_5649((double)this.method_11016().method_10263(), (double)this.method_11016().method_10264(), (double)this.method_11016().method_10260()) < 50.0).toList(), (class_8710)new UpdateVariantScreenData(this.method_11016()));
            AnimalPen.sendDebug("Animal variant removed");
        }
    }

    @Override
    public long getAnimalCount() {
        return this.getStoredAnimal().map(animal -> ((AnimalPenInterface)animal).animalPenGetCount()).orElse(0L);
    }

    @Override
    public boolean canGrowEntity() {
        return AnimalPen.config().isGrowAnimals();
    }

    @Override
    public List<Pair<class_1799[], class_2561>> getCooldownLines(boolean shortText) {
        return this.getStoredAnimal().map(animal -> ((AnimalPenInterface)animal).animalPenGetLines(this.getTickCounter(), shortText)).orElse(Collections.emptyList());
    }

    @Override
    public long getProtectedAmount() {
        return this.protectedAmount;
    }

    @Override
    public void setProtectedAmount(long amount) {
        this.protectedAmount = amount;
        this.triggerUpdate();
    }

    @Override
    public Optional<UUID> getOwner() {
        return Optional.ofNullable(this.ownerUUID);
    }

    @Override
    public void setOwner(@Nullable UUID owner) {
        this.ownerUUID = owner;
        this.triggerUpdate();
    }
}

