/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.blocks.renderer;

import java.util.List;
import java.util.Objects;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.AnimalPenBlock;
import lv.id.bonne.animalpen.blocks.entities.AquariumTileEntity;
import lv.id.bonne.animalpen.blocks.renderer.state.AnimalPenRenderState;
import lv.id.bonne.animalpen.mixin.accessors.EntityAccessor;
import net.minecraft.class_10017;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3730;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5614;
import net.minecraft.class_7225;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_8942;
import net.minecraft.class_898;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class AquariumRenderer
implements class_827<AquariumTileEntity, AnimalPenRenderState> {
    private final class_898 entityRenderer;
    private final class_10442 itemModelResolver;
    private final class_327 font;
    private final class_310 minecraft = class_310.method_1551();

    public AquariumRenderer(class_5614.class_5615 context) {
        this.entityRenderer = context.comp_4538();
        this.itemModelResolver = context.comp_4536();
        this.font = context.comp_4540();
    }

    @NotNull
    public AnimalPenRenderState createRenderState() {
        return new AnimalPenRenderState();
    }

    public void extractRenderState(AquariumTileEntity blockEntity, AnimalPenRenderState renderState, float partialTick, class_243 position, @Nullable class_11683.class_11792 crumblingOverlay) {
        super.method_74331((class_2586)blockEntity, (class_11954)renderState, partialTick, position, crumblingOverlay);
        renderState.facing = (class_2350)blockEntity.method_11010().method_11654((class_2769)AnimalPenBlock.field_11177);
        renderState.animalDisplaySize = blockEntity.getAnimalDisplaySize();
        renderState.animalCount = blockEntity.getAnimalCount();
        renderState.cooldownLines = blockEntity.getCooldownLines(true);
        renderState.level = blockEntity.method_10997();
        class_1308 animal = blockEntity.getStoredAnimal().orElse(null);
        if (animal != null) {
            animal.field_6283 = 0.0f;
            animal.method_36456(0.0f);
            animal.field_6241 = 0.0f;
            animal.field_6259 = 0.0f;
            animal.method_18380(class_4050.field_18079);
            animal.method_5796(true);
            ((EntityAccessor)animal).setWasTouchingWater(true);
            animal.field_6012 = blockEntity.getTickCounter();
            renderState.displayEntity = this.entityRenderer.method_72977((class_1297)animal, partialTick);
            renderState.displayEntity.field_61820 = renderState.field_62676;
            try (class_8942.class_11340 reported = new class_8942.class_11340(animal.method_71370(), AnimalPen.LOGGER);){
                class_11362 tagOutput = class_11362.method_71459((class_8942)reported, (class_7225.class_7874)animal.method_56673());
                animal.method_5662((class_11372)tagOutput);
                class_11368 tagInput = class_11352.method_71417((class_8942)reported, (class_7225.class_7874)animal.method_56673(), (class_2487)tagOutput.method_71475());
                blockEntity.getDeathTicker().forEach(tick -> class_1299.method_72384((class_1299)animal.method_5864(), (class_11368)tagInput, (class_1937)animal.method_73183(), (class_3730)class_3730.field_16461).ifPresent(entity -> {
                    class_1309 death = (class_1309)entity;
                    death.method_18380(class_4050.field_18082);
                    death.field_6213 = tick;
                    class_10017 entityRenderState = this.entityRenderer.method_72977((class_1297)death, partialTick);
                    entityRenderState.field_61820 = renderState.field_62676;
                    renderState.dyingEntity.add(entityRenderState);
                    death.method_5650(class_1297.class_5529.field_26999);
                }));
            }
        }
    }

    public void submit(AnimalPenRenderState renderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        if (renderState.displayEntity == null) {
            return;
        }
        class_2350 facing = renderState.facing;
        poseStack.method_22903();
        poseStack.method_22904(0.5, 0.0, 0.5);
        switch (facing) {
            case field_11035: {
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
                break;
            }
            case field_11039: {
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(90.0f));
                break;
            }
            case field_11034: {
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(270.0f));
            }
        }
        poseStack.method_46416(0.0f, 0.0f, 0.0f);
        this.renderAnimal(renderState, poseStack, submitNodeCollector, cameraRenderState);
        this.renderCounter(renderState, poseStack, submitNodeCollector, cameraRenderState);
        if (this.minecraft.field_1724 != null && this.minecraft.field_1724.method_18276() || !AnimalPen.config().isShowCooldownsOnCrouch()) {
            this.renderTextLines(renderState, poseStack, submitNodeCollector, cameraRenderState);
        }
        poseStack.method_22909();
    }

    private void renderAnimal(AnimalPenRenderState renderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.75, 0.0);
        float animalSize = AnimalPen.config().getWaterAnimalSize();
        poseStack.method_22905(animalSize, animalSize, animalSize);
        if (AnimalPen.config().isGrowWaterAnimals()) {
            float scale = 1.0f + animalSize * renderState.animalDisplaySize * AnimalPen.config().getGrowthMultiplier().floatValue();
            poseStack.method_22905(scale, scale, scale);
        }
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
        this.entityRenderer.method_72976(renderState.displayEntity, cameraRenderState, 0.0, 0.0, 0.0, poseStack, submitNodeCollector);
        submitNodeCollector.method_73529(5);
        renderState.dyingEntity.forEach(state -> this.entityRenderer.method_72976(state, cameraRenderState, 0.0, 0.0, 0.0, poseStack, submitNodeCollector));
        poseStack.method_22909();
    }

    private void renderCounter(AnimalPenRenderState renderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        long count = renderState.animalCount;
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.125f, -0.51f);
        class_5250 text = class_2561.method_43469((String)"display.animal_pen.count", (Object[])new Object[]{count});
        int textWidth = this.font.method_27525((class_5348)text);
        float maxWidth = 30.0f;
        float scale = Math.min(1.0f, maxWidth / (float)textWidth) * 0.015f;
        poseStack.method_22905(-scale, -scale, 0.0f);
        double d = (double)(-textWidth) / 2.0;
        Objects.requireNonNull(this.font);
        poseStack.method_22904(d, (double)((float)(-9) / 2.0f), 0.0);
        submitNodeCollector.method_73478(poseStack, 0.0f, 0.0f, text.method_30937(), false, class_327.class_6415.field_33993, renderState.field_62676, -1, 0, 0);
        poseStack.method_22909();
    }

    private void renderTextLines(AnimalPenRenderState renderState, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        class_2350 facing;
        class_243 facingVec;
        List<Pair<class_1799[], class_2561>> textList = renderState.cooldownLines;
        if (textList.isEmpty()) {
            return;
        }
        class_2338 blockPos = renderState.field_62673;
        class_243 playerPos = cameraRenderState.field_63078;
        class_243 toPlayer = new class_243(playerPos.method_10216() - (double)blockPos.method_10263(), 0.0, playerPos.method_10215() - (double)blockPos.method_10260());
        if (toPlayer.method_1026(facingVec = class_243.method_24954((class_2382)(facing = renderState.facing).method_62675())) < 0.0) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
        }
        double totalHeight = 1.75 + 0.25 * (double)(textList.size() - 1);
        double maxWidth = 0.0;
        for (Pair<class_1799[], class_2561> pair : textList) {
            maxWidth = Math.max(maxWidth, this.calculateMaxWidth(pair));
        }
        poseStack.method_22903();
        poseStack.method_22904(0.0, totalHeight, 0.0);
        maxWidth = -maxWidth / 2.0;
        for (int i = 0; i < textList.size(); ++i) {
            poseStack.method_22903();
            poseStack.method_22904(0.0, -0.125 * (double)i, 0.0);
            poseStack.method_22905(-0.0125f, -0.0125f, 0.0125f);
            poseStack.method_22904(maxWidth, 0.0, 0.0);
            this.renderTextLine(textList.get(i), renderState, poseStack, submitNodeCollector, cameraRenderState);
            poseStack.method_22909();
        }
        poseStack.method_22909();
    }

    private void renderTextLine(Pair<class_1799[], class_2561> componentPair, AnimalPenRenderState renderState, @NotNull class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        class_2561 text = (class_2561)componentPair.getRight();
        class_1799 first = ((class_1799[])componentPair.getLeft()).length > 0 ? ((class_1799[])componentPair.getLeft())[0] : null;
        class_1799 second = ((class_1799[])componentPair.getLeft()).length > 1 ? ((class_1799[])componentPair.getLeft())[1] : null;
        int whiteSpace = this.font.method_1727(" ");
        boolean isFirst = true;
        int leftOffset = 0;
        for (class_2561 part : text.method_36136(class_2583.field_24360)) {
            poseStack.method_46416((float)leftOffset, 0.0f, 0.0f);
            String content = part.getString();
            if (content.equals("\ue000")) {
                if (first == null) {
                    leftOffset = isFirst ? 0 : -whiteSpace;
                    continue;
                }
                poseStack.method_22903();
                poseStack.method_22905(-20.0f, -20.0f, 20.0f);
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
                itemStackRenderState = new class_10444();
                this.itemModelResolver.method_65598(itemStackRenderState, first, class_811.field_4318, renderState.level, null, 0);
                itemStackRenderState.method_65604(poseStack, submitNodeCollector, renderState.field_62676, class_4608.field_21444, 0);
                poseStack.method_22909();
                leftOffset = 8 - whiteSpace;
            } else if (content.equals("\ue001")) {
                if (second == null) {
                    leftOffset = isFirst ? 0 : -whiteSpace;
                    continue;
                }
                poseStack.method_22903();
                poseStack.method_22905(-20.0f, -20.0f, 20.0f);
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
                itemStackRenderState = new class_10444();
                this.itemModelResolver.method_65598(itemStackRenderState, second, class_811.field_4318, renderState.level, null, 0);
                itemStackRenderState.method_65604(poseStack, submitNodeCollector, renderState.field_62676, class_4608.field_21444, 0);
                poseStack.method_22909();
                leftOffset = 8 - whiteSpace;
            } else {
                poseStack.method_22903();
                submitNodeCollector.method_73478(poseStack, 0.0f, -6.0f, part.method_30937(), false, class_327.class_6415.field_33993, renderState.field_62676, -1, 0, 0);
                poseStack.method_22909();
                leftOffset = this.font.method_27525((class_5348)part);
            }
            isFirst = false;
        }
    }

    private double calculateMaxWidth(Pair<class_1799[], class_2561> pair) {
        class_2561 text = (class_2561)pair.getRight();
        class_1799 first = ((class_1799[])pair.getLeft()).length > 0 ? ((class_1799[])pair.getLeft())[0] : null;
        class_1799 second = ((class_1799[])pair.getLeft()).length > 1 ? ((class_1799[])pair.getLeft())[1] : null;
        int whiteSpace = this.font.method_1727(" ");
        boolean isFirst = true;
        double width = 0.0;
        for (class_2561 part : text.method_36136(class_2583.field_24360)) {
            String content = part.getString();
            if (content.equals("\ue000")) {
                if (first == null) continue;
                if (!isFirst) {
                    width -= (double)whiteSpace;
                }
                width += (double)(16 - whiteSpace);
            } else if (content.equals("\ue001")) {
                if (second == null) continue;
                if (!isFirst) {
                    width -= (double)whiteSpace;
                }
                width += (double)(16 - whiteSpace);
            } else {
                width += (double)this.font.method_27525((class_5348)part);
            }
            isFirst = false;
        }
        return width;
    }

    public boolean method_3563() {
        return AnimalPen.config().isGrowWaterAnimals();
    }

    public int method_33893() {
        return super.method_33893();
    }

    public boolean shouldRender(AquariumTileEntity blockEntity, class_243 vec3) {
        return AnimalPen.config().isGrowWaterAnimals() || super.method_33892((class_2586)blockEntity, vec3);
    }
}

