/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lv.id.bonne.animalpen.blocks.entities.AnimalPenBlockInterface;
import lv.id.bonne.animalpen.mixin.accessors.EntityAccessor;
import lv.id.bonne.animalpen.network.packets.RemoveDisplayAnimalData;
import lv.id.bonne.animalpen.network.packets.UpdateAnimalSizeData;
import lv.id.bonne.animalpen.network.packets.UpdateDisplayAnimalData;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1480;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3730;
import net.minecraft.class_4050;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_768;
import net.minecraft.class_7833;
import net.minecraft.class_8710;
import net.minecraft.class_898;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class VariantScreenSelection
extends class_437 {
    private final class_2338 position;
    private final int imageWidth;
    private final int cooldownWidth;
    private final int imageHeight;
    private final List<class_4185> buttons = new ArrayList<class_4185>();
    private final int buttonAreaHeight = 106;
    private final int sliderAreaWidth = 64;
    private AnimalPenBlockInterface<?> blockEntityInterface;
    private int leftPos;
    private int topPos;
    private int bodyTopPos;
    private int sliderBarPos;
    private float currentVariantScroll;
    private boolean isScrollingVariants;
    private boolean isCooldownOpened;
    private int selectedButton = -1;
    private class_4185 deleteButton;
    private class_4185 applyButton;
    private class_4185 sliderButton;
    private class_4185 cooldownButton;
    private class_1309 displayEntity;
    private float entityScale;
    private float entityOffset;
    private float entityRotation = -45.0f;
    private int currentXOnEntity;
    private boolean isSelectingEntity;
    private boolean isSelectingSizeBar;
    private int needsUpdate;
    private static final class_2561 TITLE = class_2561.method_43471((String)"gui.animal_pen.variant_selection_screen");
    private static final class_2561 APPLY = class_2561.method_43471((String)"gui.animal_pen.variant_selection_screen.apply_tooltip");
    private static final class_2561 DELETE = class_2561.method_43471((String)"gui.animal_pen.variant_selection_screen.delete_tooltip");
    private static final class_2561 SELECT_TO_DELETE = class_2561.method_43471((String)"gui.animal_pen.variant_selection_screen.select_to_delete_tooltip");
    private static final class_2561 COOLDOWN_OPEN = class_2561.method_43471((String)"gui.animal_pen.variant_selection_screen.cooldown_open_tooltip");
    private static final class_2561 COOLDOWN_CLOSE = class_2561.method_43471((String)"gui.animal_pen.variant_selection_screen.cooldown_close_tooltip");
    private static final class_2561 SLIDER = class_2561.method_43471((String)"gui.animal_pen.variant_selection_screen.slider_tooltip");
    private static final class_2561 SLIDER_HELPER_DRAG = class_2561.method_43471((String)"gui.animal_pen.variant_selection_screen.slider_tooltip_drag");
    private static final class_2561 SLIDER_HELPER_ARROW = class_2561.method_43471((String)"gui.animal_pen.variant_selection_screen.slider_tooltip_arrow");
    private static final String BUTTON_TEXT = "gui.animal_pen.variant_selection_screen.select_variant";
    private static final String SIZE_TEXT = "gui.animal_pen.variant_selection_screen.entity_size";
    private static final String FIXED_TEXT = "gui.animal_pen.variant_selection_screen.fixed_size";
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"animal_pen", (String)"textures/gui/animal_selection.png");
    private static final class_2960 COOLDOWN_TEXTURE = class_2960.method_60655((String)"animal_pen", (String)"textures/gui/cooldown_area.png");

    public VariantScreenSelection(class_2338 position) {
        super(TITLE);
        this.position = position;
        this.imageWidth = 176;
        this.imageHeight = 136;
        this.cooldownWidth = 149;
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37067();
        this.leftPos = this.isCooldownOpened ? (this.field_22789 - this.imageWidth + this.cooldownWidth) / 2 : (this.field_22789 - this.imageWidth) / 2;
        this.topPos = (this.field_22790 - this.imageHeight) / 2;
        this.buttons.clear();
        this.bodyTopPos = this.topPos + 18;
        int buttonPos = this.leftPos + 24;
        int buttonWidth = 46;
        int buttonHeight = 20;
        if (this.field_22787 == null || this.field_22787.field_1687 == null) {
            return;
        }
        class_2586 blockEntity = this.field_22787.field_1687.method_8321(this.position);
        if (!(blockEntity instanceof AnimalPenBlockInterface)) {
            return;
        }
        AnimalPenBlockInterface animalPenEntity = (AnimalPenBlockInterface)blockEntity;
        this.blockEntityInterface = animalPenEntity;
        class_2499 entityList = this.blockEntityInterface.getEntityVariants();
        if (entityList == null) {
            entityList = new class_2499();
        }
        int i = 0;
        while (i < entityList.size()) {
            int y = this.bodyTopPos + i * buttonHeight;
            int index = i++;
            this.buttons.add((class_4185)this.method_25429((class_364)class_4185.method_46430((class_2561)class_2561.method_43469((String)BUTTON_TEXT, (Object[])new Object[]{index + 1}), button -> this.handleVariantButton(button, index)).method_46433(buttonPos, y).method_46437(buttonWidth, buttonHeight).method_46431()));
        }
        this.deleteButton = (class_4185)this.method_25429((class_364)class_4185.method_46430((class_2561)class_2561.method_43473(), this::handleDeleteButton).method_46433(this.leftPos + 157, this.topPos + 111).method_46437(11, 14).method_46431());
        this.applyButton = (class_4185)this.method_25429((class_364)class_4185.method_46430((class_2561)class_2561.method_43473(), this::handleApplyButton).method_46433(this.leftPos + 73, this.topPos + 111).method_46437(14, 14).method_46431());
        this.applyButton.field_22763 = false;
        long currentValue = this.blockEntityInterface.getAnimalDisplaySize();
        long maxValue = this.blockEntityInterface.getAnimalCount();
        if (currentValue < 1L) {
            currentValue = 1L;
        }
        if (currentValue > maxValue && maxValue != 0L) {
            currentValue = maxValue;
        }
        this.sliderBarPos = this.leftPos + 89;
        class_4185.class_7840 class_78402 = class_4185.method_46430((class_2561)class_2561.method_43473(), button -> {}).method_46433(this.sliderBarPos, this.topPos + 112);
        Objects.requireNonNull(this);
        this.sliderButton = (class_4185)this.method_25429((class_364)class_78402.method_46437(Math.max(6, (int)(64L / maxValue)), 12).method_46431());
        this.sliderButton.field_22763 = maxValue > 1L;
        this.sliderButton.field_22764 = this.blockEntityInterface.canGrowEntity() && maxValue > 1L;
        int initialX = this.calculateSizeBarOffset(currentValue);
        this.sliderButton.method_46421(this.sliderBarPos + initialX);
        class_2487 defaultAnimal = new class_2487();
        this.blockEntityInterface.getStoredAnimal().method_5662(defaultAnimal);
        class_1299.method_5892((class_2487)defaultAnimal, (class_1937)this.field_22787.field_1687, (class_3730)class_3730.field_16461).map(entity -> (class_1309)entity).ifPresent(entity -> {
            this.displayEntity = entity;
            float width = this.displayEntity.method_17681();
            float height = this.displayEntity.method_17682();
            float entitySize = Math.max(1.0f, Math.max(width, height));
            this.entityScale = 60.0f / entitySize * 0.8f;
            this.entityOffset = Math.max(height, entitySize) * 0.5f;
        });
        this.cooldownButton = (class_4185)this.method_25429((class_364)class_4185.method_46430((class_2561)class_2561.method_43473(), this::handleCooldownButton).method_46433(this.leftPos - 12, this.topPos + (this.imageHeight - 18) / 2).method_46437(11, 18).method_46431());
    }

    public class_2338 getPosition() {
        return this.position;
    }

    public void update() {
        this.needsUpdate = 5;
    }

    public void method_25393() {
        super.method_25393();
        if (this.displayEntity != null) {
            ++this.displayEntity.field_6012;
        }
        if (!(this.field_22787.field_1687.method_8321(this.position) instanceof AnimalPenBlockInterface) || this.blockEntityInterface.getStoredAnimal() == null) {
            this.field_22787.method_1507(null);
            return;
        }
        if (this.needsUpdate > 0 && --this.needsUpdate == 0) {
            this.method_25426();
        }
    }

    public boolean method_25421() {
        return false;
    }

    private int calculateSizeBarOffset(long value) {
        if (this.blockEntityInterface.getAnimalCount() <= 1L) {
            return 0;
        }
        float percentage = (float)(value - 1L) / (float)(this.blockEntityInterface.getAnimalCount() - 1L);
        return Math.round(percentage * (float)(this.sliderAreaWidth - this.sliderButton.method_25368()));
    }

    private long calculateSizeFromPosition(int scrollX) {
        float percentage = (float)(scrollX - this.sliderBarPos) / (float)(this.sliderAreaWidth - this.sliderButton.method_25368());
        long maxValue = this.blockEntityInterface.getAnimalCount();
        return 1 + Math.round(percentage * (float)(maxValue - 1L));
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics, mouseX, mouseY, partialTicks);
        this.updateButtonPositions();
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        int n = this.leftPos + 88 - this.field_22793.method_27525((class_5348)this.field_22785) / 2;
        Objects.requireNonNull(this.field_22793);
        graphics.method_51439(this.field_22793, this.field_22785, n, this.topPos + 3 + 7 - 9 / 2, 0x404040, false);
        this.renderVariantButtons(graphics, mouseX, mouseY, partialTicks);
        this.renderOtherButtons(graphics, mouseX, mouseY);
        this.renderScrollBar(graphics, mouseX, mouseY);
        this.renderSizeBar(graphics, mouseX, mouseY, partialTicks);
        this.renderEntity(graphics, partialTicks);
        this.renderCooldown(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltips(graphics, mouseX, mouseY, partialTicks);
    }

    public void method_57735(class_332 graphics) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int offsetX = this.leftPos;
        int offsetY = this.topPos;
        graphics.method_25290(class_1921::method_62277, TEXTURE, offsetX, offsetY, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    private void renderVariantButtons(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_44379(10, this.bodyTopPos, this.field_22789 - 10, this.bodyTopPos + this.buttonAreaHeight);
        for (int i = 0; i < this.buttons.size(); ++i) {
            class_4185 button = this.buttons.get(i);
            button.method_25394(graphics, mouseX, mouseY, partialTicks);
            if (i != this.selectedButton) continue;
            this.renderButtonBorder(graphics, button, -2147418368);
        }
        graphics.method_44380();
    }

    private void renderButtonBorder(class_332 graphics, class_4185 button, int color) {
        int width = button.method_25368();
        int height = button.method_25364();
        graphics.method_25294(button.method_46426(), button.method_46427(), button.method_46426() + width, button.method_46427() + 1, color);
        graphics.method_25294(button.method_46426(), button.method_46427() + height - 1, button.method_46426() + width, button.method_46427() + height, color);
        graphics.method_25294(button.method_46426(), button.method_46427(), button.method_46426() + 1, button.method_46427() + height, color);
        graphics.method_25294(button.method_46426() + width - 1, button.method_46427(), button.method_46426() + width, button.method_46427() + height, color);
    }

    private void renderOtherButtons(@NotNull class_332 graphics, int mouseX, int mouseY) {
        graphics.method_25290(class_1921::method_62277, TEXTURE, this.deleteButton.method_46426() + 1, this.deleteButton.method_46427() + 1, (float)(176 + (this.selectedButton != -1 ? 0 : 9)), 39.0f, 9, 12, 256, 256);
        graphics.method_25290(class_1921::method_62277, TEXTURE, this.applyButton.method_46426() + 1, this.applyButton.method_46427() + 1, (float)(176 + (this.selectedButton != -1 ? 0 : 12)), 51.0f, 12, 12, 256, 256);
    }

    private void renderScrollBar(@NotNull class_332 graphics, int mouseX, int mouseY) {
        int scrollThumbHeight = 15;
        int scrollPosition = this.needsScrollBars() ? this.bodyTopPos + (int)((float)(this.buttonAreaHeight - scrollThumbHeight) * this.currentVariantScroll) : this.bodyTopPos;
        graphics.method_25290(class_1921::method_62277, TEXTURE, this.leftPos + 9, scrollPosition, (float)(176 + (this.needsScrollBars() ? 0 : 12)), 0.0f, 12, scrollThumbHeight, 256, 256);
    }

    private void renderSizeBar(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int n;
        this.sliderButton.method_25394(graphics, mouseX, mouseY, partialTicks);
        class_5250 text = this.blockEntityInterface.canGrowEntity() ? class_2561.method_43469((String)SIZE_TEXT, (Object[])new Object[]{this.blockEntityInterface.getAnimalDisplaySize(), this.blockEntityInterface.getAnimalCount()}) : class_2561.method_43469((String)FIXED_TEXT, (Object[])new Object[]{this.blockEntityInterface.getAnimalCount()});
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        float textWidth = this.field_22793.method_27525((class_5348)text);
        Objects.requireNonNull(this);
        float scale = Math.min(1.0f, 64.0f / textWidth);
        float f = this.sliderBarPos;
        float f2 = this.topPos + 112 + 7;
        Objects.requireNonNull(this.field_22793);
        poseStack.method_46416(f, f2 - 9.0f * scale / 2.0f, 0.0f);
        poseStack.method_22905(scale, scale, 1.0f);
        if (scale < 1.0f) {
            n = 0;
        } else {
            Objects.requireNonNull(this);
            n = (int)(64.0f - textWidth) / 2;
        }
        graphics.method_27535(this.field_22793, (class_2561)text, n, 0, 0xFFFFFF);
        poseStack.method_22909();
    }

    private void renderEntity(@NotNull class_332 graphics, float partialTicks) {
        float x = this.leftPos + 73 + 48;
        float y = this.bodyTopPos + 46;
        this.displayEntity.field_6283 = 0.0f;
        this.displayEntity.method_36456(0.0f);
        this.displayEntity.field_6241 = 0.0f;
        this.displayEntity.field_6259 = 0.0f;
        class_1309 class_13092 = this.displayEntity;
        if (class_13092 instanceof class_1480) {
            class_1480 animal = (class_1480)class_13092;
            animal.method_18380(class_4050.field_18079);
            animal.method_5796(true);
            ((EntityAccessor)animal).setWasTouchingWater(true);
            y -= 10.0f;
        }
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(x, y, 50.0f);
        poseStack.method_22905(this.entityScale, this.entityScale, this.entityScale);
        poseStack.method_46416(0.0f, this.entityOffset, 0.0f);
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(this.entityRotation));
        class_898 erd = class_310.method_1551().method_1561();
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        erd.method_3948(false);
        erd.method_62424((class_1297)this.displayEntity, 0.0, 0.0, 0.0, partialTicks, poseStack, (class_4597)immediate, 0xF000F0);
        erd.method_3948(true);
        immediate.method_22993();
        poseStack.method_22909();
    }

    private void renderCooldown(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderTexture((int)0, (class_2960)COOLDOWN_TEXTURE);
        graphics.method_25290(class_1921::method_62277, COOLDOWN_TEXTURE, this.leftPos - 12, this.topPos + (this.imageHeight - 18) / 2, (float)(149 + (this.isCooldownOpened ? 0 : 11)), (float)(this.cooldownButton.method_25405((double)mouseX, (double)mouseY) ? 18 : 1), 11, 18, 256, 256);
        if (this.isCooldownOpened) {
            graphics.method_25290(class_1921::method_62277, COOLDOWN_TEXTURE, this.leftPos - 12 - this.cooldownWidth, this.topPos, 0.0f, 1.0f, this.cooldownWidth, this.imageHeight + 1, 256, 256);
            List<Pair<class_1799[], class_2561>> textList = this.blockEntityInterface.getCooldownLines(false);
            if (!textList.isEmpty()) {
                int leftOffset = this.leftPos - this.cooldownWidth;
                Objects.requireNonNull(this.field_22793);
                int top = this.topPos + 9;
                for (int i = 0; i < textList.size(); ++i) {
                    this.renderTextLine(graphics, textList.get(i), leftOffset, top + i * 16, mouseX, mouseY);
                }
            }
        }
    }

    private void renderTextLine(@NotNull class_332 graphics, Pair<class_1799[], class_2561> componentPair, int leftOffset, int y, int mouseX, int mouseY) {
        class_2561 text = (class_2561)componentPair.getRight();
        class_1799 first = ((class_1799[])componentPair.getLeft()).length > 0 ? ((class_1799[])componentPair.getLeft())[0] : null;
        class_1799 second = ((class_1799[])componentPair.getLeft()).length > 1 ? ((class_1799[])componentPair.getLeft())[1] : null;
        ArrayList<Pair> itemPositions = new ArrayList<Pair>();
        int whiteSpace = this.field_22793.method_1727(" ");
        boolean isFirst = true;
        for (class_2561 part : text.method_36136(class_2583.field_24360)) {
            String content = part.getString();
            if (content.equals("\ue000")) {
                if (first == null) continue;
                if (!isFirst) {
                    leftOffset -= whiteSpace;
                }
                graphics.method_51427(first, leftOffset, y);
                itemPositions.add(Pair.of((Object)first, (Object)new class_768(leftOffset, y, 16, 16)));
                leftOffset += 16 - whiteSpace;
            } else if (content.equals("\ue001")) {
                if (second == null) continue;
                if (!isFirst) {
                    leftOffset -= whiteSpace;
                }
                graphics.method_51427(second, leftOffset, y);
                itemPositions.add(Pair.of((Object)second, (Object)new class_768(leftOffset, y, 16, 16)));
                leftOffset += 16 - whiteSpace;
            } else {
                Objects.requireNonNull(this.field_22793);
                graphics.method_27535(this.field_22793, part, leftOffset, y + 9 / 2 + 2, 0xFFFFFF);
                leftOffset += this.field_22793.method_27525((class_5348)part);
            }
            isFirst = false;
        }
        for (Pair itemPos : itemPositions) {
            class_768 rect = (class_768)itemPos.getRight();
            if (mouseX < rect.method_3321() || mouseX > rect.method_3321() + rect.method_3319() || mouseY < rect.method_3322() || mouseY > rect.method_3322() + rect.method_3320()) continue;
            graphics.method_51446(this.field_22793, (class_1799)itemPos.getLeft(), mouseX, mouseY);
            break;
        }
    }

    private void renderTooltips(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.applyButton.method_25405((double)mouseX, (double)mouseY)) {
            graphics.method_51438(this.field_22793, APPLY, mouseX, mouseY);
        }
        if (this.deleteButton.method_25405((double)mouseX, (double)mouseY)) {
            graphics.method_51438(this.field_22793, this.selectedButton != -1 ? DELETE : SELECT_TO_DELETE, mouseX, mouseY);
        }
        if (this.sliderButton.method_25405((double)mouseX, (double)mouseY)) {
            List<class_2561> list = List.of(SLIDER, class_2561.method_43473(), SLIDER_HELPER_DRAG, SLIDER_HELPER_ARROW);
            graphics.method_51434(this.field_22793, list, mouseX, mouseY);
        }
        if (this.cooldownButton.method_25405((double)mouseX, (double)mouseY)) {
            graphics.method_51438(this.field_22793, this.isCooldownOpened ? COOLDOWN_CLOSE : COOLDOWN_OPEN, mouseX, mouseY);
        }
    }

    private boolean needsScrollBars() {
        return this.buttons.size() > 5;
    }

    private void handleDeleteButton(class_4185 button) {
        if (this.selectedButton == -1) {
            return;
        }
        NetworkManager.sendToServer((class_8710)new RemoveDisplayAnimalData(this.position, this.selectedButton));
        this.selectedButton = -1;
        this.applyButton.field_22763 = false;
        this.method_25426();
    }

    private void handleApplyButton(class_4185 button) {
        NetworkManager.sendToServer((class_8710)new UpdateDisplayAnimalData(this.position, this.blockEntityInterface.getEntityVariants().method_10602(this.selectedButton)));
        this.displayEntity.method_5651(this.blockEntityInterface.getEntityVariants().method_10602(this.selectedButton));
        this.selectedButton = -1;
    }

    private void handleVariantButton(class_4185 button, int index) {
        class_2487 tag;
        if (button.method_46427() + button.method_25364() < this.bodyTopPos || button.method_46427() > this.bodyTopPos + this.buttonAreaHeight) {
            return;
        }
        if (this.selectedButton == index) {
            this.selectedButton = -1;
            this.applyButton.field_22763 = false;
        } else {
            this.selectedButton = index;
            boolean bl = this.applyButton.field_22763 = !this.buttons.isEmpty();
        }
        if (this.selectedButton != -1) {
            tag = (class_2487)this.blockEntityInterface.getEntityVariants().method_10534(index);
        } else {
            tag = new class_2487();
            this.blockEntityInterface.getStoredAnimal().method_5662(tag);
        }
        this.displayEntity.method_5651(tag);
        this.currentXOnEntity = 0;
    }

    private void handleCooldownButton(class_4185 button) {
        this.isCooldownOpened = !this.isCooldownOpened;
        this.method_25426();
    }

    private boolean scrollBarClicked(double mouseX, double mouseY) {
        int scrollLeft = this.leftPos + 9;
        int scrollRight = scrollLeft + 12;
        int scrollBottom = this.bodyTopPos + this.buttonAreaHeight;
        return mouseX >= (double)scrollLeft && mouseY >= (double)this.bodyTopPos && mouseX < (double)scrollRight && mouseY < (double)scrollBottom;
    }

    private boolean entityAreaClicked(double mouseX, double mouseY) {
        int left = this.leftPos + 73;
        int top = this.bodyTopPos;
        int right = left + 96;
        int bottom = top + 92;
        return mouseX >= (double)left && mouseX < (double)right && mouseY >= (double)top && mouseY < (double)bottom;
    }

    private boolean sizeBarClicked(double mouseX, double mouseY) {
        return this.sliderButton.method_25405(mouseX, mouseY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.scrollBarClicked(mouseX, mouseY)) {
            this.isScrollingVariants = true;
            this.method_25403(mouseX, mouseY, button, 0.0, 0.0);
            return true;
        }
        if (this.entityAreaClicked(mouseX, mouseY)) {
            this.currentXOnEntity = (int)mouseX;
            this.isSelectingEntity = true;
            return true;
        }
        if (this.sizeBarClicked(mouseX, mouseY)) {
            this.isSelectingSizeBar = true;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.isSelectingEntity = false;
        this.isScrollingVariants = false;
        this.isSelectingSizeBar = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double var, double amount) {
        if (!this.needsScrollBars()) {
            return false;
        }
        this.currentVariantScroll = (float)((double)this.currentVariantScroll - amount / 10.0);
        this.currentVariantScroll = class_3532.method_15363((float)this.currentVariantScroll, (float)0.0f, (float)1.0f);
        this.updateButtonPositions();
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrollingVariants && this.needsScrollBars()) {
            int scrollBottom = this.bodyTopPos + this.buttonAreaHeight;
            this.currentVariantScroll = ((float)mouseY - (float)this.bodyTopPos) / (float)(scrollBottom - this.bodyTopPos);
            this.currentVariantScroll = class_3532.method_15363((float)this.currentVariantScroll, (float)0.0f, (float)1.0f);
            this.updateButtonPositions();
            return true;
        }
        if (this.isSelectingEntity) {
            int deltaX = (int)mouseX - this.currentXOnEntity;
            this.entityRotation -= (float)deltaX;
            while (this.entityRotation < 0.0f) {
                this.entityRotation += 360.0f;
            }
            while (this.entityRotation >= 360.0f) {
                this.entityRotation -= 360.0f;
            }
            this.currentXOnEntity = (int)mouseX;
            return true;
        }
        if (this.isSelectingSizeBar && this.sliderButton.method_37303() && this.blockEntityInterface.canGrowEntity()) {
            int newX = (int)class_3532.method_15350((double)mouseX, (double)this.sliderBarPos, (double)(this.sliderBarPos + this.sliderAreaWidth - this.sliderButton.method_25368()));
            long newValue = this.calculateSizeFromPosition(newX);
            this.blockEntityInterface.setAnimalDisplaySize(newValue);
            NetworkManager.sendToServer((class_8710)new UpdateAnimalSizeData(this.position, newValue));
            int snapPoint = this.calculateSizeBarOffset(newValue);
            this.sliderButton.method_46421(this.sliderBarPos + snapPoint);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if ((keyCode == 263 || keyCode == 262) && this.sliderButton.method_37303() && this.blockEntityInterface.canGrowEntity()) {
            long currentValue = this.blockEntityInterface.getAnimalDisplaySize();
            long maxValue = this.blockEntityInterface.getAnimalCount();
            long newValue = keyCode == 263 ? Math.max(1L, currentValue - 1L) : Math.min(maxValue, currentValue + 1L);
            if (newValue != currentValue) {
                this.sliderButton.method_46421(this.sliderBarPos + this.calculateSizeBarOffset(newValue));
                this.blockEntityInterface.setAnimalDisplaySize(newValue);
                NetworkManager.sendToServer((class_8710)new UpdateAnimalSizeData(this.position, newValue));
                return true;
            }
        } else {
            if ((keyCode == 265 || keyCode == 264) && this.buttons.size() > 1) {
                int button = keyCode == 264 ? Math.min(this.selectedButton + 1, this.buttons.size() - 1) : Math.max(this.selectedButton - 1, 0);
                if (button != this.selectedButton) {
                    this.ensureButtonVisible(button);
                    this.handleVariantButton(this.buttons.get(button), button);
                }
                return true;
            }
            if (keyCode == 257) {
                if (this.selectedButton >= 0 && this.selectedButton < this.buttons.size() && this.applyButton.method_37303()) {
                    this.handleApplyButton(null);
                    return true;
                }
            } else if (keyCode == 261 && this.selectedButton >= 0 && this.selectedButton < this.buttons.size()) {
                this.handleDeleteButton(null);
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        return super.method_16803(keyCode, scanCode, modifiers);
    }

    private void updateButtonPositions() {
        int buttonHeight = 20;
        int totalButtonsHeight = this.buttons.size() * buttonHeight;
        int maxScrollPixels = Math.max(0, totalButtonsHeight - this.buttonAreaHeight);
        int scrollOffset = (int)((float)maxScrollPixels * this.currentVariantScroll);
        for (int i = 0; i < this.buttons.size(); ++i) {
            class_4185 button = this.buttons.get(i);
            button.method_46419(this.bodyTopPos + i * buttonHeight - scrollOffset);
        }
    }

    private void ensureButtonVisible(int buttonIndex) {
        if (buttonIndex < 0 || buttonIndex >= this.buttons.size()) {
            return;
        }
        class_4185 targetButton = this.buttons.get(buttonIndex);
        int buttonTop = targetButton.method_46427();
        int buttonBottom = buttonTop + targetButton.method_25364();
        float areaDifference = this.buttons.size() * targetButton.method_25364() - this.buttonAreaHeight;
        if (buttonTop < this.bodyTopPos) {
            float newScrollPos = (float)(this.bodyTopPos - buttonTop) / areaDifference;
            this.currentVariantScroll = class_3532.method_15363((float)(this.currentVariantScroll - newScrollPos), (float)0.0f, (float)1.0f);
            this.updateButtonPositions();
        } else if (buttonBottom > this.bodyTopPos + this.buttonAreaHeight) {
            float newScrollPos = (float)(buttonBottom - this.bodyTopPos - 106) / areaDifference;
            this.currentVariantScroll = class_3532.method_15363((float)(this.currentVariantScroll + newScrollPos), (float)0.0f, (float)1.0f);
            this.updateButtonPositions();
        }
    }
}

