/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.blocks;

import com.mojang.serialization.MapCodec;
import dev.architectury.hooks.level.entity.PlayerHooks;
import java.util.Objects;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.entities.AnimalPenTileEntity;
import lv.id.bonne.animalpen.registries.AnimalPenTags;
import lv.id.bonne.animalpen.registries.AnimalPenTileEntityRegistry;
import lv.id.bonne.animalpen.registries.AnimalPensItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimalPenBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<AnimalPenBlock> CODEC = AnimalPenBlock.simpleCodec(AnimalPenBlock::new);
    private final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)4.0, (double)0.0, (double)3.0, (double)8.0, (double)3.0), Block.box((double)0.0, (double)4.0, (double)13.0, (double)3.0, (double)8.0, (double)16.0), Block.box((double)13.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)3.0), Block.box((double)13.0, (double)4.0, (double)13.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)3.0, (double)5.0, (double)0.0, (double)13.0, (double)7.0, (double)2.0), Block.box((double)3.0, (double)5.0, (double)14.0, (double)13.0, (double)7.0, (double)16.0), Block.box((double)0.0, (double)5.0, (double)3.0, (double)2.0, (double)7.0, (double)13.0), Block.box((double)14.0, (double)5.0, (double)3.0, (double)16.0, (double)7.0, (double)13.0)});

    public AnimalPenBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected InteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        InteractionResult result = super.useItemOn(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
        if (result == InteractionResult.FAIL || interactionHand != InteractionHand.MAIN_HAND) {
            AnimalPen.sendDebug("Blocked by external forces");
            return InteractionResult.SUCCESS;
        }
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        if (itemInHand.is((Item)AnimalPensItemRegistry.ANIMAL_CAGE.get())) {
            AnimalPenTileEntity entity;
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof AnimalPenTileEntity && (entity = (AnimalPenTileEntity)blockEntity).processContainer(player, interactionHand)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof AnimalPenTileEntity)) {
            return InteractionResult.FAIL;
        }
        AnimalPenTileEntity entity = (AnimalPenTileEntity)blockEntity;
        if (PlayerHooks.isFake((Player)player) && itemInHand.is(AnimalPenTags.ANIMAL_PEN_ATTACK_TOOLS)) {
            this.attack(blockState, level, blockPos, player);
            return InteractionResult.SUCCESS;
        }
        if (entity.interactWithPen(player, interactionHand)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void attack(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        BlockEntity blockEntity;
        ItemStack weapon = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (weapon.is(AnimalPenTags.ANIMAL_PEN_ATTACK_TOOLS) && !level.isClientSide() && (blockEntity = level.getBlockEntity(blockPos)) instanceof AnimalPenTileEntity) {
            AnimalPenTileEntity entity = (AnimalPenTileEntity)blockEntity;
            if (player.getCooldowns().isOnCooldown(weapon)) {
                return;
            }
            entity.attackThePen(player, level);
            if (PlayerHooks.isFake((Player)player)) {
                return;
            }
            int cooldown = AnimalPen.config().getAttackCooldown();
            if (cooldown > 0) {
                player.getCooldowns().addCooldown(weapon, cooldown);
            }
            return;
        }
        super.attack(blockState, level, blockPos, player);
    }

    public float getDestroyProgress(BlockState blockState, Player player, BlockGetter blockGetter, BlockPos blockPos) {
        ItemStack weapon = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (weapon.is(AnimalPenTags.ANIMAL_PEN_ATTACK_TOOLS)) {
            return 0.0f;
        }
        return super.getDestroyProgress(blockState, player, blockGetter, blockPos);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level world, BlockPos pos) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof AnimalPenTileEntity) {
            AnimalPenTileEntity animalPen = (AnimalPenTileEntity)tile;
            return animalPen.getRedStoneSignal();
        }
        return 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return (BlockState)Objects.requireNonNull(super.getStateForPlacement(context)).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return ((BlockEntityType)AnimalPenTileEntityRegistry.ANIMAL_PEN_TILE_ENTITY.get()).create(blockPos, blockState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return AnimalPenBlock.createTickerHelper(type, (BlockEntityType)AnimalPenTileEntityRegistry.ANIMAL_PEN_TILE_ENTITY.get(), (world, pos, blockState, tileEntity) -> tileEntity.tick());
    }

    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> type, BlockEntityType<E> expectedType, BlockEntityTicker<? super E> ticker) {
        return type == expectedType ? ticker : null;
    }

    @Nullable
    public <T extends BlockEntity> GameEventListener getListener(ServerLevel level, T blockEntity) {
        return super.getListener(level, blockEntity);
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }
}

