/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.animal;

import java.time.LocalTime;
import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.interfaces.AnimalPenInterface;
import lv.id.bonne.animalpen.mixin.animal.AnimalPenAnimal;
import lv.id.bonne.animalpen.registries.AnimalPenTags;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Bee.class})
public abstract class AnimalPenBee
extends AnimalPenAnimal {
    @Unique
    private int animalPen$pollenCooldown;
    @Unique
    private int animalPen$pollenCount = -1;

    protected AnimalPenBee(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenTick(BlockEntity blockEntity) {
        boolean value = super.animalPen$animalPenTick(blockEntity);
        if (this.animalPen$pollenCooldown > 0) {
            --this.animalPen$pollenCooldown;
            return true;
        }
        if (this.animalPen$pollenCount < 5) {
            ++this.animalPen$pollenCount;
            if (this.animalPen$pollenCount != 5) {
                this.animalPen$pollenCooldown = AnimalPen.config().getEntityCooldown(this.getType(), Items.HONEY_BLOCK, this.animalPen$animalCount);
            }
            return true;
        }
        return value;
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenSaveTag(ValueOutput tag) {
        super.animalPen$animalPenSaveTag(tag);
        tag.putInt("pollen_cooldown", this.animalPen$pollenCooldown);
        tag.putInt("pollen_count", this.animalPen$pollenCount);
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenLoadTag(ValueInput tag) {
        super.animalPen$animalPenLoadTag(tag);
        this.animalPen$pollenCooldown = tag.getIntOr("pollen_cooldown", 0);
        this.animalPen$pollenCount = tag.getIntOr("pollen_count", 0);
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenInteract(Player player, InteractionHand hand, BlockPos position) {
        if (super.animalPen$animalPenInteract(player, hand, position)) {
            return true;
        }
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(Items.SHEARS) || itemStack.is(AnimalPenTags.COMMON_SHEARS)) {
            if (this.animalPen$pollenCount < 5) {
                AnimalPen.sendDebug("Less than 5 pollen");
                return false;
            }
            if (player.level().isClientSide()) {
                return true;
            }
            AnimalPenInterface.triggerItemUse((Entity)this, (ServerPlayer)player, itemStack, 1);
            itemStack.hurtAndBreak(1, (LivingEntity)player, AnimalPenBee.getSlotForHand((InteractionHand)hand));
            Block.popResource((Level)player.level(), (BlockPos)position.above(), (ItemStack)new ItemStack((ItemLike)Items.HONEYCOMB, 3));
            player.level().playSound(null, position, SoundEvents.BEEHIVE_SHEAR, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$pollenCount = 0;
            this.animalPen$pollenCooldown = AnimalPen.config().getEntityCooldown(this.getType(), Items.HONEY_BLOCK, this.animalPen$animalCount);
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.getItem().arch$registryName()));
            return true;
        }
        if (itemStack.is(Items.GLASS_BOTTLE)) {
            if (this.animalPen$pollenCount < 5) {
                AnimalPen.sendDebug("Less than 5 pollen");
                return false;
            }
            if (player.level().isClientSide()) {
                return true;
            }
            AnimalPenInterface.triggerItemUse((Entity)this, (ServerPlayer)player, itemStack, 1);
            ItemStack remainingStack = ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)Items.HONEY_BOTTLE.getDefaultInstance());
            player.setItemInHand(hand, remainingStack);
            player.level().playSound(null, position, SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$pollenCount = 0;
            this.animalPen$pollenCooldown = AnimalPen.config().getEntityCooldown(this.getType(), Items.HONEY_BLOCK, this.animalPen$animalCount);
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.getItem().arch$registryName()));
            return true;
        }
        return false;
    }

    @Override
    @Intrinsic
    public ItemStack animalPen$animalPenInteract(ServerLevel level, ItemStack itemStack, BlockPos position) {
        if (this.animalPen$pollenCount < 5) {
            AnimalPen.sendDebug("Less than 5 pollen");
            return ItemStack.EMPTY;
        }
        if (itemStack.is(Items.SHEARS) || itemStack.is(AnimalPenTags.COMMON_SHEARS)) {
            itemStack.hurtAndBreak(1, level, null, item -> {});
            Block.popResource((Level)level, (BlockPos)position.above(), (ItemStack)new ItemStack((ItemLike)Items.HONEYCOMB, 3));
            level.playSound(null, position, SoundEvents.BEEHIVE_SHEAR, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$pollenCount = 0;
            this.animalPen$pollenCooldown = AnimalPen.config().getEntityCooldown(this.getType(), Items.HONEY_BLOCK, this.animalPen$animalCount);
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.getItem().arch$registryName()));
            return ItemStack.EMPTY;
        }
        if (itemStack.is(Items.GLASS_BOTTLE)) {
            itemStack.shrink(1);
            level.playSound(null, position, SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$pollenCount = 0;
            this.animalPen$pollenCooldown = AnimalPen.config().getEntityCooldown(this.getType(), Items.HONEY_BLOCK, this.animalPen$animalCount);
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.getItem().arch$registryName()));
            return new ItemStack((ItemLike)Items.HONEY_BOTTLE);
        }
        return super.animalPen$animalPenInteract(level, itemStack, position);
    }

    @Override
    @Intrinsic
    public List<Pair<ItemStack[], Component>> animalPen$animalPenGetLines(int tick, boolean shortLine) {
        MutableComponent component;
        List<Pair<ItemStack[], Component>> lines = super.animalPen$animalPenGetLines(tick, shortLine);
        if (shortLine && AnimalPen.config().getEntityCooldown(this.getType(), Items.HONEY_BLOCK, this.animalPen$animalCount) == 0) {
            return lines;
        }
        if (this.animalPen$pollenCooldown != 0) {
            component = Component.translatable((String)(shortLine ? "display.animal_pen.cooldown" : "display.animal_pen.pollen_cooldown"), (Object[])new Object[]{Component.literal((String)"\ue000"), Component.literal((String)"\ue001"), LocalTime.of(0, 0, 0).plusSeconds(this.animalPen$pollenCooldown / 20).format(AnimalPen.DATE_FORMATTER)});
            lines.add((Pair<ItemStack[], Component>)Pair.of((Object)new ItemStack[]{Items.HONEY_BLOCK.getDefaultInstance(), Items.HONEY_BLOCK.getDefaultInstance()}, (Object)component));
        }
        if (this.animalPen$pollenCount == 5) {
            ItemStack resultStack;
            ItemStack toolStack;
            component = Component.translatable((String)"display.animal_pen.pollen_level_max", (Object[])new Object[]{Component.literal((String)"\ue000"), this.animalPen$pollenCount});
            lines.add((Pair<ItemStack[], Component>)Pair.of((Object)new ItemStack[]{Items.HONEY_BLOCK.getDefaultInstance()}, (Object)component));
            component = Component.translatable((String)(shortLine ? "display.animal_pen.ready" : "display.animal_pen.full_ready"), (Object[])new Object[]{Component.literal((String)"\ue000"), Component.literal((String)"\ue001")});
            if (tick / 100 % 2 == 0) {
                toolStack = Items.SHEARS.getDefaultInstance();
                resultStack = Items.HONEYCOMB.getDefaultInstance();
            } else {
                toolStack = Items.GLASS_BOTTLE.getDefaultInstance();
                resultStack = Items.HONEY_BOTTLE.getDefaultInstance();
            }
            lines.add((Pair<ItemStack[], Component>)Pair.of((Object)new ItemStack[]{toolStack, resultStack}, (Object)component));
        } else {
            component = Component.translatable((String)"display.animal_pen.pollen_level", (Object[])new Object[]{Component.literal((String)"\ue000"), this.animalPen$pollenCount});
            lines.add((Pair<ItemStack[], Component>)Pair.of((Object)new ItemStack[]{Items.HONEY_BLOCK.getDefaultInstance()}, (Object)component));
        }
        return lines;
    }

    @Override
    @Intrinsic
    public int animalPen$getRedStoneSignal() {
        if (this.animalPen$pollenCount < 5) {
            return super.animalPen$getRedStoneSignal();
        }
        return super.animalPen$getRedStoneSignal() | 4;
    }
}

