/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.animal;

import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.mixin.animal.AnimalPenAnimal;
import lv.id.bonne.animalpen.registries.AnimalPenFoodRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Axolotl.class})
public abstract class AnimalPenAxolotl
extends AnimalPenAnimal {
    @Unique
    private int animalPen$storedFood = 0;

    protected AnimalPenAxolotl(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenSaveTag(CompoundTag tag) {
        super.animalPen$animalPenSaveTag(tag);
        tag.putInt("stored_food", this.animalPen$storedFood);
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenLoadTag(CompoundTag tag) {
        super.animalPen$animalPenLoadTag(tag);
        this.animalPen$storedFood = tag.getInt("stored_food");
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenInteract(Player player, InteractionHand hand, BlockPos position) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (AnimalPenFoodRegistry.isFood(this.getType().arch$registryName(), itemStack)) {
            if (player.level().isClientSide()) {
                return true;
            }
            ++this.animalPen$storedFood;
            if (!player.getAbilities().instabuild) {
                player.setItemInHand(hand, new ItemStack((ItemLike)Items.WATER_BUCKET));
            }
            if (this.animalPen$foodCooldown > 0 || this.animalPen$storedFood < 2) {
                return false;
            }
            long maxCount = AnimalPen.CONFIG_MANAGER.getConfiguration().getMaximalAnimalCount();
            if (maxCount > 0L && this.animalPen$animalCount >= maxCount) {
                return false;
            }
            int stackSize = (int)Math.min(this.animalPen$animalCount, (long)this.animalPen$storedFood);
            if (stackSize < 2) {
                return false;
            }
            stackSize = (int)Math.min((maxCount - this.animalPen$animalCount) * 2L, (long)stackSize);
            this.animalPen$animalCount += (long)(stackSize / 2);
            this.animalPen$storedFood -= stackSize;
            Level level = player.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.HEART, (double)((float)position.getX() + 0.5f), (double)position.getY() + 1.5, (double)((float)position.getZ() + 0.5f), 5, 0.2, 0.2, 0.2, 0.05);
            }
            player.level().playSound(null, position, (SoundEvent)SoundEvents.GENERIC_EAT.value(), SoundSource.NEUTRAL, 1.0f, Mth.randomBetween((RandomSource)player.level().random, (float)0.8f, (float)1.2f));
            SoundEvent soundEvent = this.getAmbientSound();
            if (soundEvent != null) {
                player.level().playSound(null, position, soundEvent, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            this.animalPen$foodCooldown = AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.getType(), Items.APPLE, stackSize);
            return true;
        }
        return false;
    }

    @Override
    @Intrinsic
    public List<Pair<ItemStack, Component>> animalPen$animalPenGetLines(int tick) {
        ItemStack foodItem;
        List<Pair<ItemStack, Component>> lines = super.animalPen$animalPenGetLines(tick);
        if (AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.getType(), Items.APPLE, this.animalPen$animalCount) == 0) {
            return lines;
        }
        MutableComponent component = Component.translatable((String)"display.animal_pen.stored_food", (Object[])new Object[]{this.animalPen$storedFood});
        ItemStack[] food = this.animalPen$getFood();
        if (food == null || food.length == 0) {
            return lines;
        }
        if (food.length == 1) {
            foodItem = food[0];
        } else {
            int size = food.length;
            int index = tick / 100 % size;
            foodItem = food[index];
        }
        lines.add((Pair<ItemStack, Component>)Pair.of((Object)foodItem, (Object)component));
        return lines;
    }
}

