/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.animal;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.mixin.animal.AnimalPenAnimal;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Sniffer.class})
public abstract class AnimalPenSniffer
extends AnimalPenAnimal {
    @Unique
    private int animalPen$sniffingCooldown;
    @Unique
    private int animalPen$eggCooldown;

    protected AnimalPenSniffer(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenTick(BlockEntity blockEntity) {
        boolean value = super.animalPen$animalPenTick(blockEntity);
        if (this.animalPen$sniffingCooldown > 0) {
            --this.animalPen$sniffingCooldown;
            value = true;
        }
        if (this.animalPen$eggCooldown > 0) {
            --this.animalPen$eggCooldown;
            return true;
        }
        return value;
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenSaveTag(CompoundTag tag) {
        super.animalPen$animalPenSaveTag(tag);
        tag.putInt("egg_cooldown", this.animalPen$eggCooldown);
        tag.putInt("sniff_cooldown", this.animalPen$sniffingCooldown);
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenLoadTag(CompoundTag tag) {
        super.animalPen$animalPenLoadTag(tag);
        this.animalPen$sniffingCooldown = tag.getInt("sniff_cooldown");
        this.animalPen$eggCooldown = tag.getInt("egg_cooldown");
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenInteract(Player player, InteractionHand hand, BlockPos position) {
        if (super.animalPen$animalPenInteract(player, hand, position)) {
            return true;
        }
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is(Items.BOWL)) {
            ObjectArrayList randomItems;
            if (this.animalPen$sniffingCooldown > 0) {
                return false;
            }
            Level level = player.level();
            if (!(level instanceof ServerLevel)) {
                return true;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.SNIFFER_DIGGING);
            LootParams lootParams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)position.getCenter()).withParameter(LootContextParams.THIS_ENTITY, (Object)this).create(LootContextParamSets.GIFT);
            int dropLimits = AnimalPen.CONFIG_MANAGER.getConfiguration().getDropLimits(Items.TORCHFLOWER_SEEDS);
            if (dropLimits <= 0) {
                dropLimits = Integer.MAX_VALUE;
            }
            ArrayList itemStackList = new ArrayList();
            for (int seedCount = (int)Math.min(this.animalPen$animalCount, (long)dropLimits); seedCount > 0 && !(randomItems = lootTable.getRandomItems(lootParams)).isEmpty(); seedCount -= randomItems.stream().mapToInt(ItemStack::getCount).sum()) {
                randomItems.forEach(item -> {
                    boolean added = false;
                    for (ItemStack stack : itemStackList) {
                        if (!ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)stack) || stack.getCount() >= stack.getMaxStackSize()) continue;
                        stack.grow(item.getCount());
                        added = true;
                        break;
                    }
                    if (!added) {
                        itemStackList.add(item);
                    }
                });
            }
            itemStackList.forEach(seedStack -> Block.popResource((Level)player.level(), (BlockPos)position.above(), (ItemStack)seedStack));
            serverLevel.playSound(null, position, SoundEvents.SNIFFER_DROP_SEED, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$sniffingCooldown = AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.getType(), Items.BOWL, this.animalPen$animalCount);
            return true;
        }
        if (itemStack.is(Items.BUCKET)) {
            if (this.animalPen$eggCooldown > 0) {
                return false;
            }
            if (player.level().isClientSide()) {
                return true;
            }
            int dropLimits = AnimalPen.CONFIG_MANAGER.getConfiguration().getDropLimits(Items.SNIFFER_EGG);
            if (dropLimits <= 0) {
                dropLimits = Integer.MAX_VALUE;
            }
            int eggCount = (int)Math.min(this.animalPen$animalCount, (long)dropLimits);
            while (eggCount > 0) {
                ItemStack eggStack = new ItemStack((ItemLike)Items.SNIFFER_EGG);
                if (eggCount > 64) {
                    eggStack.setCount(64);
                    eggCount -= 64;
                } else {
                    eggStack.setCount(eggCount);
                    eggCount = 0;
                }
                Block.popResource((Level)player.level(), (BlockPos)position.above(), (ItemStack)eggStack);
            }
            player.level().playSound(null, position, SoundEvents.SNIFFER_EGG_PLOP, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$eggCooldown = AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.getType(), Items.BUCKET, this.animalPen$animalCount);
            return true;
        }
        return false;
    }

    @Override
    @Intrinsic
    public List<Pair<ItemStack, Component>> animalPen$animalPenGetLines(int tick) {
        MutableComponent component;
        List<Pair<ItemStack, Component>> lines = super.animalPen$animalPenGetLines(tick);
        if (AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.getType(), Items.BOWL, this.animalPen$animalCount) != 0) {
            component = this.animalPen$sniffingCooldown == 0 ? Component.translatable((String)"display.animal_pen.sniff_ready").withStyle(ChatFormatting.GREEN) : Component.translatable((String)"display.animal_pen.sniff_cooldown", (Object[])new Object[]{LocalTime.of(0, 0, 0).plusSeconds(this.animalPen$sniffingCooldown / 20).format(AnimalPen.DATE_FORMATTER)});
            List<ItemStack> food = List.of(Items.TORCHFLOWER_SEEDS.getDefaultInstance(), Items.PITCHER_POD.getDefaultInstance());
            int size = food.size();
            int index = tick / 100 % size;
            ItemStack foodItem = food.get(index);
            lines.add((Pair<ItemStack, Component>)Pair.of((Object)foodItem, (Object)component));
        }
        if (AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.getType(), Items.BUCKET, this.animalPen$animalCount) == 0) {
            return lines;
        }
        component = this.animalPen$eggCooldown == 0 ? Component.translatable((String)"display.animal_pen.egg_ready").withStyle(ChatFormatting.GREEN) : Component.translatable((String)"display.animal_pen.egg_cooldown", (Object[])new Object[]{LocalTime.of(0, 0, 0).plusSeconds(this.animalPen$eggCooldown / 20).format(AnimalPen.DATE_FORMATTER)});
        lines.add((Pair<ItemStack, Component>)Pair.of((Object)Items.EGG.getDefaultInstance(), (Object)component));
        return lines;
    }
}

