/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.animal;

import java.time.LocalTime;
import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.mixin.animal.AnimalPenAnimal;
import lv.id.bonne.animalpen.registries.AnimalPenFoodRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Turtle.class})
public abstract class AnimalPenTurtle
extends AnimalPenAnimal {
    @Unique
    private int animalPen$eggCooldown;
    @Unique
    private int animalPen$scuteCount;

    protected AnimalPenTurtle(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenTick(BlockEntity blockEntity) {
        this.animalPen$processScute(blockEntity.m_58904_(), blockEntity.m_58899_());
        boolean value = super.animalPen$animalPenTick(blockEntity);
        if (this.animalPen$eggCooldown > 0) {
            --this.animalPen$eggCooldown;
            return true;
        }
        return value;
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenSaveTag(CompoundTag tag) {
        super.animalPen$animalPenSaveTag(tag);
        tag.m_128405_("egg_cooldown", this.animalPen$eggCooldown);
        tag.m_128405_("scute_count", this.animalPen$scuteCount);
    }

    @Override
    @Intrinsic
    public void animalPen$animalPenLoadTag(CompoundTag tag) {
        super.animalPen$animalPenLoadTag(tag);
        this.animalPen$eggCooldown = tag.m_128451_("egg_cooldown");
        this.animalPen$scuteCount = tag.m_128451_("scute_count");
    }

    @Override
    @Intrinsic
    public boolean animalPen$animalPenInteract(Player player, InteractionHand hand, BlockPos position) {
        this.animal$preProcesScute(player, hand, position);
        if (super.animalPen$animalPenInteract(player, hand, position)) {
            return true;
        }
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_42446_)) {
            if (this.animalPen$eggCooldown > 0) {
                return false;
            }
            if (player.m_9236_().m_5776_()) {
                return true;
            }
            int dropLimits = AnimalPen.CONFIG_MANAGER.getConfiguration().getDropLimits(Items.f_42279_);
            if (dropLimits <= 0) {
                dropLimits = Integer.MAX_VALUE;
            }
            int eggCount = (int)Math.min(this.animalPen$animalCount, (long)dropLimits);
            while (eggCount > 0) {
                ItemStack eggStack = new ItemStack((ItemLike)Items.f_42279_);
                if (eggCount > 64) {
                    eggStack.m_41764_(64);
                    eggCount -= 64;
                } else {
                    eggStack.m_41764_(eggCount);
                    eggCount = 0;
                }
                Block.m_49840_((Level)player.m_9236_(), (BlockPos)position.m_7494_(), (ItemStack)eggStack);
            }
            player.m_9236_().m_5594_(null, position, SoundEvents.f_12486_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$eggCooldown = AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.m_6095_(), Items.f_42446_, this.animalPen$animalCount);
            return true;
        }
        return false;
    }

    @Unique
    private void animalPen$processScute(Level level, BlockPos position) {
        if (this.animalPen$scuteCount <= 0) {
            return;
        }
        if (level.m_5776_()) {
            return;
        }
        boolean dropScuteAtStart = AnimalPen.CONFIG_MANAGER.getConfiguration().isDropScuteAtStart();
        if (!dropScuteAtStart && this.animalPen$foodCooldown != 0) {
            return;
        }
        int dropLimits = AnimalPen.CONFIG_MANAGER.getConfiguration().getDropLimits(Items.f_42355_);
        if (dropLimits <= 0) {
            dropLimits = Integer.MAX_VALUE;
        }
        int scuteCount = Math.min(this.animalPen$scuteCount, dropLimits);
        while (scuteCount > 0) {
            ItemStack scuteStack = new ItemStack((ItemLike)Items.f_42355_);
            if (scuteCount > 64) {
                scuteStack.m_41764_(64);
                scuteCount -= 64;
            } else {
                scuteStack.m_41764_(scuteCount);
                scuteCount = 0;
            }
            Block.m_49840_((Level)level, (BlockPos)position.m_7494_(), (ItemStack)scuteStack);
        }
        level.m_5594_(null, position, SoundEvents.f_12488_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        this.animalPen$scuteCount = 0;
    }

    @Unique
    private void animal$preProcesScute(Player player, InteractionHand hand, BlockPos position) {
        ItemStack itemStack = player.m_21120_(hand);
        if (AnimalPenFoodRegistry.isFood(this.m_6095_().arch$registryName(), itemStack)) {
            if (this.animalPen$foodCooldown > 0) {
                return;
            }
            long maxCount = AnimalPen.CONFIG_MANAGER.getConfiguration().getMaximalAnimalCount();
            if (maxCount > 0L && this.animalPen$animalCount >= maxCount) {
                return;
            }
            int stackSize = itemStack.m_41613_();
            if ((stackSize = (int)Math.min(this.animalPen$animalCount, (long)stackSize)) < 2) {
                return;
            }
            if (player.m_9236_().m_5776_()) {
                return;
            }
            stackSize = (int)Math.min((maxCount - this.animalPen$animalCount) * 2L, (long)stackSize);
            this.animalPen$scuteCount += stackSize / 2;
        }
    }

    @Override
    @Intrinsic
    public List<Pair<ItemStack, Component>> animalPen$animalPenGetLines(int tick) {
        List<Pair<ItemStack, Component>> lines = super.animalPen$animalPenGetLines(tick);
        if (AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.m_6095_(), Items.f_42446_, this.animalPen$animalCount) == 0) {
            return lines;
        }
        MutableComponent component = this.animalPen$eggCooldown == 0 ? Component.m_237115_((String)"display.animal_pen.egg_ready").m_130940_(ChatFormatting.GREEN) : Component.m_237110_((String)"display.animal_pen.egg_cooldown", (Object[])new Object[]{LocalTime.of(0, 0, 0).plusSeconds(this.animalPen$eggCooldown / 20).format(AnimalPen.DATE_FORMATTER)});
        lines.add((Pair<ItemStack, Component>)Pair.of((Object)Items.f_42279_.m_7968_(), (Object)component));
        return lines;
    }
}

