/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.registries;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import lv.id.bonne.animalpen.blocks.AnimalPenBlock;
import lv.id.bonne.animalpen.blocks.AquariumBlock;
import lv.id.bonne.animalpen.registries.AnimalPensCreativeTabRegistry;
import lv.id.bonne.animalpen.registries.AnimalPensItemRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;

public class AnimalPenBlockRegistry {
    public static final DeferredRegister<Block> REGISTRY = DeferredRegister.create((String)"animal_pen", (ResourceKey)Registry.f_122901_);
    public static final Map<WoodType, RegistrySupplier<Block>> ANIMAL_PENS = new HashMap<WoodType, RegistrySupplier<Block>>();
    public static final RegistrySupplier<Block> AQUARIUM = AnimalPenBlockRegistry.registerBlock("aquarium_block", () -> new AquariumBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_60978_(1.0f).m_60918_(SoundType.f_56744_).m_60955_()));

    public static void register() {
        REGISTRY.register();
    }

    private static <T extends Block> RegistrySupplier<T> registerBlock(String name, Supplier<T> block) {
        RegistrySupplier toReturn = REGISTRY.register(name, block);
        AnimalPenBlockRegistry.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistrySupplier<Item> registerBlockItem(String name, RegistrySupplier<T> block) {
        return AnimalPensItemRegistry.REGISTRY.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(AnimalPensCreativeTabRegistry.ANIMAL_PEN_TAB)));
    }

    static {
        WoodType.m_61843_().forEach(woodType -> {
            String woodName = woodType.m_61846_().toLowerCase();
            if (woodType.m_61846_().contains(":")) {
                woodName = woodName.replaceAll(":", "_");
            }
            RegistrySupplier<Block> block = AnimalPenBlockRegistry.registerBlock("animal_pen_" + woodName, () -> new AnimalPenBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_).m_60978_(1.0f).m_60918_(SoundType.f_56736_).m_60955_()));
            ANIMAL_PENS.put((WoodType)woodType, block);
        });
    }
}

