/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.blocks.entities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.entities.AnimalPenBlockInterface;
import lv.id.bonne.animalpen.interfaces.AnimalPenInterface;
import lv.id.bonne.animalpen.items.AnimalCageItem;
import lv.id.bonne.animalpen.registries.AnimalPenDataComponentRegistry;
import lv.id.bonne.animalpen.registries.AnimalPenTileEntityRegistry;
import lv.id.bonne.animalpen.registries.AnimalPensItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimalPenTileEntity
extends BlockEntity
implements AnimalPenBlockInterface<Animal> {
    private final SimpleContainer inventory = new SimpleContainer(1){

        public boolean canPlaceItem(int slot, ItemStack stack) {
            return stack.is((Item)AnimalPensItemRegistry.ANIMAL_CAGE.get());
        }

        public void setChanged() {
            super.setChanged();
            AnimalPenTileEntity.this.triggerUpdate();
        }
    };
    private Animal storedAnimal;
    private long displaySize = -1L;
    private int tickCounter;
    private final List<Integer> deathTicker = new ArrayList<Integer>();
    public static final String TAG_INVENTORY = "inventory";
    public static final String TAG_DEATH_TICKER = "death_ticker";
    public static final String TAG_DISPLAY_SIZE = "display_size";

    public AnimalPenTileEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)AnimalPenTileEntityRegistry.ANIMAL_PEN_TILE_ENTITY.get(), blockPos, blockState);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_INVENTORY, (Tag)this.inventory.createTag(provider));
        if (!this.deathTicker.isEmpty()) {
            tag.put(TAG_DEATH_TICKER, (Tag)new IntArrayTag(this.deathTicker.stream().mapToInt(i -> i).toArray()));
        }
        tag.putLong(TAG_DISPLAY_SIZE, this.displaySize);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.inventory.clearContent();
        this.deathTicker.clear();
        this.storedAnimal = null;
        this.inventory.fromTag(tag.getListOrEmpty(TAG_INVENTORY), provider);
        tag.getIntArray(TAG_DEATH_TICKER).ifPresent(deaths -> {
            for (int death : deaths) {
                this.deathTicker.add(death);
            }
        });
        this.displaySize = tag.getLongOr(TAG_DISPLAY_SIZE, -1L);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    public Animal getStoredAnimal() {
        if (this.storedAnimal == null && !this.getItemStack().isEmpty()) {
            CustomData customData = (CustomData)this.getItemStack().get(DataComponents.ENTITY_DATA);
            if (customData == null) {
                return this.storedAnimal;
            }
            CompoundTag tag = customData.copyTag();
            if (!tag.contains("id") || this.level == null) {
                return this.storedAnimal;
            }
            EntityType.create((CompoundTag)tag, (Level)this.level, (EntitySpawnReason)EntitySpawnReason.TRIGGERED).map(entity -> (Animal)entity).ifPresent(animal -> {
                this.storedAnimal = animal;
            });
        } else if (this.storedAnimal != null && this.getItemStack().isEmpty()) {
            this.storedAnimal = null;
        }
        return this.storedAnimal;
    }

    public List<Integer> getDeathTicker() {
        return this.deathTicker;
    }

    public int getTickCounter() {
        return this.tickCounter;
    }

    public void tick() {
        ++this.tickCounter;
        if (this.getLevel() == null || this.getLevel().isClientSide()) {
            return;
        }
        boolean updated = false;
        Animal animal = this.getStoredAnimal();
        if (animal != null && ((AnimalPenInterface)animal).animalPenTick(this)) {
            updated = true;
        }
        for (int i = 0; i < this.deathTicker.size(); ++i) {
            this.deathTicker.set(i, this.deathTicker.get(i) + 1);
            updated = true;
        }
        this.deathTicker.removeIf(integer -> integer > 20);
        if (updated) {
            this.triggerUpdate();
        }
    }

    public boolean processContainer(Player player, InteractionHand interactionHand) {
        if (this.inventory.isEmpty()) {
            ItemStack itemInHand = player.getItemInHand(interactionHand);
            if (!itemInHand.has(DataComponents.ENTITY_DATA)) {
                return false;
            }
            if (!player.level().isClientSide()) {
                this.inventory.addItem(itemInHand);
                player.setItemInHand(interactionHand, ItemStack.EMPTY);
            }
            return true;
        }
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        if (!itemInHand.has(DataComponents.ENTITY_DATA)) {
            if (!player.isCrouching()) {
                return false;
            }
            if (player.level().isClientSide()) {
                return true;
            }
            Animal animal = this.getStoredAnimal();
            if (animal == null) {
                return false;
            }
            long currentCount = ((AnimalPenInterface)animal).animalPenGetCount();
            if (currentCount < 2L) {
                return false;
            }
            long newCount = currentCount / 2L;
            if (!((AnimalPenInterface)animal).animalPenUpdateCount(-newCount)) {
                return false;
            }
            CompoundTag tag = new CompoundTag();
            animal.save(tag);
            tag.putLong("animal_count", newCount);
            itemInHand.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
            player.setItemInHand(interactionHand, itemInHand);
            this.inventory.setChanged();
            return true;
        }
        Animal animal = this.getStoredAnimal();
        CompoundTag itemInHandTag = ((CustomData)itemInHand.get(DataComponents.ENTITY_DATA)).copyTag();
        if (animal == null || !itemInHandTag.getString("id").equals(animal.getType().arch$registryName().toString())) {
            return false;
        }
        if (player.level().isClientSide()) {
            return true;
        }
        long newCount = itemInHandTag.getLongOr("animal_count", 0L);
        if (newCount <= 0L || !((AnimalPenInterface)animal).animalPenUpdateCount(newCount)) {
            return false;
        }
        if (newCount > 1L && !AnimalCageItem.canMergeAnimalVariants(this.getItemStack(), itemInHand, player)) {
            ((AnimalPenInterface)animal).animalPenUpdateCount(-1L);
            itemInHandTag.putLong("animal_count", 1L);
            itemInHand.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)itemInHandTag));
        } else {
            AnimalCageItem.mergeAnimalVariants(this.getItemStack(), itemInHand, player);
            itemInHand.remove(DataComponents.ENTITY_DATA);
            itemInHand.remove((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
        }
        player.setItemInHand(interactionHand, itemInHand);
        this.inventory.setChanged();
        return true;
    }

    public boolean interactWithPen(Player player, InteractionHand interactionHand) {
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        if (itemInHand.isEmpty() && !this.inventory.isEmpty()) {
            if (player.isCrouching() && !player.level().isClientSide()) {
                ItemStack item = this.getItemStack();
                player.setItemInHand(interactionHand, item);
                this.inventory.setItem(0, ItemStack.EMPTY);
                this.inventory.setChanged();
            }
            return true;
        }
        Animal animal = this.getStoredAnimal();
        if (animal == null) {
            return false;
        }
        if (((AnimalPenInterface)animal).animalPenInteract(player, interactionHand, this.getBlockPos())) {
            ItemStack item = this.getItemStack();
            CompoundTag tag = new CompoundTag();
            animal.save(tag);
            item.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
            this.inventory.setChanged();
            return true;
        }
        return false;
    }

    public void attackThePen(Player player, Level level) {
        ItemStack weapon = player.getItemInHand(InteractionHand.MAIN_HAND);
        Animal animal = this.getStoredAnimal();
        if (animal == null) {
            return;
        }
        if (!((AnimalPenInterface)animal).animalPenUpdateCount(-1L)) {
            return;
        }
        weapon.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
        this.deathTicker.add(0);
        if (((AnimalPenInterface)animal).animalPenGetCount() <= 0L) {
            ItemStack item = this.getItemStack();
            item.remove(DataComponents.ENTITY_DATA);
            item.remove((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
            Block.popResource((Level)level, (BlockPos)this.getBlockPos().above(), (ItemStack)item);
            this.inventory.setItem(0, ItemStack.EMPTY);
        }
        this.triggerUpdate();
        Vec3 position = new Vec3((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ());
        LootTable lootTable = level.getServer().reloadableRegistries().getLootTable((ResourceKey)animal.getLootTable().get());
        LootParams.Builder paramsBuilder = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, (Object)position).withParameter(LootContextParams.THIS_ENTITY, (Object)animal).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)player).withParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)player).withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)player).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)level.damageSources().playerAttack(player)).withLuck(player.getLuck());
        lootTable.getRandomItems(paramsBuilder.create(LootContextParamSets.ENTITY), level.getRandom().nextLong()).forEach(itemStack -> Block.popResource((Level)level, (BlockPos)this.getBlockPos().above(), (ItemStack)itemStack));
        int reward = animal.getExperienceReward((ServerLevel)level, (Entity)player);
        ExperienceOrb.award((ServerLevel)((ServerLevel)this.level), (Vec3)position.add(0.5, 1.0, 0.5), (int)reward);
    }

    private void triggerUpdate() {
        this.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            Animal animal = this.getStoredAnimal();
            if (animal != null) {
                CompoundTag tag = new CompoundTag();
                animal.save(tag);
                this.getItemStack().set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
            }
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    private ItemStack getItemStack() {
        return this.inventory.getItem(0);
    }

    public void preRemoveSideEffects(BlockPos blockPos, BlockState blockState) {
        if (this.level != null) {
            Containers.dropContents((Level)this.level, (BlockPos)blockPos, (NonNullList)this.inventory.getItems());
        }
    }

    @Override
    public ListTag getEntityVariants() {
        if (this.getStoredAnimal() == null) {
            return new ListTag();
        }
        return AnimalCageItem.getAnimalVariants(this.getItemStack()).orElseGet(ListTag::new);
    }

    @Override
    public long getAnimalDisplaySize() {
        return this.displaySize < 1L ? this.getAnimalCount() : Math.min(this.displaySize, this.getAnimalCount());
    }

    @Override
    public void setAnimalDisplaySize(long size) {
        this.displaySize = size;
        this.triggerUpdate();
    }

    @Override
    public void updateAnimalVariant(CompoundTag animalVariant) {
        if (this.getStoredAnimal() == null || animalVariant == null || animalVariant.isEmpty()) {
            return;
        }
        CompoundTag extraData = new CompoundTag();
        ((AnimalPenInterface)this.storedAnimal).animalPenSaveTag(extraData);
        this.storedAnimal.load(animalVariant);
        ((AnimalPenInterface)this.storedAnimal).animalPenLoadTag(extraData);
        this.triggerUpdate();
    }

    @Override
    public void removeAnimalVariant(int index) {
        if (this.getStoredAnimal() == null || this.getEntityVariants().size() <= index) {
            return;
        }
        CustomData customData = (CustomData)this.getItemStack().get((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
        if (customData == null) {
            return;
        }
        this.getItemStack().set((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get(), (Object)customData.update(tag -> tag.getList("animal_variants").ifPresent(list -> list.remove(index))));
        this.inventory.setChanged();
    }

    @Override
    public long getAnimalCount() {
        return this.getStoredAnimal() == null ? 0L : ((AnimalPenInterface)this.getStoredAnimal()).animalPenGetCount();
    }

    @Override
    public boolean canGrowEntity() {
        return AnimalPen.CONFIG_MANAGER.getConfiguration().isGrowAnimals();
    }

    @Override
    public List<Pair<ItemStack, Component>> getCooldownLines() {
        if (this.getStoredAnimal() == null) {
            return Collections.emptyList();
        }
        return ((AnimalPenInterface)this.storedAnimal).animalPenGetLines(this.getTickCounter());
    }
}

