/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.items;

import java.util.Optional;
import java.util.function.Consumer;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.blocks.entities.AnimalPenTileEntity;
import lv.id.bonne.animalpen.registries.AnimalPenDataComponentRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimalCageItem
extends Item {
    public static final String TAG_ENTITY_ID = "id";
    public static final String TAG_VARIANTS = "animal_variants";
    public static final String TAG_AMOUNT = "animal_count";

    public AnimalCageItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(itemStack, tooltipContext, tooltipDisplay, list, tooltipFlag);
        if (itemStack.has(DataComponents.ENTITY_DATA)) {
            list.accept((Component)Component.translatable((String)"item.animal_pen.animal_cage.entity", (Object[])new Object[]{AnimalCageItem.getEntityTranslationName(((CustomData)itemStack.get(DataComponents.ENTITY_DATA)).copyTag().getStringOr(TAG_ENTITY_ID, ""))}).withStyle(ChatFormatting.GRAY));
        }
        if (itemStack.has(DataComponents.ENTITY_DATA)) {
            list.accept((Component)Component.translatable((String)"item.animal_pen.animal_cage.amount", (Object[])new Object[]{((CustomData)itemStack.get(DataComponents.ENTITY_DATA)).copyTag().getLongOr(TAG_AMOUNT, 0L)}).withStyle(ChatFormatting.GRAY));
        }
        if (!itemStack.has(DataComponents.ENTITY_DATA)) {
            list.accept((Component)Component.translatable((String)"item.animal_pen.animal_cage.tip").withStyle(ChatFormatting.GRAY));
        }
        list.accept((Component)Component.translatable((String)"item.animal_pen.animal_cage.warning").withStyle(ChatFormatting.GRAY));
    }

    @NotNull
    public InteractionResult interactLivingEntity(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand interactionHand) {
        CompoundTag itemTag;
        AbstractHorse horse;
        TamableAnimal tamableAnimal;
        InteractionResult interactionResult = super.interactLivingEntity(itemStack, player, livingEntity, interactionHand);
        if (interactionResult == InteractionResult.FAIL) {
            player.displayClientMessage((Component)Component.translatable((String)"item.animal_pen.animal_cage.error.unknown").withStyle(ChatFormatting.DARK_RED), true);
            return interactionResult;
        }
        if (player.level().isClientSide() || livingEntity instanceof Player || !livingEntity.isAlive()) {
            return InteractionResult.FAIL;
        }
        if (AnimalPen.CONFIG_MANAGER.getConfiguration().isBlocked(livingEntity.getType())) {
            player.displayClientMessage((Component)Component.translatable((String)"item.animal_pen.animal_cage.error.blocked").withStyle(ChatFormatting.DARK_RED), true);
            return InteractionResult.FAIL;
        }
        if (!livingEntity.isAlive() || livingEntity.isBaby()) {
            player.displayClientMessage((Component)Component.translatable((String)"item.animal_pen.animal_cage.error.baby").withStyle(ChatFormatting.DARK_RED), true);
            return InteractionResult.FAIL;
        }
        if (!(livingEntity instanceof Animal)) {
            player.displayClientMessage((Component)Component.translatable((String)"item.animal_pen.animal_cage.error.not_animal").withStyle(ChatFormatting.DARK_RED), true);
            return InteractionResult.FAIL;
        }
        Animal animal = (Animal)livingEntity;
        if (livingEntity instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)livingEntity).isTame() || livingEntity instanceof AbstractHorse && (horse = (AbstractHorse)livingEntity).isTamed()) {
            player.displayClientMessage((Component)Component.translatable((String)"item.animal_pen.animal_cage.error.tame").withStyle(ChatFormatting.DARK_RED), true);
            return InteractionResult.FAIL;
        }
        if (!this.matchEntity(itemStack, livingEntity)) {
            player.displayClientMessage((Component)Component.translatable((String)"item.animal_pen.animal_cage.error.wrong").withStyle(ChatFormatting.DARK_RED), true);
            return InteractionResult.FAIL;
        }
        if (!itemStack.has(DataComponents.ENTITY_DATA)) {
            itemTag = new CompoundTag();
            animal.save(itemTag);
        } else {
            itemTag = ((CustomData)itemStack.get(DataComponents.ENTITY_DATA)).copyTag();
        }
        if (itemTag.contains(TAG_AMOUNT)) {
            long maxCount = AnimalPen.CONFIG_MANAGER.getConfiguration().getMaximalAnimalCount();
            if (maxCount > 0L && itemTag.getLongOr(TAG_AMOUNT, 0L) + 1L > maxCount) {
                return InteractionResult.FAIL;
            }
            itemTag.putLong(TAG_AMOUNT, itemTag.getLongOr(TAG_AMOUNT, 0L) + 1L);
        }
        itemStack.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)itemTag));
        AnimalCageItem.storeAnimalVariant(itemStack, animal, player);
        player.setItemInHand(interactionHand, itemStack);
        livingEntity.remove(Entity.RemovalReason.DISCARDED);
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext useOnContext) {
        if (useOnContext.getLevel().isClientSide()) {
            return super.useOn(useOnContext);
        }
        BlockEntity blockEntity = useOnContext.getLevel().getBlockEntity(useOnContext.getClickedPos());
        if (!(blockEntity instanceof AnimalPenTileEntity)) {
            return super.useOn(useOnContext);
        }
        AnimalPenTileEntity tileEntity = (AnimalPenTileEntity)blockEntity;
        if (useOnContext.getPlayer() != null && tileEntity.processContainer(useOnContext.getPlayer(), useOnContext.getHand())) {
            return InteractionResult.SUCCESS;
        }
        return super.useOn(useOnContext);
    }

    private boolean matchEntity(ItemStack itemStack, LivingEntity entity) {
        if (!itemStack.has(DataComponents.ENTITY_DATA)) {
            return true;
        }
        return ((CustomData)itemStack.get(DataComponents.ENTITY_DATA)).copyTag().getString(TAG_ENTITY_ID).map(entityType -> ResourceLocation.bySeparator((String)entityType, (char)':').equals((Object)entity.getType().arch$registryName())).orElse(false);
    }

    private static Component getEntityTranslationName(String entityId) {
        EntityType entityType = EntityType.byString((String)entityId).orElse(null);
        if (entityType != null) {
            return entityType.getDescription();
        }
        return Component.translatable((String)entityId);
    }

    public static Optional<ListTag> getAnimalVariants(ItemStack itemStack) {
        if (!itemStack.has((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get())) {
            return Optional.empty();
        }
        CustomData customData = (CustomData)itemStack.get((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
        if (customData == null) {
            return Optional.empty();
        }
        CompoundTag tag = customData.copyTag();
        return tag.getList(TAG_VARIANTS);
    }

    public static boolean storeAnimalVariant(ItemStack itemStack, Animal animal, @Nullable Player player) {
        if (AnimalPen.CONFIG_MANAGER.getConfiguration().getMaxStoredVariants() <= 0) {
            return false;
        }
        CustomData customData = (CustomData)itemStack.get((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
        CompoundTag itemTag = customData == null ? new CompoundTag() : customData.copyTag();
        ListTag variantList = itemTag.getListOrEmpty(TAG_VARIANTS);
        if (variantList.size() + 1 > AnimalPen.CONFIG_MANAGER.getConfiguration().getMaxStoredVariants()) {
            if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)"item.animal_pen.animal_cage.error.too_many_variants").withStyle(ChatFormatting.DARK_RED), true);
            }
            return false;
        }
        CompoundTag variant = new CompoundTag();
        animal.save(variant);
        variantList.add((Object)variant);
        itemTag.put(TAG_VARIANTS, (Tag)variantList);
        itemStack.set((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get(), (Object)CustomData.of((CompoundTag)itemTag));
        return true;
    }

    public static boolean canMergeAnimalVariants(ItemStack mainItem, ItemStack redundantItem, @Nullable Player player) {
        if (AnimalPen.CONFIG_MANAGER.getConfiguration().getMaxStoredVariants() <= 0) {
            return true;
        }
        CustomData mainData = (CustomData)mainItem.get((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
        CustomData redundantData = (CustomData)redundantItem.get((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
        if (redundantData == null) {
            return true;
        }
        CompoundTag itemTag = mainData == null ? new CompoundTag() : mainData.copyTag();
        CompoundTag redundantTag = redundantData.copyTag();
        ListTag variantList = itemTag.getListOrEmpty(TAG_VARIANTS);
        ListTag redundantList = redundantTag.getListOrEmpty(TAG_VARIANTS);
        if (variantList.size() + redundantList.size() > AnimalPen.CONFIG_MANAGER.getConfiguration().getMaxStoredVariants()) {
            if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)"item.animal_pen.animal_cage.error.too_many_variants").withStyle(ChatFormatting.DARK_RED), true);
            }
            return false;
        }
        return true;
    }

    public static void mergeAnimalVariants(ItemStack mainItem, ItemStack redundantItem, @Nullable Player player) {
        if (AnimalPen.CONFIG_MANAGER.getConfiguration().getMaxStoredVariants() <= 0) {
            return;
        }
        CustomData mainData = (CustomData)mainItem.get((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
        CustomData redundantData = (CustomData)redundantItem.get((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get());
        if (redundantData == null) {
            return;
        }
        CompoundTag itemTag = mainData == null ? new CompoundTag() : mainData.copyTag();
        CompoundTag redundantTag = redundantData.copyTag();
        ListTag variantList = itemTag.getListOrEmpty(TAG_VARIANTS);
        ListTag redundantList = redundantTag.getListOrEmpty(TAG_VARIANTS);
        for (Tag tag : redundantList) {
            if (variantList.size() + 1 > AnimalPen.CONFIG_MANAGER.getConfiguration().getMaxStoredVariants()) {
                if (player == null) break;
                player.displayClientMessage((Component)Component.translatable((String)"item.animal_pen.animal_cage.error.too_many_variants").withStyle(ChatFormatting.DARK_RED), true);
                break;
            }
            variantList.add((Object)tag);
        }
        itemTag.put(TAG_VARIANTS, (Tag)variantList);
        mainItem.set((DataComponentType)AnimalPenDataComponentRegistry.ENTITY_VARIANTS.get(), (Object)CustomData.of((CompoundTag)itemTag));
    }
}

