/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import lv.id.bonne.animalpen.blocks.behaviour.UseToolsBehaviour;
import lv.id.bonne.animalpen.commands.AnimalPenCommands;
import lv.id.bonne.animalpen.config.Configuration;
import lv.id.bonne.animalpen.config.ConfigurationManager;
import lv.id.bonne.animalpen.listeners.AnimalFoodReloadListener;
import lv.id.bonne.animalpen.mixin.accessors.DispenserBlockAccessor;
import lv.id.bonne.animalpen.network.packets.AnimalFoodRegistryData;
import lv.id.bonne.animalpen.network.packets.RemoveDisplayAnimalData;
import lv.id.bonne.animalpen.network.packets.UpdateConfigurationData;
import lv.id.bonne.animalpen.network.packets.UpdateDisplayAnimalData;
import lv.id.bonne.animalpen.network.packets.UpdateVariantScreenData;
import lv.id.bonne.animalpen.registries.AnimalPenBlockRegistry;
import lv.id.bonne.animalpen.registries.AnimalPenDataComponentRegistry;
import lv.id.bonne.animalpen.registries.AnimalPenFoodRegistry;
import lv.id.bonne.animalpen.registries.AnimalPenTileEntityRegistry;
import lv.id.bonne.animalpen.registries.AnimalPensCreativeTabRegistry;
import lv.id.bonne.animalpen.registries.AnimalPensItemRegistry;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import org.slf4j.Logger;

public final class AnimalPen {
    public static final String MOD_ID = "animal_pen";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final ConfigurationManager CONFIG_MANAGER = new ConfigurationManager();
    public static DateTimeFormatter DATE_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();

    public static void init() {
        AnimalPenDataComponentRegistry.register();
        AnimalPensCreativeTabRegistry.register();
        AnimalPenBlockRegistry.register();
        AnimalPensItemRegistry.register();
        AnimalPenTileEntityRegistry.register();
        CONFIG_MANAGER.readConfig();
        CommandRegistrationEvent.EVENT.register((dispatcher, registry, selection) -> AnimalPenCommands.register((CommandDispatcher<CommandSourceStack>)dispatcher));
        DispenserBlock.registerBehavior((ItemLike)Items.SHEARS, (DispenseItemBehavior)new UseToolsBehaviour(DispenserBlockAccessor.getDispenserRegistry().get(Items.SHEARS)));
        DispenserBlock.registerBehavior((ItemLike)Items.GLASS_BOTTLE, (DispenseItemBehavior)new UseToolsBehaviour(DispenserBlockAccessor.getDispenserRegistry().get(Items.GLASS_BOTTLE)));
        DispenserBlock.registerBehavior((ItemLike)Items.BUCKET, (DispenseItemBehavior)new UseToolsBehaviour(DispenserBlockAccessor.getDispenserRegistry().get(Items.BUCKET)));
        DispenserBlock.registerBehavior((ItemLike)Items.BOWL, (DispenseItemBehavior)new UseToolsBehaviour(DispenserBlockAccessor.getDispenserRegistry().get(Items.BOWL)));
        DispenserBlock.registerBehavior((ItemLike)Items.WATER_BUCKET, (DispenseItemBehavior)new UseToolsBehaviour(DispenserBlockAccessor.getDispenserRegistry().get(Items.WATER_BUCKET)));
        DispenserBlock.registerBehavior((ItemLike)Items.BRUSH, (DispenseItemBehavior)new UseToolsBehaviour(DispenserBlockAccessor.getDispenserRegistry().get(Items.BRUSH)));
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, UpdateDisplayAnimalData.ID, UpdateDisplayAnimalData.STREAM_CODEC, UpdateDisplayAnimalData::handle);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, RemoveDisplayAnimalData.ID, RemoveDisplayAnimalData.STREAM_CODEC, RemoveDisplayAnimalData::handle);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, UpdateConfigurationData.ID, UpdateConfigurationData.STREAM_CODEC, UpdateConfigurationData::handle);
        ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (PreparableReloadListener)new AnimalFoodReloadListener(), (ResourceLocation)new ResourceLocation(MOD_ID, "animal_foods"));
        EnvExecutor.runInEnv((Env)Env.SERVER, () -> AnimalPen::initializeServer);
    }

    private static void initializeServer() {
        NetworkManager.registerS2CPayloadType(AnimalFoodRegistryData.ID, AnimalFoodRegistryData.STREAM_CODEC);
        NetworkManager.registerS2CPayloadType(UpdateVariantScreenData.ID, UpdateVariantScreenData.STREAM_CODEC);
        PlayerEvent.PLAYER_JOIN.register(player -> NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new AnimalFoodRegistryData(AnimalPenFoodRegistry.getAll())));
    }

    public static Configuration config() {
        return CONFIG_MANAGER.getConfiguration();
    }

    public static void sendDebug(String message) {
        if (AnimalPen.config().isDebug()) {
            LOGGER.debug(message);
        }
    }
}

