/*
 * Decompiled with CFR 0.152.
 */
package lv.id.bonne.animalpen.mixin.animal;

import java.time.LocalTime;
import java.util.List;
import lv.id.bonne.animalpen.AnimalPen;
import lv.id.bonne.animalpen.mixin.animal.AnimalPenAnimal;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Frog.class})
public abstract class AnimalPenFrog
extends AnimalPenAnimal {
    @Unique
    private int animalPen$frogLightCooldown;

    protected AnimalPenFrog(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract FrogVariant m_262365_();

    @Override
    public boolean animalPen$animalPenTick(BlockEntity blockEntity) {
        boolean value = super.animalPen$animalPenTick(blockEntity);
        if (this.animalPen$frogLightCooldown > 0) {
            --this.animalPen$frogLightCooldown;
            return true;
        }
        return value;
    }

    @Override
    public void animalPen$animalPenSaveTag(CompoundTag tag) {
        super.animalPen$animalPenSaveTag(tag);
        tag.m_128405_("frog_light_cooldown", this.animalPen$frogLightCooldown);
    }

    @Override
    public void animalPen$animalPenLoadTag(CompoundTag tag) {
        super.animalPen$animalPenLoadTag(tag);
        this.animalPen$frogLightCooldown = tag.m_128451_("frog_light_cooldown");
    }

    @Override
    public boolean animalPen$animalPenInteract(Player player, InteractionHand hand, BlockPos position) {
        if (super.animalPen$animalPenInteract(player, hand, position)) {
            return true;
        }
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_42258_)) {
            Item frogLightItem;
            if (this.animalPen$frogLightCooldown > 0) {
                AnimalPen.sendDebug("Under cooldown for " + this.animalPen$frogLightCooldown);
                return false;
            }
            if (player.m_9236_().m_5776_()) {
                return true;
            }
            int froglightCount = (int)Math.min(this.animalPen$animalCount, (long)itemStack.m_41613_());
            int dropLimits = AnimalPen.CONFIG_MANAGER.getConfiguration().getDropLimits(Items.f_220222_);
            if (dropLimits > 0) {
                froglightCount = Math.min(froglightCount, dropLimits);
            }
            if ((frogLightItem = this.pen$getFrogLightItem()) == null) {
                return false;
            }
            itemStack.m_41774_(froglightCount);
            if (itemStack.m_41613_() <= 0) {
                player.m_21008_(hand, ItemStack.f_41583_);
            } else {
                player.m_21008_(hand, itemStack);
            }
            while (froglightCount > 0) {
                ItemStack frogLight = new ItemStack((ItemLike)frogLightItem);
                if (froglightCount > 64) {
                    frogLight.m_41764_(64);
                    froglightCount -= 64;
                } else {
                    frogLight.m_41764_(froglightCount);
                    froglightCount = 0;
                }
                Block.m_49840_((Level)player.m_9236_(), (BlockPos)position.m_7494_(), (ItemStack)frogLight);
            }
            player.m_9236_().m_5594_(null, position, SoundEvents.f_215692_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            this.animalPen$frogLightCooldown = AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.m_6095_(), Items.f_42258_, this.animalPen$animalCount);
            AnimalPen.sendDebug("Succeeded at using " + String.valueOf(itemStack.m_41720_().arch$registryName()));
            return true;
        }
        return false;
    }

    @Override
    @Intrinsic
    public List<Pair<ItemStack[], Component>> animalPen$animalPenGetLines(int tick, boolean shortLine) {
        List<Pair<ItemStack[], Component>> lines = super.animalPen$animalPenGetLines(tick, shortLine);
        if (!AnimalPen.config().isShowAllInteractions() && shortLine && AnimalPen.CONFIG_MANAGER.getConfiguration().getEntityCooldown(this.m_6095_(), Items.f_42258_, this.animalPen$animalCount) == 0) {
            return lines;
        }
        MutableComponent component = this.animalPen$frogLightCooldown == 0 ? Component.m_237110_((String)(shortLine ? "display.animal_pen.ready" : "display.animal_pen.full_ready"), (Object[])new Object[]{Component.m_237113_((String)"\ue000"), Component.m_237113_((String)"\ue001")}).m_130940_(ChatFormatting.GREEN) : Component.m_237110_((String)(shortLine ? "display.animal_pen.cooldown" : "display.animal_pen.frog_light_cooldown"), (Object[])new Object[]{Component.m_237113_((String)"\ue000"), Component.m_237113_((String)"\ue001"), LocalTime.of(0, 0, 0).plusSeconds(this.animalPen$frogLightCooldown / 20).format(AnimalPen.DATE_FORMATTER)});
        Item frogLightItem = this.pen$getFrogLightItem();
        if (frogLightItem != null) {
            lines.add((Pair<ItemStack[], Component>)Pair.of((Object)new ItemStack[]{Items.f_42258_.m_7968_(), frogLightItem.m_7968_()}, (Object)component));
        }
        return lines;
    }

    @Override
    @Intrinsic
    public int animalPen$getRedStoneSignal() {
        if (this.animalPen$frogLightCooldown > 0) {
            return super.animalPen$getRedStoneSignal();
        }
        return super.animalPen$getRedStoneSignal() | 4;
    }

    @Unique
    @Nullable
    private Item pen$getFrogLightItem() {
        FrogVariant variant = this.m_262365_();
        Object frogLightItem = variant == FrogVariant.f_218186_ ? Items.f_220222_ : (variant == FrogVariant.f_218187_ ? Items.f_220221_ : (variant == FrogVariant.f_218185_ ? Items.f_220220_ : null));
        return frogLightItem;
    }
}

